/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.DialogComponentProviderPopupActionManager;
import docking.DockingActionProxy;
import docking.DockingDialog;
import docking.DockingWindowManager;
import docking.TaskScheduler;
import docking.Tool;
import docking.action.ActionContextProvider;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.actions.KeyBindingUtils;
import docking.event.mouse.GMouseListenerAdapter;
import docking.menu.DialogToolbarButton;
import docking.util.AnimationUtils;
import docking.widgets.label.GDHtmlLabel;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.StatusListener;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import utility.function.Callback;

public class DialogComponentProvider
implements ActionContextProvider,
StatusListener,
TaskListener {
    private static final Color WARNING_COLOR = new Color(0xFF9900);
    private static final int DEFAULT_DELAY = 750;
    private static final String PROGRESS = "Progress";
    private static final String DEFAULT = "No Progress";
    private static int idCounter;
    private int id = ++idCounter;
    private boolean modal;
    private String title;
    protected JPanel rootPanel;
    private JPanel mainPanel;
    private JComponent workPanel;
    protected JPanel buttonPanel;
    private JPanel statusPanel;
    protected JButton okButton;
    protected JButton applyButton;
    protected JButton cancelButton;
    protected JButton dismissButton;
    private boolean isAlerting;
    private GDHtmlLabel statusLabel;
    private JPanel statusProgPanel;
    private Timer showTimer;
    private TaskScheduler taskScheduler;
    private TaskMonitorComponent taskMonitorComponent;
    private static final KeyStroke ESC_KEYSTROKE;
    private CardLayout progressCardLayout;
    private JButton defaultButton;
    private DockingDialog dialog;
    private Component focusComponent;
    private JPanel toolbar;
    private final Map<DockingActionIf, DialogToolbarButton> actionMap = new HashMap<DockingActionIf, DialogToolbarButton>();
    private final DialogComponentProviderPopupActionManager popupManager = new DialogComponentProviderPopupActionManager(this);
    private final PopupHandler popupHandler = new PopupHandler();
    private final Set<DockingActionIf> dialogActions = new HashSet<DockingActionIf>();
    private Point initialLocation;
    private boolean resizeable = true;
    private boolean rememberLocation = true;
    private boolean rememberSize = true;
    private boolean useSharedLocation = false;
    private boolean isTransient = false;
    private Dimension defaultSize;

    protected DialogComponentProvider(String title) {
        this(title, true, true, true, false);
    }

    protected DialogComponentProvider(String title, boolean modal) {
        this(title, modal, true, true, false);
    }

    protected DialogComponentProvider(String title, boolean modal, boolean includeStatus, boolean includeButtons, boolean canRunTasks) {
        this.modal = modal;
        this.title = title;
        this.rootPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                Dimension minSize = this.getMinimumSize();
                Dimension preferredSize = super.getPreferredSize();
                preferredSize.width = Math.max(minSize.width, preferredSize.width);
                preferredSize.height = Math.max(minSize.height, preferredSize.height);
                return preferredSize;
            }
        };
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rootPanel.add((Component)this.mainPanel, "Center");
        this.taskScheduler = new TaskScheduler(this);
        this.buttonPanel = new JPanel(new GridLayout(1, 0, 6, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.statusPanel = this.buildStatusPanel();
        if (canRunTasks) {
            this.progressCardLayout = new CardLayout();
            this.statusProgPanel = new JPanel(this.progressCardLayout);
            this.taskMonitorComponent = new TaskMonitorComponent();
            this.statusProgPanel.add((Component)this.statusPanel, DEFAULT);
            this.statusProgPanel.add((Component)this.taskMonitorComponent, PROGRESS);
            this.progressCardLayout.show(this.statusProgPanel, DEFAULT);
            this.mainPanel.add((Component)this.statusProgPanel, "South");
        } else if (includeStatus) {
            this.mainPanel.add((Component)this.statusPanel, "South");
        }
        if (includeButtons) {
            JPanel panel = new JPanel(new FlowLayout());
            panel.add(this.buttonPanel);
            this.rootPanel.add((Component)panel, "South");
        }
        this.installEscapeAction();
        this.doInitialize();
    }

    private void installEscapeAction() {
        AbstractAction escAction = new AbstractAction("ESCAPE"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DialogComponentProvider.this.escapeCallback();
            }
        };
        KeyBindingUtils.registerAction((JComponent)this.rootPanel, ESC_KEYSTROKE, escAction, 1);
    }

    protected void doInitialize() {
    }

    public int getId() {
        return this.id;
    }

    public JComponent getComponent() {
        return this.rootPanel;
    }

    protected void repack() {
        if (this.dialog != null) {
            this.dialog.pack();
        }
    }

    protected void setDialogSize(Dimension d) {
        if (this.dialog != null) {
            this.dialog.setSize(d);
        }
    }

    protected Dimension getDialogSize() {
        if (this.dialog != null) {
            return this.dialog.getSize();
        }
        return null;
    }

    public void setBackground(Color color) {
        this.rootPanel.setBackground(color);
    }

    public Color getBackground() {
        return this.rootPanel.getBackground();
    }

    public void setPreferredSize(int width, int height) {
        this.defaultSize = new Dimension(width, height);
    }

    public void setDefaultSize(int width, int height) {
        this.defaultSize = new Dimension(width, height);
    }

    public Dimension getDefaultSize() {
        return this.defaultSize;
    }

    public void setMinimumSize(int width, int height) {
        this.rootPanel.setMinimumSize(new Dimension(width, height));
    }

    public void setMinimumSize(Dimension minSize) {
        this.setMinimumSize(minSize.width, minSize.height);
    }

    protected Rectangle getBounds() {
        return this.rootPanel.getBounds();
    }

    protected Point getLocationOnScreen() {
        return this.rootPanel.getLocationOnScreen();
    }

    public Dimension getPreferredSize() {
        return this.rootPanel.getPreferredSize();
    }

    public void setCursor(Cursor cursor) {
        this.rootPanel.setCursor(cursor);
    }

    protected void addWorkPanel(JComponent comp) {
        this.workPanel = comp;
        this.mainPanel.add((Component)this.workPanel, "Center");
        this.installMouseListener(this.workPanel);
        this.mainPanel.validate();
    }

    protected void removeWorkPanel() {
        if (this.workPanel != null) {
            this.mainPanel.remove(this.workPanel);
            this.uninstallMouseListener(this.workPanel);
            this.mainPanel.validate();
        }
    }

    private void installMouseListener(Component component) {
        if (component instanceof CellRendererPane) {
            return;
        }
        if (component instanceof Container) {
            Component[] comps;
            Container c = (Container)component;
            c.addContainerListener(this.popupHandler);
            for (Component comp : comps = c.getComponents()) {
                this.installMouseListener(comp);
            }
        }
        if (component.isFocusable()) {
            component.addMouseListener(this.popupHandler);
        }
    }

    private void uninstallMouseListener(Component comp) {
        if (comp instanceof CellRendererPane) {
            return;
        }
        if (comp instanceof Container) {
            Component[] comps;
            Container c = (Container)comp;
            c.removeContainerListener(this.popupHandler);
            for (Component comp2 : comps = c.getComponents()) {
                this.uninstallMouseListener(comp2);
            }
        }
        comp.removeMouseListener(this.popupHandler);
    }

    protected void addButton(JButton button) {
        if (this.defaultButton == null && this.buttonPanel.getComponentCount() == 0) {
            this.setDefaultButton(button);
        }
        this.buttonPanel.add(button);
    }

    protected void removeButton(JButton button) {
        this.buttonPanel.remove(button);
        this.rootPanel.validate();
    }

    protected void executeProgressTask(Task task, int delay) {
        if (this.taskMonitorComponent == null) {
            throw new AssertException("Cannot execute tasks in a DialogComponentProvider that has not been created to run taks.");
        }
        if (task.isModal()) {
            throw new IllegalArgumentException("Task cannot be modal");
        }
        task.addTaskListener((TaskListener)this);
        this.taskScheduler.set(task, delay);
    }

    protected void clearScheduledTask() {
        this.taskScheduler.clearScheduledTask();
    }

    protected void cancelCurrentTask() {
        if (this.taskMonitorComponent != null) {
            this.taskMonitorComponent.cancel();
        }
    }

    public void waitForCurrentTask() {
        this.taskScheduler.waitForCurrentTask();
    }

    public boolean isRunningTask() {
        return this.taskScheduler.isBusy();
    }

    protected void addOKButton() {
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic('K');
        this.okButton.setName("OK");
        this.okButton.addActionListener(e -> this.okCallback());
        this.addButton(this.okButton);
    }

    protected void addCancelButton() {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setName("Cancel");
        this.cancelButton.addActionListener(e -> this.cancelCallback());
        this.addButton(this.cancelButton);
    }

    protected void addDismissButton() {
        this.dismissButton = new JButton("Dismiss");
        this.dismissButton.setMnemonic('D');
        this.dismissButton.setName("Dismiss");
        this.dismissButton.addActionListener(e -> this.dismissCallback());
        this.addButton(this.dismissButton);
    }

    protected void addApplyButton() {
        this.applyButton = new JButton("Apply");
        this.applyButton.setMnemonic('A');
        this.applyButton.setName("Apply");
        this.applyButton.addActionListener(e -> this.applyCallback());
        this.addButton(this.applyButton);
    }

    protected void setApplyToolTip(String tooltip) {
        if (this.applyButton != null) {
            this.applyButton.setToolTipText(tooltip);
        }
    }

    protected void setOkButtonText(String text) {
        if (this.okButton != null) {
            this.okButton.setText(text);
        }
    }

    protected void setOkToolTip(String tooltip) {
        if (this.okButton != null) {
            this.okButton.setToolTipText(tooltip);
        }
    }

    protected void setCancelToolTip(String tooltip) {
        if (this.cancelButton != null) {
            this.cancelButton.setToolTipText(tooltip);
        }
    }

    protected void setCancelButtonText(String text) {
        if (this.cancelButton != null) {
            this.cancelButton.setText(text);
        }
    }

    protected void setDismissToolTip(String tooltip) {
        if (this.dismissButton != null) {
            this.dismissButton.setToolTipText(tooltip);
        }
    }

    protected void setOkEnabled(boolean state) {
        if (this.okButton != null) {
            this.okButton.setEnabled(state);
        }
    }

    protected void setCancelEnabled(boolean state) {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(state);
        }
    }

    protected void setApplyEnabled(boolean state) {
        if (this.applyButton != null) {
            this.applyButton.setEnabled(state);
        }
    }

    protected boolean isCancelEnabled() {
        if (this.cancelButton != null) {
            return this.cancelButton.isEnabled();
        }
        return false;
    }

    protected boolean isOKEnabled() {
        if (this.okButton != null) {
            return this.okButton.isEnabled();
        }
        return false;
    }

    protected boolean isApplyEnabled() {
        if (this.applyButton != null) {
            return this.applyButton.isEnabled();
        }
        return false;
    }

    public void setStatusText(String text) {
        this.setStatusText(text, MessageType.INFO);
    }

    public void setStatusText(String message, MessageType type) {
        this.setStatusText(message, type, false);
    }

    public void setStatusText(String message, MessageType type, boolean alert) {
        String text = StringUtils.isBlank((CharSequence)message) ? " " : message;
        Swing.runIfSwingOrRunLater(() -> this.doSetStatusText(text, type, alert));
    }

    private void doSetStatusText(String text, MessageType type, boolean alert) {
        SystemUtilities.assertThisIsTheSwingThread((String)"Setting text must be performed on the Swing thread");
        this.statusLabel.setText(text);
        this.statusLabel.setForeground(this.getStatusColor(type));
        this.updateStatusToolTip();
        if (alert) {
            this.alertMessage();
        }
    }

    protected void alertMessage() {
        this.alertMessage(Callback.dummy());
    }

    protected void alertMessage(Callback alertFinishedCallback) {
        Swing.runIfSwingOrRunLater(() -> this.doAlertMessage(alertFinishedCallback));
    }

    private void doAlertMessage(final Callback alertFinishedCallback) {
        SystemUtilities.assertThisIsTheSwingThread((String)"Alerting must be performed on the Swing thread");
        if (this.isAlerting) {
            return;
        }
        this.isAlerting = true;
        this.mainPanel.validate();
        this.statusLabel.setVisible(false);
        Animator animator = AnimationUtils.pulseComponent(this.statusLabel, 1);
        animator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                DialogComponentProvider.this.statusLabel.setVisible(true);
                alertFinishedCallback.call();
                DialogComponentProvider.this.isAlerting = false;
            }
        });
    }

    protected Color getStatusColor(MessageType type) {
        switch (type) {
            case ALERT: {
                return Color.orange;
            }
            case WARNING: {
                return WARNING_COLOR;
            }
            case ERROR: {
                return Color.red;
            }
        }
        return Color.blue;
    }

    protected void stopProgressTimer() {
        if (this.showTimer != null) {
            this.showTimer.stop();
            this.showTimer = null;
        }
    }

    public void hideTaskMonitorComponent() {
        this.clearProgress();
    }

    protected void showProgressBar(String localTitle, boolean hasProgress, boolean canCancel, int delay) {
        this.taskMonitorComponent.reset();
        Runnable r = () -> {
            if (delay <= 0) {
                this.showProgressBar(localTitle, hasProgress, canCancel);
            } else {
                this.showTimer = new Timer(delay, ev -> {
                    if (this.taskScheduler.isBusy()) {
                        this.showProgressBar(localTitle, hasProgress, canCancel);
                        this.showTimer = null;
                    }
                });
                this.showTimer.setInitialDelay(delay);
                this.showTimer.setRepeats(false);
                this.showTimer.start();
            }
        };
        SystemUtilities.runSwingNow((Runnable)r);
    }

    TaskMonitor showProgress(Task task, int delay) {
        this.showProgressBar(task.getTaskTitle(), task.hasProgress(), task.canCancel(), delay);
        return this.taskMonitorComponent;
    }

    private void showProgressBar(String localTitle, boolean hasProgress, boolean canCancel) {
        if (!this.isVisible()) {
            DockingWindowManager.showDialog(this.getParent(), this);
        }
        this.taskMonitorComponent.setTaskName(localTitle);
        this.taskMonitorComponent.showProgress(hasProgress);
        this.taskMonitorComponent.setCancelButtonVisibility(canCancel);
        this.progressCardLayout.show(this.statusProgPanel, PROGRESS);
        this.rootPanel.validate();
    }

    private void clearProgress() {
        if (this.taskMonitorComponent != null) {
            this.progressCardLayout.show(this.statusProgPanel, DEFAULT);
        }
    }

    private void updateStatusToolTip() {
        String text = this.statusLabel.getText();
        FontMetrics fm = this.statusLabel.getFontMetrics(this.statusLabel.getFont());
        int messageWidth = 0;
        if (fm != null && text != null) {
            messageWidth = fm.stringWidth(text);
        }
        if (messageWidth > this.statusLabel.getWidth()) {
            this.statusLabel.setToolTipText(text);
        } else {
            this.statusLabel.setToolTipText(null);
        }
    }

    public void clearStatusText() {
        Swing.runIfSwingOrRunLater(() -> {
            this.statusLabel.setText(" ");
            this.updateStatusToolTip();
        });
    }

    public String getStatusText() {
        return this.statusLabel.getText();
    }

    protected JLabel getStatusLabel() {
        return this.statusLabel;
    }

    protected TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    protected TaskMonitorComponent getTaskMonitorComponent() {
        return this.taskMonitorComponent;
    }

    public TaskMonitor showTaskMonitorComponent(String localTitle, boolean hasProgress, boolean canCancel) {
        this.showProgressBar(localTitle, hasProgress, canCancel, 750);
        return this.taskMonitorComponent;
    }

    protected void applyCallback() {
        Msg.debug((Object)this, (Object)"Apply button pressed");
    }

    protected void okCallback() {
        Msg.debug((Object)this, (Object)"Ok button pressed");
    }

    protected void cancelCallback() {
        this.close();
    }

    public void close() {
        if (this.isShowing()) {
            this.dialog.close();
        }
    }

    public void dispose() {
        this.cancelCurrentTask();
        this.close();
        this.popupManager.dispose();
        this.dialogActions.forEach(DockingActionIf::dispose);
        this.actionMap.clear();
        this.dialogActions.clear();
    }

    protected void dismissCallback() {
        this.cancelCallback();
    }

    protected void escapeCallback() {
        this.dismissCallback();
    }

    private JPanel buildStatusPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.statusLabel = new GDHtmlLabel(" ");
        this.statusLabel.setName("statusLabel");
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setForeground(Color.blue);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.statusLabel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DialogComponentProvider.this.updateStatusToolTip();
            }
        });
        int height = this.statusLabel.getPreferredSize().height;
        panel.add(Box.createVerticalStrut(height), "West");
        panel.add((Component)this.statusLabel, "Center");
        return panel;
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setStatusJustification(int justification) {
        this.statusLabel.setHorizontalAlignment(justification);
    }

    public void taskCancelled(Task task) {
        this.clearProgress();
        this.setStatusText("operation canceled");
        this.taskScheduler.clearScheduledTask();
    }

    public void taskCompleted(Task task) {
        this.clearProgress();
    }

    public void setFocusComponent(Component focusComponent) {
        this.focusComponent = focusComponent;
        if (focusComponent instanceof JButton && this.defaultButton == null) {
            this.setDefaultButton((JButton)focusComponent);
        }
    }

    public Component getFocusComponent() {
        return this.focusComponent;
    }

    public void setHelpLocation(HelpLocation helpLocation) {
        DockingWindowManager.setHelpLocation(this.rootPanel, helpLocation);
    }

    public HelpLocation getHelpLocation() {
        HelpService helpService = DockingWindowManager.getHelpService();
        return helpService.getHelpLocation((Object)this.rootPanel);
    }

    public void setDefaultButton(JButton button) {
        this.defaultButton = button;
        if (this.isShowing()) {
            this.dialog.getRootPane().setDefaultButton(button);
        }
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
    }

    protected Component getGlassPane() {
        return this.dialog.getRootPane().getGlassPane();
    }

    protected void setGlassPane(Component component) {
        if (this.dialog == null) {
            throw new IllegalStateException("Attempted to set the glass pane before the dialog is shown");
        }
        this.dialog.getRootPane().setGlassPane(component);
        this.dialog.validate();
    }

    public String getTitle() {
        return this.title;
    }

    public void toFront() {
        if (this.dialog != null) {
            this.dialog.toFront();
        }
    }

    void setDialog(DockingDialog dialog) {
        this.dialog = dialog;
    }

    DockingDialog getDialog() {
        return this.dialog;
    }

    protected Component getParent() {
        if (this.dialog == null) {
            return null;
        }
        return this.dialog.getParent();
    }

    public boolean isVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    public boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }

    protected void dialogShown() {
    }

    protected void dialogClosed() {
    }

    public void setInitialLocation(int x, int y) {
        this.initialLocation = new Point(x, y);
    }

    public Point getInitialLocation() {
        return this.initialLocation;
    }

    public void setResizable(boolean resizeable) {
        this.resizeable = resizeable;
    }

    public boolean isResizeable() {
        return this.resizeable;
    }

    @Override
    public ActionContext getActionContext(MouseEvent event) {
        Component c = this.getComponent();
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusedComponent = kfm.getFocusOwner();
        if (focusedComponent != null && SwingUtilities.isDescendingFrom(focusedComponent, c)) {
            c = focusedComponent;
        }
        if (event == null) {
            return new ActionContext(null, c);
        }
        Component sourceComponent = event.getComponent();
        if (sourceComponent != null) {
            c = sourceComponent;
        }
        return new ActionContext(null, c).setSourceObject(event.getSource());
    }

    protected void notifyContextChanged() {
        ActionContext context = this.getActionContext(null);
        if (context == null) {
            context = new ActionContext();
        }
        Set<DockingActionIf> keySet = this.actionMap.keySet();
        for (DockingActionIf action : keySet) {
            action.setEnabled(action.isEnabledForContext(context));
        }
    }

    public Set<DockingActionIf> getActions() {
        return new HashSet<DockingActionIf>(this.dialogActions);
    }

    private void addToolbarAction(DockingActionIf action) {
        if (action.getToolBarData() == null) {
            return;
        }
        if (this.toolbar == null) {
            this.toolbar = new JPanel(new FlowLayout(2, 2, 0));
            this.toolbar.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            this.mainPanel.add((Component)this.toolbar, "North");
        }
        DialogToolbarButton button = new DialogToolbarButton(action, this);
        this.toolbar.add(button);
        this.actionMap.put(action, button);
    }

    public void addAction(DockingActionIf action) {
        this.dialogActions.add(action);
        this.addToolbarAction(action);
        this.popupManager.addAction(action);
        this.addKeyBindingAction(action);
    }

    private void addKeyBindingAction(DockingActionIf action) {
        DockingWindowManager dwm = DockingWindowManager.getActiveInstance();
        if (dwm == null) {
            return;
        }
        Tool tool = dwm.getTool();
        tool.addAction(new DialogActionProxy(action));
    }

    public void removeAction(DockingActionIf action) {
        this.dialogActions.remove(action);
        JButton button = this.actionMap.remove(action);
        if (button != null && this.toolbar != null) {
            this.toolbar.remove(button);
        }
    }

    public void setRememberLocation(boolean rememberLocation) {
        this.rememberLocation = rememberLocation;
    }

    public boolean getRememberLocation() {
        return this.rememberLocation;
    }

    public void setRememberSize(boolean rememberSize) {
        this.rememberSize = rememberSize;
    }

    public boolean getRememberSize() {
        return this.rememberSize;
    }

    public boolean getUseSharedLocation() {
        return this.useSharedLocation;
    }

    public void setUseSharedLocation(boolean useSharedLocation) {
        this.useSharedLocation = useSharedLocation;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public String toString() {
        return this.getTitle();
    }

    static {
        ESC_KEYSTROKE = KeyStroke.getKeyStroke(27, 0);
    }

    private class PopupHandler
    extends GMouseListenerAdapter
    implements ContainerListener {
        private PopupHandler() {
        }

        @Override
        public void popupTriggered(MouseEvent e) {
            ActionContext actionContext = DialogComponentProvider.this.getActionContext(e);
            DialogComponentProvider.this.popupManager.popupMenu(actionContext, e);
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            DialogComponentProvider.this.installMouseListener(e.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            DialogComponentProvider.this.uninstallMouseListener(e.getChild());
        }
    }

    private class DialogActionProxy
    extends DockingActionProxy {
        public DialogActionProxy(DockingActionIf dockingAction) {
            super(dockingAction);
        }

        @Override
        public boolean isAddToPopup(ActionContext context) {
            return false;
        }

        @Override
        public ToolBarData getToolBarData() {
            return null;
        }
    }
}

