/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.callother.CountLeadingZerosOpBehavior;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.memstate.MemoryState;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.program.model.pcode.Varnode;

public class m68kEmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    public m68kEmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.registerPcodeOpBehavior("countLeadingZeros", (OpBehaviorOther)new CountLeadingZerosOpBehavior());
        this.registerPcodeOpBehavior("findFirstOne", new FindFirstOneOpBehavior());
    }

    private static class FindFirstOneOpBehavior
    implements OpBehaviorOther {
        private FindFirstOneOpBehavior() {
        }

        public void evaluate(Emulate emu, Varnode out, Varnode[] inputs) {
            if (out == null) {
                throw new LowlevelError("CALLOTHER: Find First One op missing required output");
            }
            if (inputs.length != 2 || inputs[1].getSize() == 0 || !inputs[1].isRegister()) {
                throw new LowlevelError("CALLOTHER: Find First One op requires one register varnode input");
            }
            Varnode in = inputs[1];
            MemoryState memoryState = emu.getMemoryState();
            long value = memoryState.getValue(in);
            long size = in.getSize() * 8;
            long count = size - 1L;
            long mask = 1L << (int)count;
            while (count >= 0L && (mask & value) == 0L) {
                --count;
                value <<= 1;
            }
            memoryState.setValue(out, count >= 0L ? count : size);
        }
    }
}

