/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.app.plugin.core.analysis.PicProcessor;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class Pic16Analyzer
extends ConstantPropagationAnalyzer {
    private static final String PROCESSOR_NAME = "PIC-16";
    private static final int INSTRUCTION_LENGTH = 2;
    private static final String CODE_SPACE_NAME = "CODE";
    private Register statusReg;
    private Register pclathReg;
    private Register pclReg;
    private Register wReg;
    private Register bsrReg;
    private Register rpStatusReg;
    private Register irpStatusReg;
    private AddressSet disassemblyPoints;

    public Pic16Analyzer() {
        super(PROCESSOR_NAME);
        this.setPriority(AnalysisPriority.DISASSEMBLY.after().after().after());
    }

    public boolean canAnalyze(Program p) {
        Language lang = p.getLanguage();
        this.statusReg = p.getRegister("STATUS");
        this.pclathReg = p.getRegister("PCLATH");
        this.pclReg = p.getRegister("PCL");
        this.wReg = p.getRegister("W");
        this.bsrReg = p.getRegister("BSR");
        this.rpStatusReg = p.getRegister("RP");
        this.irpStatusReg = p.getRegister("IRP");
        return lang.getProcessor() == PicProcessor.PROCESSOR_PIC_16 && this.pclathReg != null;
    }

    public synchronized boolean added(Program p, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        this.disassemblyPoints = new AddressSet();
        return super.added(p, set, monitor, log);
    }

    public AddressSet flowConstants(final Program program, Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(this.trustWriteMemOption){

            public boolean evaluateReference(VarnodeContext context, Instruction instr, int pcodeop, Address address, int size, RefType refType) {
                AddressSpace space = address.getAddressSpace();
                if (address.isExternalAddress()) {
                    return true;
                }
                if (space.hasMappedRegisters()) {
                    return true;
                }
                boolean isCodeSpace = address.getAddressSpace().getName().equals(Pic16Analyzer.CODE_SPACE_NAME);
                if (refType.isComputed() && refType.isFlow() && isCodeSpace) {
                    return true;
                }
                return super.evaluateReference(context, instr, pcodeop, address, size, refType);
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                FlowType flowType = instruction.getFlowType();
                if (!flowType.isFlow()) {
                    return false;
                }
                Reference[] refs = instruction.getReferencesFrom();
                if (refs.length == 1 && refs[0].getReferenceType().isFlow()) {
                    this.writeContext(refs[0].getToAddress(), context);
                    Address dest = refs[0].getToAddress();
                    Pic16Analyzer.this.disassemblyPoints.addRange(dest, dest);
                }
                return false;
            }

            private void writeContext(Address dest, VarnodeContext context) {
                this.flowRegister(dest, context, Pic16Analyzer.this.bsrReg);
                this.flowRegister(dest, context, Pic16Analyzer.this.statusReg);
                this.flowRegister(dest, context, Pic16Analyzer.this.pclathReg);
                this.flowRegister(dest, context, Pic16Analyzer.this.pclReg);
                this.flowRegister(dest, context, Pic16Analyzer.this.wReg);
                this.flowRegister(dest, context, Pic16Analyzer.this.rpStatusReg);
                this.flowRegister(dest, context, Pic16Analyzer.this.irpStatusReg);
                Pic16Analyzer.this.startNewBlock(program, dest);
            }

            private void flowRegister(Address dest, VarnodeContext context, Register reg) {
                ProgramContext programContext = program.getProgramContext();
                if (reg == null) {
                    return;
                }
                RegisterValue rValue = context.getRegisterValue(reg);
                if (rValue == null) {
                    return;
                }
                try {
                    programContext.setRegisterValue(dest, dest, rValue);
                }
                catch (ContextChangeException e) {
                    e.printStackTrace();
                }
            }
        };
        this.startNewBlock(program, flowStart);
        AddressSet result = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        if (!this.disassemblyPoints.isEmpty()) {
            AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)program);
            mgr.disassemble((AddressSetView)this.disassemblyPoints);
        }
        return result;
    }

    private void startNewBlock(Program program, Address flowStart) {
        long instrOffset = flowStart.getOffset();
        RegisterValue pclathValue = program.getProgramContext().getRegisterValue(this.pclathReg, flowStart);
        if (pclathValue != null) {
            return;
        }
        long pclValue = instrOffset / 2L >> 8;
        pclathValue = new RegisterValue(this.pclathReg, BigInteger.valueOf(pclValue));
        try {
            program.getProgramContext().setRegisterValue(flowStart, flowStart, pclathValue);
        }
        catch (ContextChangeException e) {
            e.printStackTrace();
        }
    }
}

