/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.lifecycle.Internal;
import ghidra.pcode.exec.SleighPcodeUseropDefinition;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.floatformat.FloatFormatFactory;
import ghidra.pcode.struct.AssignStmt;
import ghidra.pcode.struct.BlockStmt;
import ghidra.pcode.struct.BreakStmt;
import ghidra.pcode.struct.ContinueStmt;
import ghidra.pcode.struct.DeclStmt;
import ghidra.pcode.struct.DefaultUseropDecl;
import ghidra.pcode.struct.DefaultVar;
import ghidra.pcode.struct.Expr;
import ghidra.pcode.struct.ForStmt;
import ghidra.pcode.struct.GotoStmt;
import ghidra.pcode.struct.IfStmt;
import ghidra.pcode.struct.LangVar;
import ghidra.pcode.struct.LiteralFloatExpr;
import ghidra.pcode.struct.LiteralLongExpr;
import ghidra.pcode.struct.LocalVar;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.RawExpr;
import ghidra.pcode.struct.RawStmt;
import ghidra.pcode.struct.ResultStmt;
import ghidra.pcode.struct.ReturnStmt;
import ghidra.pcode.struct.RoutineStmt;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.WhileStmt;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.StandAloneDataTypeManager;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PcodeParser;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.data.DataTypeParser;
import ghidra.util.exception.CancelledException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import utilities.util.AnnotationUtilities;

public class StructuredSleigh {
    private static final Map<Class<?>, Set<Method>> CACHE_BY_CLASS = new HashMap();
    protected final Label FALL = new FallLabel();
    final PcodeParser parser;
    final SleighLanguage language;
    private final SleighPcodeUseropDefinition.Factory factory;
    private BlockStmt root;
    final Deque<BlockStmt> stack = new LinkedList<BlockStmt>();
    final StandAloneDataTypeManager dtm;
    private final List<DataTypeParser> dtSources = new ArrayList<DataTypeParser>();
    private int nextLabel = 1;
    private int nextTemp = 1;
    DefaultVar nil;

    private static Set<Method> collectDefinitions(Class<? extends StructuredSleigh> cls) {
        return AnnotationUtilities.collectAnnotatedMethods(StructuredUserop.class, cls);
    }

    protected static DataTypeComponent findComponentByName(Composite composite, String name) {
        for (DataTypeComponent dtc : composite.getComponents()) {
            if (!name.equals(dtc.getFieldName())) continue;
            return dtc;
        }
        return null;
    }

    protected StructuredSleigh(Program program) {
        this(program.getCompilerSpec());
        this.addDataTypeSource((DataTypeManager)program.getDataTypeManager());
    }

    protected StructuredSleigh(CompilerSpec cs) {
        this.language = (SleighLanguage)cs.getLanguage();
        this.parser = SleighProgramCompiler.createParser(this.language);
        this.factory = new SleighPcodeUseropDefinition.Factory(this.language);
        this.dtm = new StandAloneDataTypeManager("/", cs.getDataOrganization());
        this.addDataTypeSource((DataTypeManager)this.dtm);
        this.addDataTypeSource((DataTypeManager)BuiltInDataTypeManager.getDataTypeManager());
        this.nil = new DefaultVar(this, DefaultVar.Check.NONE, "__nil", (DataType)DefaultDataType.dataType);
    }

    protected void addDataTypeSource(DataTypeManager source) {
        this.dtSources.add(new DataTypeParser(source, (DataTypeManager)this.dtm, null, DataTypeParser.AllowedDataTypes.ALL));
    }

    protected void addDataTypeSources(Collection<DataTypeManager> sources) {
        for (DataTypeManager src : sources) {
            this.addDataTypeSource(src);
        }
    }

    protected Var lang(String name, DataType type) {
        LangVar lang = new LangVar(this, name, type);
        return lang;
    }

    protected Var reg(Register register, DataType type) {
        return this.lang(register.getName(), type);
    }

    private Var param(String name, DataType type) {
        return new LocalVar(this, name, type);
    }

    protected Var local(String name, DataType type) {
        LocalVar local = new LocalVar(this, name, type);
        new DeclStmt(this, local);
        return local;
    }

    protected Var local(String name, RVal init) {
        LocalVar temp = new LocalVar(this, name, init.getType());
        new AssignStmt(this, temp, init);
        return temp;
    }

    protected Var temp(DataType type) {
        return this.local("__temp" + this.nextTemp++, type);
    }

    protected DataType type(String path) {
        for (DataTypeParser source : this.dtSources) {
            DataType type;
            try {
                type = source.parse(path);
            }
            catch (InvalidDataTypeException e) {
                continue;
            }
            catch (CancelledException e) {
                throw new AssertionError((Object)e);
            }
            if (type == null) continue;
            return type;
        }
        throw new StructuredSleighError("No such type: " + path);
    }

    protected List<DataType> types(String ... paths) {
        return Stream.of(paths).map(this::type).collect(Collectors.toList());
    }

    protected UseropDecl userop(DataType returnType, String name, List<DataType> parameterTypes) {
        return new DefaultUseropDecl(this, returnType, name, parameterTypes);
    }

    protected RVal lit(long val, int size) {
        return new LiteralLongExpr(this, val, size);
    }

    protected RVal litf(float val) {
        return this.litf(val, (DataType)FloatDataType.dataType);
    }

    protected RVal litd(double val) {
        return this.litf(val, (DataType)DoubleDataType.dataType);
    }

    protected RVal litf(double val, DataType type) {
        return new LiteralFloatExpr(this, val, type);
    }

    public Stmt s(String rawStmt) {
        return new RawStmt(this, rawStmt);
    }

    public Expr e(String rawExpr) {
        return new RawExpr(this, rawExpr);
    }

    private IfStmt doIf(RVal cond, Runnable body) {
        return new IfStmt(this, cond, new BlockStmt(this, body));
    }

    protected WrapIf _if(RVal cond, Runnable body) {
        return new WrapIf(this.doIf(cond, body));
    }

    protected void _while(RVal cond, Runnable body) {
        new WhileStmt(this, cond, new BlockStmt(this, body));
    }

    protected void _for(Stmt init, RVal cond, Stmt step, Runnable body) {
        new ForStmt(this, init, cond, step, new BlockStmt(this, body));
    }

    protected void _break() {
        new BreakStmt(this);
    }

    protected void _continue() {
        new ContinueStmt(this);
    }

    protected void _result(RVal result) {
        new ResultStmt(this, result);
    }

    protected void _return(RVal target) {
        new ReturnStmt(this, target);
    }

    protected void _goto(RVal target) {
        new GotoStmt(this, target);
    }

    protected MethodHandles.Lookup getMethodLookup() {
        return MethodHandles.lookup();
    }

    private <T> SleighPcodeUseropDefinition<T> compile(StructuredUserop annot, MethodHandles.Lookup lookup, Method method) {
        MethodHandle handle;
        if (annot == null) {
            throw new IllegalArgumentException("Method " + method + " is missing @" + StructuredUserop.class.getSimpleName() + " annotation.");
        }
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("Method " + method + " having @" + StructuredUserop.class.getSimpleName() + " annotation must return void.");
        }
        try {
            handle = lookup.unreflect(method).bindTo(this);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access " + method + " having @" + StructuredUserop.class.getSimpleName() + " annotation. Override getMethodLookup()");
        }
        SleighPcodeUseropDefinition.Builder builder = this.factory.define(method.getName());
        DataType retType = this.type(annot.type());
        Parameter[] params = method.getParameters();
        List<Map.Entry> paramsAndTypes = Arrays.asList(new Map.Entry[params.length]);
        for (int i = 0; i < params.length; ++i) {
            Parameter p2 = params[i];
            if (p2.getType() != Var.class) {
                throw new IllegalArgumentException("Parameter " + p2 + " of method " + method + " must have type Var.");
            }
            Param pAnnot = p2.getAnnotation(Param.class);
            if (pAnnot == null) {
                throw new StructuredSleighError("No @" + Param.class.getSimpleName() + " annotation of parameter " + p2 + " of method " + method + ".");
            }
            String name = "".equals(pAnnot.name()) ? p2.getName() : pAnnot.name();
            DataType type = this.type(pAnnot.type());
            paramsAndTypes.set(i, Map.entry(name, type));
        }
        builder.params(paramsAndTypes.stream().map(p -> (String)p.getKey()).collect(Collectors.toList()));
        assert (this.stack.isEmpty());
        this.root = new RoutineStmt(this, method.getName(), retType, () -> {
            List args = paramsAndTypes.stream().map(p -> this.param((String)p.getKey(), (DataType)p.getValue())).collect(Collectors.toList());
            try {
                handle.invokeWithArguments(args);
            }
            catch (StructuredSleighError e) {
                throw e;
            }
            catch (Throwable e) {
                throw new StructuredSleighError("Exception processing structured sleigh body", e);
            }
        });
        StringTree source = this.root.generate(this.FALL, this.FALL);
        builder.body(source.toString());
        return builder.build();
    }

    public <T> void generate(Map<String, ? super SleighPcodeUseropDefinition<T>> into) {
        MethodHandles.Lookup lookup = this.getMethodLookup();
        Class<?> cls = this.getClass();
        Set methods = CACHE_BY_CLASS.computeIfAbsent(cls, __ -> StructuredSleigh.collectDefinitions(cls));
        for (Method m : methods) {
            into.put(m.getName(), this.doGenerate(lookup, m));
        }
    }

    public <T> SleighPcodeUseropDefinition<T> generate(Method m) {
        return this.doGenerate(this.getMethodLookup(), m);
    }

    protected <T> SleighPcodeUseropDefinition<T> doGenerate(MethodHandles.Lookup lookup, Method m) {
        return this.compile(m.getAnnotation(StructuredUserop.class), lookup, m);
    }

    public <T> Map<String, SleighPcodeUseropDefinition<T>> generate() {
        HashMap<String, SleighPcodeUseropDefinition<T>> ops = new HashMap<String, SleighPcodeUseropDefinition<T>>();
        this.generate(ops);
        return ops;
    }

    protected int computeFloatSize(DataType type) {
        if (!(type instanceof AbstractFloatDataType)) {
            throw new StructuredSleighError("Must be a floating-point type. Got " + type);
        }
        return type.getLength();
    }

    protected long encodeFloat(double val, int size) {
        return FloatFormatFactory.getFloatFormat((int)size).getEncoding(val);
    }

    protected boolean isAssignable(DataType varType, DataType valType) {
        return varType.isEquivalent(valType);
    }

    protected void emitAssignmentTypeMismatch(LVal lhs, RVal rhs) {
        Msg.warn((Object)this, (Object)("Type mismatch in assignment: " + lhs + " = " + rhs));
    }

    protected void emitParameterCountMismatch(UseropDecl userop, List<RVal> arguments) {
        throw new StructuredSleighError("Parameter/argument count mismatch invoking " + userop.getName() + ": Expected " + userop.getParameterTypes().size() + " but got " + arguments.size());
    }

    protected void emitParameterTypeMismatch(UseropDecl userop, int position, RVal value) {
        Msg.warn((Object)this, (Object)("Type mismatch for parameter " + position + " of " + userop.getName() + ": " + value + " is not a " + userop.getParameterTypes().get(position)));
    }

    protected void emitResultTypeMismatch(RoutineStmt routine, RVal result) {
        Msg.warn((Object)this, (Object)("Type mismatch on result of " + routine.name + ": " + result + " is not a " + routine.retType));
    }

    protected DataType computeDerefType(RVal addr) {
        DataType addrType = addr.getType();
        if (addrType instanceof Pointer) {
            Pointer pointer = (Pointer)addrType;
            return pointer.getDataType();
        }
        this.emitDerefNonPointer(addr);
        return VoidDataType.dataType;
    }

    protected void emitDerefNonPointer(RVal addr) {
        Msg.warn((Object)this, (Object)("Dereference requires pointer type. Got " + addr));
    }

    protected int computeElementLength(RVal addr) {
        DataType pType = addr.getType();
        if (!(pType instanceof Pointer)) {
            throw new StructuredSleighError("Index requires pointer type. Got " + addr);
        }
        DataType eType = ((Pointer)pType).getDataType();
        return eType.getLength();
    }

    protected DataTypeComponent findComponent(RVal addr, String name) {
        DataType aType = addr.getType();
        if (!(aType instanceof Pointer)) {
            throw new StructuredSleighError("Offset requires pointer to composite type. Got " + addr);
        }
        DataType rType = ((Pointer)aType).getDataType();
        if (!(rType instanceof Composite)) {
            throw new StructuredSleighError("Cannot access field of non-Composite pointer " + addr);
        }
        Composite composite = (Composite)rType;
        DataTypeComponent dtc = StructuredSleigh.findComponentByName(composite, name);
        if (dtc == null) {
            throw new StructuredSleighError("No such field '" + name + "' of " + addr);
        }
        if (dtc.isBitFieldComponent()) {
            throw new StructuredSleighError("Bitfield types are not yet supported: '" + dtc + "' of " + addr);
        }
        return dtc;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    protected static @interface StructuredUserop {
        public String type() default "void";
    }

    private final class FallLabel
    implements Label {
        private FallLabel() {
        }

        @Override
        public Label freshOrBorrow() {
            return new FreshLabel();
        }

        @Override
        public StringTree genAnchor() {
            return StringTree.single("");
        }

        @Override
        public StringTree ref() {
            throw new AssertionError();
        }

        @Override
        public StringTree genGoto(Label fall) {
            return StringTree.single("");
        }

        @Override
        public StringTree genGoto(RVal cond, Label fall) {
            throw new AssertionError();
        }
    }

    @Internal
    protected static interface Label {
        public Label freshOrBorrow();

        public StringTree genAnchor();

        public StringTree ref();

        public StringTree genGoto(Label var1);

        public StringTree genGoto(RVal var1, Label var2);
    }

    protected static interface Var
    extends LVal {
        @Override
        public Var cast(DataType var1);

        public String getName();
    }

    protected static interface RVal {
        public DataType getType();

        public RVal cast(DataType var1);

        public LVal deref(AddressSpace var1);

        public LVal deref();

        public RVal notb();

        public RVal noti();

        public RVal eq(RVal var1);

        public RVal eq(long var1);

        public RVal eqf(RVal var1);

        public RVal neq(RVal var1);

        public RVal neq(long var1);

        public RVal neqf(RVal var1);

        public RVal ltiu(RVal var1);

        public RVal ltiu(long var1);

        public RVal ltis(RVal var1);

        public RVal ltis(long var1);

        public RVal ltf(RVal var1);

        public RVal gtiu(RVal var1);

        public RVal gtiu(long var1);

        public RVal gtis(RVal var1);

        public RVal gtis(long var1);

        public RVal gtf(RVal var1);

        public RVal lteiu(RVal var1);

        public RVal lteiu(long var1);

        public RVal lteis(RVal var1);

        public RVal lteis(long var1);

        public RVal ltef(RVal var1);

        public RVal gteiu(RVal var1);

        public RVal gteiu(long var1);

        public RVal gteis(RVal var1);

        public RVal gteis(long var1);

        public RVal gtef(RVal var1);

        public RVal orb(RVal var1);

        public RVal orb(long var1);

        public RVal ori(RVal var1);

        public RVal ori(long var1);

        public RVal xorb(RVal var1);

        public RVal xorb(long var1);

        public RVal xori(RVal var1);

        public RVal xori(long var1);

        public RVal andb(RVal var1);

        public RVal andb(long var1);

        public RVal andi(RVal var1);

        public RVal andi(long var1);

        public RVal shli(RVal var1);

        public RVal shli(long var1);

        public RVal shriu(RVal var1);

        public RVal shriu(long var1);

        public RVal shris(RVal var1);

        public RVal shris(long var1);

        public RVal addi(RVal var1);

        public RVal addi(long var1);

        public RVal addf(RVal var1);

        public RVal subi(RVal var1);

        public RVal subi(long var1);

        public RVal subf(RVal var1);

        public RVal muli(RVal var1);

        public RVal muli(long var1);

        public RVal mulf(RVal var1);

        public RVal diviu(RVal var1);

        public RVal diviu(long var1);

        public RVal divis(RVal var1);

        public RVal divis(long var1);

        public RVal divf(RVal var1);

        public RVal remiu(RVal var1);

        public RVal remiu(long var1);

        public RVal remis(RVal var1);

        public RVal remis(long var1);
    }

    protected static interface LVal
    extends RVal {
        @Override
        public LVal cast(DataType var1);

        public LVal field(String var1);

        public LVal index(RVal var1);

        public LVal index(long var1);

        public StmtWithVal set(RVal var1);

        public StmtWithVal set(long var1);

        public StmtWithVal addiTo(RVal var1);

        public StmtWithVal addiTo(long var1);

        public StmtWithVal inc();
    }

    public static class StructuredSleighError
    extends RuntimeException {
        protected StructuredSleighError(String message) {
            super(message);
        }

        protected StructuredSleighError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    protected static interface Stmt {
    }

    public class WrapIf {
        private final IfStmt _if;

        protected WrapIf(IfStmt _if) {
            this._if = _if;
        }

        public void _else(Runnable body) {
            this._if.addElse(new BlockStmt(StructuredSleigh.this, body));
        }

        public WrapIf _elif(Expr cond, Runnable body) {
            IfStmt _elif = StructuredSleigh.this.doIf(cond, body);
            this._if.addElse(_elif);
            return new WrapIf(_elif);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    protected static @interface Param {
        public String type();

        public String name() default "";
    }

    protected static interface UseropDecl {
        public DataType getReturnType();

        public String getName();

        public List<DataType> getParameterTypes();

        public StmtWithVal call(RVal ... var1);
    }

    private class BorrowedLabel
    implements Label {
        protected final FreshLabel borrowed;

        protected BorrowedLabel(FreshLabel borrowed) {
            this.borrowed = borrowed;
        }

        @Override
        public Label freshOrBorrow() {
            return this;
        }

        @Override
        public StringTree genAnchor() {
            return StringTree.single("");
        }

        @Override
        public StringTree ref() {
            return this.borrowed.ref();
        }

        @Override
        public StringTree genGoto(Label fall) {
            if (this == fall) {
                return StringTree.single("");
            }
            return this.borrowed.genGoto(fall);
        }

        @Override
        public StringTree genGoto(RVal cond, Label fall) {
            if (this == fall) {
                return StringTree.single("");
            }
            return this.borrowed.genGoto(cond, fall);
        }
    }

    protected class FreshLabel
    implements Label {
        private String name = null;

        protected FreshLabel() {
        }

        private String getName() {
            if (this.name != null) {
                return this.name;
            }
            this.name = "L" + StructuredSleigh.this.nextLabel++;
            return this.name;
        }

        @Override
        public Label freshOrBorrow() {
            return new BorrowedLabel(this);
        }

        @Override
        public StringTree genAnchor() {
            if (this.name == null) {
                return StringTree.single("");
            }
            StringTree st = new StringTree();
            st.append("<");
            st.append(this.name);
            st.append(">\n");
            return st;
        }

        @Override
        public StringTree ref() {
            StringTree st = new StringTree();
            st.append("<");
            st.append(this.getName());
            st.append(">");
            return st;
        }

        @Override
        public StringTree genGoto(Label fall) {
            if (this == fall) {
                return StringTree.single("");
            }
            StringTree st = new StringTree();
            st.append("goto ");
            st.append(this.ref());
            st.append(";\n");
            return st;
        }

        @Override
        public StringTree genGoto(RVal cond, Label fall) {
            if (this == fall) {
                return StringTree.single("");
            }
            StringTree st = new StringTree();
            st.append("if ");
            st.append(((RValInternal)cond).generate());
            st.append(" ");
            st.append(this.genGoto(fall));
            return st;
        }
    }

    protected static interface StmtWithVal
    extends Stmt,
    RVal {
    }
}

