/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import com.google.common.collect.Range;
import java.awt.Graphics;

public interface RangedRenderer<N extends Number> {
    public static Range<Double> validateViewRange(Range<? extends Number> fullRange) {
        if (!fullRange.hasLowerBound() || !fullRange.hasUpperBound()) {
            throw new IllegalArgumentException("Cannot have unbounded full range");
        }
        return Range.closed((Comparable)Double.valueOf(((Number)((Object)fullRange.lowerEndpoint())).doubleValue()), (Comparable)Double.valueOf(((Number)((Object)fullRange.upperEndpoint())).doubleValue()));
    }

    public void setFullRange(Range<N> var1);

    public Range<N> getFullRange();

    public Range<Double> getFullRangeDouble();

    public double getSpan();

    default public int interpolate(int w, double val) {
        Range<Double> fullRangeDouble = this.getFullRangeDouble();
        double span = this.getSpan();
        double lower = (Double)fullRangeDouble.lowerEndpoint();
        if (val <= lower) {
            return 0;
        }
        if (val >= (Double)fullRangeDouble.upperEndpoint()) {
            return w;
        }
        double dif = val - lower;
        return (int)(dif / span * (double)w);
    }

    public int getWidth();

    public int getHeight();

    default public void paintRange(Graphics g, Range<N> range) {
        int width = this.getWidth();
        int height = this.getHeight();
        int x1 = range.hasLowerBound() ? this.interpolate(width, ((Number)((Object)range.lowerEndpoint())).doubleValue()) : 0;
        int x2 = range.hasUpperBound() ? this.interpolate(width, ((Number)((Object)range.upperEndpoint())).doubleValue()) : width;
        int y1 = height > 2 ? 1 : 0;
        int y2 = height > 2 ? height - 1 : height;
        g.fillRect(x1, y1, x2 - x1, y2 - y1);
    }
}

