/*
 * Decompiled with CFR 0.152.
 */
package ghidra.test.processors.support;

import generic.timer.GhidraSwinglessTimer;
import generic.timer.TimerCallback;
import ghidra.app.emulator.Emulator;
import ghidra.app.emulator.EmulatorHelper;
import ghidra.app.emulator.MemoryAccessFilter;
import ghidra.pcode.emulate.BreakCallBack;
import ghidra.pcode.emulate.EmulateExecutionState;
import ghidra.pcode.error.LowlevelError;
import ghidra.pcode.memstate.MemoryFaultHandler;
import ghidra.pcode.pcoderaw.PcodeOpRaw;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import ghidra.test.processors.support.ExecutionListener;
import ghidra.test.processors.support.PCodeTestAbstractControlBlock;
import ghidra.test.processors.support.PCodeTestGroup;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class EmulatorTestRunner {
    private Program program;
    private PCodeTestGroup testGroup;
    private EmulatorHelper emuHelper;
    private Emulator emu;
    private ExecutionListener executionListener;
    private volatile boolean haltedOnTimer = false;
    private String lastError;
    private int callOtherErrors;
    private int callOtherCount;
    private TreeSet<String> unimplementedSet = new TreeSet();
    private HashMap<Address, List<DumpPoint>> dumpPointMap = new HashMap();

    public EmulatorTestRunner(final Program program, final PCodeTestGroup testGroup, ExecutionListener executionListener) {
        this.program = program;
        this.testGroup = testGroup;
        this.executionListener = executionListener;
        this.emuHelper = new EmulatorHelper(program);
        this.emu = this.emuHelper.getEmulator();
        this.emuHelper.setMemoryFaultHandler((MemoryFaultHandler)new MyMemoryFaultHandler(executionListener));
        this.emuHelper.registerDefaultCallOtherCallback(new BreakCallBack(){

            public boolean pcodeCallback(PcodeOpRaw op) throws LowlevelError {
                int userOp = (int)op.getInput(0).getOffset();
                String pcodeOpName = this.emulate.getLanguage().getUserDefinedOpName(userOp);
                EmulatorTestRunner.this.unimplementedSet.add(pcodeOpName);
                Object outStr = "";
                Varnode output = op.getOutput();
                if (output != null) {
                    outStr = ", unable to set output " + output.toString(program.getLanguage());
                }
                EmulatorTestRunner.this.executionListener.log(testGroup, "Unimplemented pcodeop '" + pcodeOpName + "' at: " + EmulatorTestRunner.this.emu.getExecuteAddress() + (String)outStr);
                ++EmulatorTestRunner.this.callOtherCount;
                return true;
            }
        });
    }

    public void dispose() {
        this.emuHelper.dispose();
        this.emu = null;
        this.program = null;
        this.executionListener = null;
        this.testGroup = null;
    }

    Set<String> getUnimplementedPcodeops() {
        return this.unimplementedSet;
    }

    public PCodeTestGroup getTestGroup() {
        return this.testGroup;
    }

    public Program getProgram() {
        return this.program;
    }

    public EmulatorHelper getEmulatorHelper() {
        return this.emuHelper;
    }

    public void setContextRegister(RegisterValue ctxRegValue) {
        this.emuHelper.setContextRegister(ctxRegValue);
    }

    public Address getCurrentAddress() {
        return this.emuHelper.getExecutionAddress();
    }

    public Instruction getCurrentInstruction() {
        return this.program.getListing().getInstructionAt(this.emu.getExecuteAddress());
    }

    private void flipBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length / 2; ++i) {
            byte b = bytes[i];
            int otherIndex = bytes.length - i - 1;
            bytes[i] = bytes[otherIndex];
            bytes[otherIndex] = b;
        }
    }

    public RegisterValue getRegisterValue(Register reg) {
        Register baseReg = reg.getBaseRegister();
        byte[] bytes = this.emuHelper.readMemory(baseReg.getAddress(), baseReg.getMinimumByteSize());
        if (!reg.isBigEndian()) {
            this.flipBytes(bytes);
        }
        byte[] maskValue = new byte[2 * bytes.length];
        Arrays.fill(maskValue, (byte)-1);
        System.arraycopy(bytes, 0, maskValue, bytes.length, bytes.length);
        RegisterValue baseValue = new RegisterValue(baseReg, maskValue);
        return baseValue.getRegisterValue(reg);
    }

    public String getRegisterValueString(Register reg) {
        String valStr = this.getRegisterValue(reg).getUnsignedValue().toString(16);
        return StringUtilities.pad((String)valStr, (char)'0', (int)(reg.getMinimumByteSize() * 2));
    }

    public void setRegister(String regName, long value) {
        Register reg = this.program.getRegister(regName);
        if (reg == null) {
            throw new IllegalArgumentException("Undefined register: " + regName);
        }
        this.emuHelper.writeRegister(reg, value);
    }

    public void setRegister(String regName, BigInteger value) {
        Register reg = this.program.getRegister(regName);
        if (reg == null) {
            throw new IllegalArgumentException("Undefined register: " + regName);
        }
        this.emuHelper.writeRegister(reg, value);
    }

    public void addDumpPoint(Address breakAddr, Address dumpAddr, int dumpSize, int elementSize, DumpFormat elementFormat, String comment) {
        List<DumpPoint> list = this.dumpPointMap.get(breakAddr);
        if (list == null) {
            list = new ArrayList<DumpPoint>();
            this.dumpPointMap.put(breakAddr, list);
        }
        list.add(new AddressDumpPoint(breakAddr, dumpAddr, dumpSize, elementSize, elementFormat, comment));
    }

    public void addDumpPoint(Address breakAddr, Register dumpAddrReg, int relativeOffset, AddressSpace dumpAddrSpace, int dumpSize, int elementSize, DumpFormat elementFormat, String comment) {
        List<DumpPoint> list = this.dumpPointMap.get(breakAddr);
        if (list == null) {
            list = new ArrayList<DumpPoint>();
            this.dumpPointMap.put(breakAddr, list);
        }
        list.add(new RegisterRelativeDumpPoint(breakAddr, dumpAddrReg, relativeOffset, dumpAddrSpace, dumpSize, elementSize, elementFormat, comment));
    }

    private void dump(List<DumpPoint> dumpList) {
        for (DumpPoint dumpPoint : dumpList) {
            Address dumpAddr = dumpPoint.getDumpAddress();
            this.executionListener.logState(this, dumpAddr, dumpPoint.dumpSize, dumpPoint.elementSize, dumpPoint.elementFormat, dumpPoint.comment);
        }
    }

    private String getLastFunctionName(PCodeTestGroup testGroup, boolean logError) {
        return testGroup.mainTestControlBlock.getLastFunctionName(this, logError ? this.executionListener : null, testGroup);
    }

    public String getEmuError() {
        return this.lastError;
    }

    public int getCallOtherErrors() {
        return this.callOtherErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(int timeLimitMS, TaskMonitor monitor) throws CancelledException {
        this.testGroup.clearFailures();
        this.lastError = null;
        this.callOtherErrors = 0;
        this.testGroup.mainTestControlBlock.setSprintfEnabled(this, false);
        int alignment = this.program.getLanguage().getInstructionAlignment();
        Address breakOnDoneAddr = EmulatorTestRunner.alignAddress(this.testGroup.mainTestControlBlock.getBreakOnDoneAddress(), alignment);
        Address breakOnPassAddr = EmulatorTestRunner.alignAddress(this.testGroup.mainTestControlBlock.getBreakOnPassAddress(), alignment);
        Address breakOnErrorAddr = EmulatorTestRunner.alignAddress(this.testGroup.mainTestControlBlock.getBreakOnErrorAddress(), alignment);
        this.executionListener.log(this.testGroup, "TestInfo pointers of interest:");
        this.executionListener.log(this.testGroup, " onDone -> " + breakOnDoneAddr);
        this.executionListener.log(this.testGroup, " onPass -> " + breakOnPassAddr);
        this.executionListener.log(this.testGroup, " onError -> " + breakOnErrorAddr);
        this.emuHelper.setBreakpoint(breakOnDoneAddr);
        this.emuHelper.setBreakpoint(breakOnPassAddr);
        this.emuHelper.setBreakpoint(breakOnErrorAddr);
        GhidraSwinglessTimer safetyTimer = null;
        this.haltedOnTimer = false;
        boolean atBreakpoint = false;
        try {
            Address executeAddr;
            if (timeLimitMS > 0) {
                safetyTimer = new GhidraSwinglessTimer(timeLimitMS, new TimerCallback(){

                    public synchronized void timerFired() {
                        EmulatorTestRunner.this.haltedOnTimer = true;
                        EmulatorTestRunner.this.emuHelper.getEmulator().setHalt(true);
                    }
                });
                safetyTimer.setRepeats(false);
                safetyTimer.start();
            }
            while (true) {
                this.callOtherCount = 0;
                boolean success = atBreakpoint ? this.emuHelper.run(monitor) : this.emuHelper.run(EmulatorTestRunner.alignAddress(this.testGroup.functionEntryPtr, alignment), null, monitor);
                String lastFuncName = this.getLastFunctionName(this.testGroup, false);
                String errFileName = this.testGroup.mainTestControlBlock.getLastErrorFile(this);
                int errLineNum = this.testGroup.mainTestControlBlock.getLastErrorLine(this);
                executeAddr = this.emuHelper.getExecutionAddress();
                if (!success) {
                    this.lastError = this.emuHelper.getLastError();
                    this.testGroup.severeTestFailure(lastFuncName, errFileName, errLineNum, this.program, this.executionListener);
                    boolean bl = false;
                    return bl;
                }
                if (this.haltedOnTimer) {
                    this.lastError = "Emulation halted due to execution timeout";
                    this.testGroup.severeTestFailure(lastFuncName, errFileName, errLineNum, this.program, this.executionListener);
                    boolean bl = false;
                    return bl;
                }
                if (executeAddr.equals((Object)breakOnDoneAddr)) {
                    boolean bl = true;
                    return bl;
                }
                if (executeAddr.equals((Object)breakOnPassAddr)) {
                    if (this.callOtherCount != 0) {
                        this.testGroup.testFailed(lastFuncName, errFileName, errLineNum, true, this.program, this.executionListener);
                        ++this.callOtherErrors;
                    } else {
                        this.testGroup.testPassed(lastFuncName, errFileName, errLineNum, this.program, this.executionListener);
                    }
                    atBreakpoint = true;
                    continue;
                }
                if (!executeAddr.equals((Object)breakOnErrorAddr)) break;
                this.testGroup.testFailed(lastFuncName, errFileName, errLineNum, false, this.program, this.executionListener);
                atBreakpoint = true;
            }
            throw new AssertException("Unexpected condition (executeAddr=" + executeAddr + ")");
        }
        finally {
            if (safetyTimer != null) {
                GhidraSwinglessTimer ghidraSwinglessTimer = safetyTimer;
                synchronized (ghidraSwinglessTimer) {
                    safetyTimer.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean executeSingleStep(int stepLimit) {
        this.testGroup.clearFailures();
        this.lastError = null;
        this.callOtherErrors = 0;
        this.callOtherCount = 0;
        int alignment = this.program.getLanguage().getInstructionAlignment();
        HashMap<Address, PCodeTestAbstractControlBlock.FunctionInfo> subFunctionMap = new HashMap<Address, PCodeTestAbstractControlBlock.FunctionInfo>();
        int subFunctionCnt = this.testGroup.controlBlock.getNumberFunctions();
        for (int i = 1; i < subFunctionCnt; ++i) {
            PCodeTestAbstractControlBlock.FunctionInfo functionInfo = this.testGroup.controlBlock.getFunctionInfo(i);
            subFunctionMap.put(EmulatorTestRunner.alignAddress(functionInfo.functionAddr, alignment), functionInfo);
        }
        Address executeAddr = EmulatorTestRunner.alignAddress(this.testGroup.functionEntryPtr, alignment);
        this.emuHelper.writeRegister(this.program.getLanguage().getProgramCounter(), executeAddr.getAddressableWordOffset());
        this.testGroup.mainTestControlBlock.setSprintfEnabled(this, true);
        Address breakOnDoneAddr = EmulatorTestRunner.alignAddress(this.testGroup.mainTestControlBlock.getBreakOnDoneAddress(), alignment);
        Address breakOnPassAddr = EmulatorTestRunner.alignAddress(this.testGroup.mainTestControlBlock.getBreakOnPassAddress(), alignment);
        Address breakOnErrorAddr = EmulatorTestRunner.alignAddress(this.testGroup.mainTestControlBlock.getBreakOnErrorAddress(), alignment);
        Address printfAddr = EmulatorTestRunner.alignAddress(this.testGroup.mainTestControlBlock.getSprintf5Address(), alignment);
        this.executionListener.log(this.testGroup, "TestInfo pointers of interest:");
        this.executionListener.log(this.testGroup, " onDone -> " + breakOnDoneAddr);
        this.executionListener.log(this.testGroup, " onPass -> " + breakOnPassAddr);
        this.executionListener.log(this.testGroup, " onError -> " + breakOnErrorAddr);
        this.executionListener.log(this.testGroup, " printf5 -> " + printfAddr);
        if (!this.dumpPointMap.isEmpty()) {
            this.executionListener.log(this.testGroup, "Dump points:");
            ArrayList<Address> addressList = new ArrayList<Address>(this.dumpPointMap.keySet());
            Collections.sort(addressList);
            for (Address addr : addressList) {
                List<DumpPoint> dumpList = this.dumpPointMap.get(addr);
                for (DumpPoint dumpPoint : dumpList) {
                    this.executionListener.log(this.testGroup, " " + dumpPoint);
                }
            }
        }
        this.executionListener.logState(this);
        int stepCount = 0;
        Address lastAddress = null;
        Address printfCallAddr = null;
        boolean assertTriggered = false;
        PCodeTestAbstractControlBlock.FunctionInfo currentFunction = null;
        MyMemoryAccessFilter memoryFilter = new MyMemoryAccessFilter();
        this.emu.addMemoryAccessFilter((MemoryAccessFilter)memoryFilter);
        try {
            while (true) {
                int errLineNum;
                String errFileName;
                String lastFuncName;
                block31: {
                    block32: {
                        if (!this.emuHelper.step(TaskMonitor.DUMMY)) {
                            this.lastError = this.emuHelper.getLastError();
                            String lastFuncName2 = this.getLastFunctionName(this.testGroup, true);
                            String errFileName2 = this.testGroup.mainTestControlBlock.getLastErrorFile(this);
                            int errLineNum2 = this.testGroup.mainTestControlBlock.getLastErrorLine(this);
                            this.testGroup.severeTestFailure(lastFuncName2, errFileName2, errLineNum2, this.program, this.executionListener);
                            boolean bl = false;
                            return bl;
                        }
                        executeAddr = this.emuHelper.getExecutionAddress();
                        List<DumpPoint> dumpList = this.dumpPointMap.get(executeAddr);
                        if (dumpList != null) {
                            this.dump(dumpList);
                        }
                        if (executeAddr.equals((Object)breakOnDoneAddr)) {
                            boolean errFileName2 = true;
                            return errFileName2;
                        }
                        boolean onPass = executeAddr.equals((Object)breakOnPassAddr);
                        if (!onPass && !executeAddr.equals((Object)breakOnErrorAddr)) break block32;
                        assertTriggered = true;
                        lastFuncName = this.getLastFunctionName(this.testGroup, true);
                        errFileName = this.testGroup.mainTestControlBlock.getLastErrorFile(this);
                        errLineNum = this.testGroup.mainTestControlBlock.getLastErrorLine(this);
                        if (onPass) {
                            if (this.callOtherCount != 0) {
                                this.testGroup.testFailed(lastFuncName, errFileName, errLineNum, true, this.program, this.executionListener);
                                ++this.callOtherErrors;
                                this.callOtherCount = 0;
                                break block31;
                            } else {
                                this.testGroup.testPassed(lastFuncName, errFileName, errLineNum, this.program, this.executionListener);
                            }
                            break block31;
                        } else {
                            this.testGroup.testFailed(lastFuncName, errFileName, errLineNum, false, this.program, this.executionListener);
                        }
                        break block31;
                    }
                    if (executeAddr.equals((Object)printfAddr)) {
                        printfCallAddr = lastAddress;
                        memoryFilter.enabled = false;
                        this.executionListener.log(this.testGroup, "printf invocation (log supressed) ...");
                    } else if (printfCallAddr != null && this.isPrintfReturn(executeAddr, printfCallAddr)) {
                        printfCallAddr = null;
                        memoryFilter.enabled = true;
                        String str = this.testGroup.controlBlock.emuReadString(this.emuHelper, this.testGroup.mainTestControlBlock.getPrintfBufferAddress());
                        this.executionListener.log(this.testGroup, "  " + str);
                    } else {
                        PCodeTestAbstractControlBlock.FunctionInfo functionInfo = (PCodeTestAbstractControlBlock.FunctionInfo)subFunctionMap.remove(executeAddr);
                        if (functionInfo != null) {
                            if (currentFunction != null && !assertTriggered) {
                                this.executionListener.log(this.testGroup, "ERROR! Group test never executed pass/fail: " + currentFunction);
                            }
                            currentFunction = functionInfo;
                            assertTriggered = functionInfo.numberOfAsserts == 0;
                            this.executionListener.log(this.testGroup, "-------- " + functionInfo.functionName + " (" + functionInfo.numberOfAsserts + functionInfo.numberOfAsserts + "-Asserts) --------");
                        }
                    }
                }
                if (++stepCount > stepLimit) {
                    this.executionListener.log(this.testGroup, "Emulation halted due to excessive execution steps");
                    lastFuncName = this.getLastFunctionName(this.testGroup, true);
                    errFileName = this.testGroup.mainTestControlBlock.getLastErrorFile(this);
                    errLineNum = this.testGroup.mainTestControlBlock.getLastErrorLine(this);
                    this.testGroup.severeTestFailure(lastFuncName, errFileName, errLineNum, this.program, this.executionListener);
                    boolean bl = false;
                    return bl;
                }
                if (memoryFilter.enabled) {
                    this.executionListener.logState(this);
                }
                lastAddress = executeAddr;
                continue;
                break;
            }
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)"Unexpected Exception", (Throwable)t);
            boolean bl = false;
            return bl;
        }
        finally {
            memoryFilter.dispose();
            ArrayList list = new ArrayList(subFunctionMap.values());
            if (!list.isEmpty()) {
                Collections.sort(list);
                this.executionListener.log(this.testGroup, "The following sub-functions were never executed:");
                for (PCodeTestAbstractControlBlock.FunctionInfo functionInfo : list) {
                    this.executionListener.log(this.testGroup, "  " + functionInfo);
                }
            } else {
                this.executionListener.log(this.testGroup, "All " + (this.testGroup.controlBlock.getNumberFunctions() - 1) + " sub-functions were executed");
            }
        }
    }

    static long alignAddressOffset(long offset, int alignment) {
        return offset / (long)alignment * (long)alignment;
    }

    static Address alignAddress(Address addr, int alignment) {
        long alignedOffset;
        Address alignedAddr = addr;
        long offset = addr.getOffset();
        if (offset != (alignedOffset = EmulatorTestRunner.alignAddressOffset(offset, alignment))) {
            alignedAddr = addr.getNewAddress(alignedOffset);
        }
        return alignedAddr;
    }

    private boolean isPrintfReturn(Address executeAddr, Address printfCallAddr) {
        long offset = executeAddr.getOffset();
        long maxEnd = printfCallAddr.getOffset() + 32L;
        return offset > printfCallAddr.getOffset() && offset <= maxEnd;
    }

    private class MyMemoryFaultHandler
    implements MemoryFaultHandler {
        private ExecutionListener executionListener;

        public MyMemoryFaultHandler(ExecutionListener executionListener) {
            this.executionListener = executionListener;
        }

        public boolean unknownAddress(Address address, boolean write) {
            Address pc = EmulatorTestRunner.this.emuHelper.getExecutionAddress();
            String access = write ? "written" : "read";
            this.executionListener.log(EmulatorTestRunner.this.testGroup, "Unknown address " + access + " at " + pc + ": " + address);
            return false;
        }

        public boolean uninitializedRead(Address address, int size, byte[] buf, int bufOffset) {
            Register reg;
            if (EmulatorTestRunner.this.emu.getEmulateExecutionState() == EmulateExecutionState.INSTRUCTION_DECODE) {
                return false;
            }
            Address pc = EmulatorTestRunner.this.emuHelper.getExecutionAddress();
            if (!address.isUniqueAddress() && (reg = EmulatorTestRunner.this.program.getRegister(address, size)) != null) {
                this.executionListener.log(EmulatorTestRunner.this.testGroup, "Uninitialized register read at " + pc + ": " + reg);
                return true;
            }
            this.executionListener.log(EmulatorTestRunner.this.testGroup, "Uninitialized read at " + pc + ": " + address.toString(true) + ":" + size);
            return true;
        }
    }

    private class AddressDumpPoint
    extends DumpPoint {
        final Address dumpAddr;

        AddressDumpPoint(Address breakAddr, Address dumpAddr, int dumpSize, int elementSize, DumpFormat elementFormat, String comment) {
            super(breakAddr, dumpSize, elementSize, elementFormat, comment);
            this.dumpAddr = dumpAddr;
        }

        @Override
        Address getDumpAddress() {
            return this.dumpAddr;
        }

        public String toString() {
            return this.toString(this.dumpAddr.toString(true));
        }
    }

    public static enum DumpFormat {
        HEX,
        DECIMAL,
        FLOAT;

    }

    private class RegisterRelativeDumpPoint
    extends DumpPoint {
        final Register dumpAddrReg;
        final int relativeOffset;
        final AddressSpace dumpAddrSpace;

        RegisterRelativeDumpPoint(Address breakAddr, Register dumpAddrReg, int relativeOffset, AddressSpace dumpAddrSpace, int dumpSize, int elementSize, DumpFormat elementFormat, String comment) {
            super(breakAddr, dumpSize, elementSize, elementFormat, comment);
            this.dumpAddrReg = dumpAddrReg;
            this.relativeOffset = relativeOffset;
            this.dumpAddrSpace = dumpAddrSpace;
        }

        @Override
        Address getDumpAddress() {
            RegisterValue regVal = EmulatorTestRunner.this.getRegisterValue(this.dumpAddrReg);
            return this.dumpAddrSpace.getAddress(regVal.getUnsignedValue().longValue()).add((long)this.relativeOffset);
        }

        public String toString() {
            return this.toString("0x" + Integer.toHexString(this.relativeOffset) + "[" + this.dumpAddrReg + "]");
        }
    }

    private abstract class DumpPoint {
        final Address breakAddr;
        final int dumpSize;
        final int elementSize;
        final DumpFormat elementFormat;
        final String comment;

        DumpPoint(Address breakAddr, int dumpSize, int elementSize, DumpFormat elementFormat, String comment) {
            this.breakAddr = breakAddr;
            this.dumpSize = dumpSize;
            this.elementSize = elementSize;
            this.elementFormat = elementFormat;
            this.comment = comment;
        }

        abstract Address getDumpAddress();

        public String toString(String addrStr) {
            return this.getClass().getSimpleName() + ": " + this.dumpSize + " " + this.elementSize + "-byte elements at " + addrStr;
        }
    }

    private class MyMemoryAccessFilter
    extends MemoryAccessFilter {
        boolean enabled = true;

        private MyMemoryAccessFilter() {
        }

        protected void processWrite(AddressSpace spc, long off, int size, byte[] values) {
            if (this.enabled) {
                EmulatorTestRunner.this.executionListener.logWrite(EmulatorTestRunner.this, spc.getAddress(off), size, values);
            }
        }

        protected void processRead(AddressSpace spc, long off, int size, byte[] values) {
            if (this.enabled && this.emu.getEmulateExecutionState() != EmulateExecutionState.INSTRUCTION_DECODE) {
                EmulatorTestRunner.this.executionListener.logRead(EmulatorTestRunner.this, spc.getAddress(off), size, values);
            }
        }
    }
}

