/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcode;

import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.util.pcode.AbstractAppender;
import ghidra.app.util.pcode.AbstractPcodeFormatter;
import ghidra.program.model.lang.Language;

public class StringPcodeFormatter
extends AbstractPcodeFormatter<String, ToStringAppender> {
    private static final String EOL = System.getProperty("line.separator");
    private int maxDisplayLines = 0;
    private boolean displayRawPcode = false;

    @Override
    protected ToStringAppender createAppender(Language language, boolean indent) {
        return new ToStringAppender(language, indent);
    }

    @Override
    public boolean isFormatRaw() {
        return this.displayRawPcode;
    }

    @Override
    protected AbstractPcodeFormatter.FormatResult formatOpTemplate(ToStringAppender appender, OpTpl op) {
        if (this.maxDisplayLines > 0 && appender.lineCount >= this.maxDisplayLines) {
            return AbstractPcodeFormatter.FormatResult.TERMINATE;
        }
        AbstractPcodeFormatter.FormatResult result = super.formatOpTemplate(appender, op);
        appender.appendEndOfLine();
        return result;
    }

    static class ToStringAppender
    extends AbstractAppender<String> {
        private final StringBuffer buf = new StringBuffer();
        private int lineCount = 0;

        public ToStringAppender(Language language, boolean labeled) {
            super(language, labeled);
        }

        protected void appendEndOfLine() {
            if (this.buf.length() != 0) {
                this.buf.append(EOL);
            }
            ++this.lineCount;
        }

        @Override
        protected void appendString(String string) {
            this.buf.append(string);
        }

        @Override
        public String finish() {
            return this.buf.toString();
        }
    }
}

