/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.plugin.processors.generic.MemoryBlockDefinition;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.store.LockException;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.InvalidAddressException;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.util.AddressLabelInfo;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.HashUtilities;
import ghidra.util.InvalidNameException;
import ghidra.util.MD5Utilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractProgramLoader
implements Loader {
    public static final String APPLY_LABELS_OPTION_NAME = "Apply Processor Defined Labels";
    public static final String ANCHOR_LABELS_OPTION_NAME = "Anchor Processor Defined Labels";

    protected abstract List<LoadedProgram> loadProgram(ByteProvider var1, String var2, DomainFolder var3, LoadSpec var4, List<Option> var5, MessageLog var6, Object var7, TaskMonitor var8) throws IOException, CancelledException;

    protected abstract boolean loadProgramInto(ByteProvider var1, LoadSpec var2, List<Option> var3, MessageLog var4, Program var5, TaskMonitor var6) throws IOException, CancelledException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<DomainObject> load(ByteProvider provider, String name, DomainFolder folder, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Object consumer, TaskMonitor monitor) throws IOException, CancelledException, InvalidNameException, DuplicateNameException, VersionException {
        if (!this.isOverrideMainProgramName()) {
            folder = ProjectDataUtils.createDomainFolderPath((DomainFolder)folder, (String)name);
        }
        ArrayList<DomainObject> results = new ArrayList<DomainObject>();
        if (!loadSpec.isComplete()) {
            return results;
        }
        List<LoadedProgram> loadedPrograms = this.loadProgram(provider, name, folder, loadSpec, options, messageLog, consumer, monitor);
        boolean success = false;
        try {
            monitor.checkCanceled();
            ArrayList<LoadedProgram> programsToFixup = new ArrayList<LoadedProgram>();
            for (LoadedProgram loadedProgram : loadedPrograms) {
                monitor.checkCanceled();
                Program program = loadedProgram.program();
                this.applyProcessorLabels(options, program);
                program.setEventsEnabled(true);
                if (loadedProgram.destinationFolder() == null) {
                    results.add((DomainObject)program);
                    continue;
                }
                String domainFileName = program.getName();
                if (this.isOverrideMainProgramName() && program == loadedPrograms.get(0).program()) {
                    domainFileName = name;
                }
                if (this.createProgramFile(program, loadedProgram.destinationFolder(), domainFileName, messageLog, monitor)) {
                    results.add((DomainObject)program);
                    programsToFixup.add(loadedProgram);
                    continue;
                }
                program.release(consumer);
            }
            this.postLoadProgramFixups(programsToFixup, options, messageLog, monitor);
            success = true;
        }
        finally {
            if (!success) {
                this.release(loadedPrograms, consumer);
            }
        }
        return results;
    }

    protected boolean isOverrideMainProgramName() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean loadInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog messageLog, Program program, TaskMonitor monitor) throws IOException, CancelledException {
        if (!loadSpec.isComplete()) {
            return false;
        }
        program.setEventsEnabled(false);
        int transactionID = program.startTransaction("Loading - " + this.getName());
        boolean success = false;
        try {
            boolean bl = success = this.loadProgramInto(provider, loadSpec, options, messageLog, program, monitor);
            return bl;
        }
        finally {
            program.endTransaction(transactionID, success);
            program.setEventsEnabled(true);
        }
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean isLoadIntoProgram) {
        ArrayList<Option> list = new ArrayList<Option>();
        list.add(new Option(APPLY_LABELS_OPTION_NAME, this.shouldApplyProcessorLabelsByDefault(), Boolean.class, "-loader-applyLabels"));
        list.add(new Option(ANCHOR_LABELS_OPTION_NAME, true, Boolean.class, "-loader-anchorLabels"));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(APPLY_LABELS_OPTION_NAME) && !name.equals(ANCHOR_LABELS_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
        }
        return null;
    }

    protected void postLoadProgramFixups(List<LoadedProgram> loadedPrograms, List<Option> options, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
    }

    protected boolean shouldApplyProcessorLabelsByDefault() {
        return false;
    }

    protected String generateBlockName(Program program, boolean isOverlay, AddressSpace space) {
        if (!isOverlay) {
            return space.getName();
        }
        AddressFactory factory = program.getAddressFactory();
        int count = 0;
        while (count < 1000) {
            String lname;
            if (factory.getAddressSpace(lname = "ov" + ++count) != null) continue;
            return lname;
        }
        return "ov" + System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Program createProgram(ByteProvider provider, String domainFileName, Address imageBase, String executableFormatName, Language language, CompilerSpec compilerSpec, Object consumer) throws IOException {
        String programName = this.getProgramNameFromSourceData(provider, domainFileName);
        ProgramDB prog = new ProgramDB(programName, language, compilerSpec, consumer);
        prog.setEventsEnabled(false);
        int id = prog.startTransaction("Set program properties");
        try {
            AbstractProgramLoader.setProgramProperties((Program)prog, provider, executableFormatName);
            if (this.shouldSetImageBase((Program)prog, imageBase)) {
                try {
                    prog.setImageBase(imageBase, true);
                }
                catch (AddressOverflowException addressOverflowException) {
                }
                catch (LockException lockException) {
                    // empty catch block
                }
            }
        }
        finally {
            prog.endTransaction(id, true);
        }
        return prog;
    }

    public static void setProgramProperties(Program prog, ByteProvider provider, String executableFormatName) throws IOException {
        FSRL fsrl;
        String md5;
        prog.setExecutablePath(provider.getAbsolutePath());
        if (executableFormatName != null) {
            prog.setExecutableFormat(executableFormatName);
        }
        String string = md5 = (fsrl = provider.getFSRL()) != null && fsrl.getMD5() != null ? fsrl.getMD5() : AbstractProgramLoader.computeBinaryMD5(provider);
        if (fsrl != null) {
            if (fsrl.getMD5() == null) {
                fsrl = fsrl.withMD5(md5);
            }
            prog.getOptions("Program Information").setString("FSRL", fsrl.toString());
        }
        prog.setExecutableMD5(md5);
        String sha256 = AbstractProgramLoader.computeBinarySHA256(provider);
        prog.setExecutableSHA256(sha256);
    }

    private String getProgramNameFromSourceData(ByteProvider provider, String domainFileName) {
        FSRL fsrl = provider.getFSRL();
        if (fsrl != null) {
            return fsrl.getName();
        }
        return domainFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultMemoryBlocks(Program program, Language language, MessageLog log) {
        int id = program.startTransaction("Create default blocks");
        try {
            MemoryBlockDefinition[] defaultMemoryBlocks = language.getDefaultMemoryBlocks();
            if (defaultMemoryBlocks == null) {
                return;
            }
            for (MemoryBlockDefinition blockDef : defaultMemoryBlocks) {
                try {
                    blockDef.createBlock(program);
                }
                catch (LockException e) {
                    throw new AssertException("Unexpected Error");
                }
                catch (MemoryConflictException e) {
                    log.appendMsg("Failed to add language defined memory block due to conflict: " + blockDef);
                }
                catch (AddressOverflowException e) {
                    log.appendMsg("Failed to add language defined memory block due to address error " + blockDef);
                    log.appendMsg(" >> " + e.getMessage());
                }
                catch (InvalidAddressException e) {
                    log.appendMsg("Failed to add language defined memory block due to invalid address: " + blockDef);
                    log.appendMsg(" >> Processor specification error (pspec): " + e.getMessage());
                }
            }
        }
        finally {
            program.endTransaction(id, true);
        }
    }

    public static void markAsFunction(Program program, String name, Address funcStart) {
        FunctionManager functionMgr = program.getFunctionManager();
        if (functionMgr.getFunctionAt(funcStart) != null) {
            return;
        }
        try {
            functionMgr.createFunction(name, funcStart, (AddressSetView)new AddressSet(funcStart, funcStart), SourceType.IMPORTED);
        }
        catch (InvalidInputException invalidInputException) {
        }
        catch (OverlappingFunctionException overlappingFunctionException) {
            // empty catch block
        }
    }

    protected LanguageService getLanguageService() {
        return DefaultLanguageService.getLanguageService();
    }

    protected final void release(List<LoadedProgram> loadedPrograms, Object consumer) {
        for (LoadedProgram loadedProgram : loadedPrograms) {
            loadedProgram.program().release(consumer);
        }
    }

    private boolean createProgramFile(Program program, DomainFolder programFolder, String programName, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, InvalidNameException {
        int uniqueNameIndex = 0;
        Object uniqueName = programName;
        while (!monitor.isCancelled()) {
            try {
                programFolder.createFile((String)uniqueName, (DomainObject)program, monitor);
                break;
            }
            catch (DuplicateFileException e) {
                uniqueName = programName + uniqueNameIndex;
                ++uniqueNameIndex;
            }
            catch (InvalidNameException | CancelledException e) {
                throw e;
            }
            catch (Exception e) {
                Object msg;
                Throwable t = e.getCause();
                if (t == null) {
                    t = e;
                }
                msg = (msg = t.getMessage()) == null ? "" : "\n" + (String)msg;
                Msg.showError((Object)this, null, (String)"Create Program Failed", (Object)("Failed to create program file: " + (String)uniqueName + (String)msg), (Throwable)e);
                messageLog.appendMsg("Unexpected exception creating file: " + (String)uniqueName);
                messageLog.appendException((Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyProcessorLabels(List<Option> options, Program program) {
        int id = program.startTransaction("Finalize load");
        try {
            Language lang = program.getLanguage();
            for (Register reg : lang.getRegisters()) {
                Address addr = reg.getAddress();
                if (!addr.isMemoryAddress()) continue;
                AddressLabelInfo info = new AddressLabelInfo(addr, reg.getName(), reg.isBaseRegister(), SourceType.IMPORTED);
                this.createSymbol(program, info, true);
            }
            if (this.shouldApplyProcessorLabels(options)) {
                boolean anchorSymbols = this.shouldAnchorSymbols(options);
                List labels = lang.getDefaultSymbols();
                for (AddressLabelInfo info : labels) {
                    this.createSymbol(program, info, anchorSymbols);
                }
            }
            GhidraProgramUtilities.removeAnalyzedFlag(program);
        }
        finally {
            program.endTransaction(id, true);
        }
    }

    private void createSymbol(Program program, AddressLabelInfo info, boolean anchorSymbols) {
        SymbolTable symTable = program.getSymbolTable();
        Address addr = info.getAddress();
        Symbol s = symTable.getPrimarySymbol(addr);
        try {
            if (s == null || s.getSource() == SourceType.IMPORTED) {
                Namespace namespace = program.getGlobalNamespace();
                if (info.getScope() != null) {
                    namespace = info.getScope();
                }
                s = symTable.createLabel(addr, info.getLabel(), namespace, info.getSource());
                if (info.isEntry()) {
                    symTable.addExternalEntryPoint(addr);
                }
                if (info.isPrimary()) {
                    s.setPrimary();
                }
                if (anchorSymbols) {
                    s.setPinned(true);
                }
            } else if (s.getSource() == SourceType.DEFAULT) {
                String labelName = info.getLabel();
                if (s.getSymbolType() == SymbolType.FUNCTION) {
                    Function f = (Function)s.getObject();
                    f.setName(labelName, SourceType.IMPORTED);
                } else {
                    s.setName(labelName, SourceType.IMPORTED);
                }
                if (anchorSymbols) {
                    s.setPinned(true);
                }
            }
        }
        catch (DuplicateNameException | InvalidInputException throwable) {
            // empty catch block
        }
    }

    private static String computeBinaryMD5(ByteProvider provider) throws IOException {
        try (InputStream in = provider.getInputStream(0L);){
            String string = MD5Utilities.getMD5Hash((InputStream)in);
            return string;
        }
    }

    private static String computeBinarySHA256(ByteProvider provider) throws IOException {
        try (InputStream in = provider.getInputStream(0L);){
            String string = HashUtilities.getHash((String)HashUtilities.SHA256_ALGORITHM, (InputStream)in);
            return string;
        }
    }

    private boolean shouldSetImageBase(Program prog, Address imageBase) {
        if (imageBase == null || imageBase instanceof SegmentedAddress) {
            return false;
        }
        return imageBase.getAddressSpace() == prog.getAddressFactory().getDefaultAddressSpace();
    }

    private boolean shouldApplyProcessorLabels(List<Option> options) {
        return OptionUtils.getBooleanOptionValue(APPLY_LABELS_OPTION_NAME, options, true);
    }

    private boolean shouldAnchorSymbols(List<Option> options) {
        return OptionUtils.getBooleanOptionValue(ANCHOR_LABELS_OPTION_NAME, options, true);
    }

    public record LoadedProgram(Program program, DomainFolder destinationFolder) {
    }
}

