/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.LoaderTier;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import utilities.util.FileUtilities;

public abstract class AbstractLibrarySupportLoader
extends AbstractProgramLoader {
    public static final String LINK_EXISTING_OPTION_NAME = "Link Existing Project Libraries";
    static final boolean LINK_EXISTING_OPTION_DEFAULT = true;
    public static final String LINK_SEARCH_FOLDER_OPTION_NAME = "Project Library Search Folder";
    static final String LINK_SEARCH_FOLDER_OPTION_DEFAULT = "";
    public static final String LOCAL_LIBRARY_OPTION_NAME = "Load Local Libraries From Disk";
    static final boolean LOCAL_LIBRARY_OPTION_DEFAULT = false;
    public static final String SYSTEM_LIBRARY_OPTION_NAME = "Load System Libraries From Disk";
    static final boolean SYSTEM_LIBRARY_OPTION_DEFAULT = false;
    public static final String DEPTH_OPTION_NAME = "Recursive Library Load Depth";
    static final int DEPTH_OPTION_DEFAULT = 1;
    public static final String LIBRARY_DEST_FOLDER_OPTION_NAME = "Library Destination Folder";
    static final String LIBRARY_DEST_FOLDER_OPTION_DEFAULT = "";

    protected abstract void load(ByteProvider var1, LoadSpec var2, List<Option> var3, Program var4, TaskMonitor var5, MessageLog var6) throws CancelledException, IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<AbstractProgramLoader.LoadedProgram> loadProgram(ByteProvider provider, String programName, DomainFolder programFolder, LoadSpec loadSpec, List<Option> options, MessageLog log, Object consumer, TaskMonitor monitor) throws CancelledException, IOException {
        ArrayList<AbstractProgramLoader.LoadedProgram> loadedProgramList = new ArrayList<AbstractProgramLoader.LoadedProgram>();
        ArrayList<String> libraryNameList = new ArrayList<String>();
        boolean success = false;
        try {
            Program program = this.doLoad(provider, programName, programFolder, loadSpec, libraryNameList, options, consumer, log, monitor);
            loadedProgramList.add(new AbstractProgramLoader.LoadedProgram(program, programFolder));
            List<AbstractProgramLoader.LoadedProgram> libraries = this.loadLibraries(provider, program, programFolder, loadSpec, options, log, consumer, libraryNameList, monitor);
            loadedProgramList.addAll(libraries);
            success = true;
            ArrayList<AbstractProgramLoader.LoadedProgram> arrayList = loadedProgramList;
            return arrayList;
        }
        finally {
            if (!success) {
                this.release(loadedProgramList, consumer);
            }
        }
    }

    @Override
    protected boolean loadProgramInto(ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, Program program, TaskMonitor monitor) throws CancelledException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        LanguageID languageID = program.getLanguageID();
        CompilerSpecID compilerSpecID = program.getCompilerSpec().getCompilerSpecID();
        if (!pair.languageID.equals((Object)languageID) || !pair.compilerSpecID.equals((Object)compilerSpecID)) {
            log.appendMsg(provider.getAbsolutePath() + " does not have the same language/compiler spec as program " + program.getName());
            return false;
        }
        log.appendMsg("----- Loading " + provider.getAbsolutePath() + " -----");
        this.load(provider, loadSpec, options, program, monitor, log);
        return true;
    }

    @Override
    protected void postLoadProgramFixups(List<AbstractProgramLoader.LoadedProgram> loadedPrograms, List<Option> options, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        if (loadedPrograms.isEmpty()) {
            return;
        }
        if (this.isLinkExistingLibraries(options) || this.isLoadLocalLibraries(options) || this.isLoadSystemLibraries(options)) {
            DomainFolder programFolder = loadedPrograms.get(0).destinationFolder();
            DomainFolder linkSearchFolder = this.getLinkSearchFolder(programFolder, options);
            this.fixupExternalLibraries(loadedPrograms.stream().map(e -> e.program()).toList(), linkSearchFolder, true, messageLog, monitor);
        }
    }

    @Override
    public LoaderTier getTier() {
        return LoaderTier.GENERIC_TARGET_LOADER;
    }

    @Override
    public int getTierPriority() {
        return 50;
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram) {
        List<Option> list = super.getDefaultOptions(provider, loadSpec, domainObject, loadIntoProgram);
        list.add(new Option(LINK_EXISTING_OPTION_NAME, true, Boolean.class, "-loader-linkExistingProjectLibraries"));
        list.add(new Option(LINK_SEARCH_FOLDER_OPTION_NAME, "", String.class, "-loader-projectLibrarySearchFolder"));
        list.add(new Option(LOCAL_LIBRARY_OPTION_NAME, false, Boolean.class, "-loader-loadLocalLibraries"));
        list.add(new Option(SYSTEM_LIBRARY_OPTION_NAME, false, Boolean.class, "-loader-loadSystemLibraries"));
        list.add(new Option(DEPTH_OPTION_NAME, 1, Integer.class, "-loader-libraryLoadDepth"));
        list.add(new Option(LIBRARY_DEST_FOLDER_OPTION_NAME, "", String.class, "-loader-libraryDestinationFolder"));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!(name.equals(LINK_EXISTING_OPTION_NAME) || name.equals(LOCAL_LIBRARY_OPTION_NAME) || name.equals(SYSTEM_LIBRARY_OPTION_NAME) ? !Boolean.class.isAssignableFrom(option.getValueClass()) : (name.equals(DEPTH_OPTION_NAME) ? !Integer.class.isAssignableFrom(option.getValueClass()) : (name.equals(LINK_SEARCH_FOLDER_OPTION_NAME) || name.equals(LIBRARY_DEST_FOLDER_OPTION_NAME)) && !String.class.isAssignableFrom(option.getValueClass())))) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
        }
        return super.validateOptions(provider, loadSpec, options, program);
    }

    protected boolean isLinkExistingLibraries(List<Option> options) {
        boolean isLinkExistingLibraries = true;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(LINK_EXISTING_OPTION_NAME)) continue;
                isLinkExistingLibraries = (Boolean)option.getValue();
            }
        }
        return isLinkExistingLibraries;
    }

    protected DomainFolder getLinkSearchFolder(DomainFolder programFolder, List<Option> options) {
        if (!this.shouldSearchAllPaths(options) && !this.isLinkExistingLibraries(options)) {
            return null;
        }
        String folderPath = "";
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(LINK_SEARCH_FOLDER_OPTION_NAME)) continue;
                folderPath = (String)option.getValue();
            }
        }
        if (folderPath.equals("")) {
            return programFolder;
        }
        return programFolder.getProjectData().getFolder(FilenameUtils.separatorsToUnix((String)folderPath));
    }

    protected boolean isLoadLocalLibraries(List<Option> options) {
        boolean isLoadLocalLibraries = false;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(LOCAL_LIBRARY_OPTION_NAME)) continue;
                isLoadLocalLibraries = (Boolean)option.getValue();
            }
        }
        return isLoadLocalLibraries;
    }

    protected boolean isLoadSystemLibraries(List<Option> options) {
        boolean isLoadSystemLibraries = false;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(SYSTEM_LIBRARY_OPTION_NAME)) continue;
                isLoadSystemLibraries = (Boolean)option.getValue();
            }
        }
        return isLoadSystemLibraries;
    }

    protected int getLibraryLoadDepth(List<Option> options) {
        int depth = 1;
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(DEPTH_OPTION_NAME)) continue;
                depth = (Integer)option.getValue();
            }
        }
        return depth;
    }

    protected DomainFolder getLibraryDestinationFolder(DomainFolder programFolder, List<Option> options) {
        String folderPath = "";
        if (options != null) {
            for (Option option : options) {
                String optName = option.getName();
                if (!optName.equals(LIBRARY_DEST_FOLDER_OPTION_NAME)) continue;
                folderPath = (String)option.getValue();
            }
        }
        if (folderPath.equals("")) {
            return programFolder;
        }
        return programFolder.getProjectData().getFolder(FilenameUtils.separatorsToUnix((String)folderPath));
    }

    protected boolean shouldSearchAllPaths(List<Option> options) {
        return false;
    }

    protected boolean isCaseInsensitiveLibraryFilenames() {
        return false;
    }

    protected boolean isOptionalLibraryFilenameExtensions() {
        return false;
    }

    protected ByteProvider createLibraryByteProvider(File libFile, LoadSpec loadSpec, MessageLog log) throws IOException {
        return new FileByteProvider(libFile, FileSystemService.getInstance().getLocalFSRL(libFile), AccessMode.READ);
    }

    protected boolean shouldLoadLibrary(String libraryName, File libraryFile, ByteProvider provider, LoadSpec desiredLoadSpec, MessageLog log) throws IOException {
        if (this.matchSupportedLoadSpec(desiredLoadSpec, provider) == null) {
            log.appendMsg("Skipping library which is the wrong architecture: " + libraryFile);
            return false;
        }
        return true;
    }

    protected boolean processLibrary(Program library, String libraryName, File libraryFile, ByteProvider provider, LoadSpec loadSpec, List<Option> options, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        return this.isLoadLocalLibraries(options) || this.isLoadSystemLibraries(options);
    }

    private List<AbstractProgramLoader.LoadedProgram> loadLibraries(ByteProvider provider, Program program, DomainFolder programFolder, LoadSpec desiredLoadSpec, List<Option> options, MessageLog log, Object consumer, List<String> libraryNameList, TaskMonitor monitor) throws CancelledException, IOException {
        ArrayList<AbstractProgramLoader.LoadedProgram> loadedPrograms = new ArrayList<AbstractProgramLoader.LoadedProgram>();
        HashSet<String> processed = new HashSet<String>();
        Queue<UnprocessedLibrary> unprocessed = this.createUnprocessedQueue(libraryNameList, this.getLibraryLoadDepth(options));
        List<String> searchPaths = this.getLibrarySearchPaths(provider, options);
        DomainFolder linkSearchFolder = this.getLinkSearchFolder(programFolder, options);
        DomainFolder libraryDestFolder = this.getLibraryDestinationFolder(programFolder, options);
        while (!unprocessed.isEmpty()) {
            monitor.checkCanceled();
            UnprocessedLibrary unprocessedLibrary = unprocessed.remove();
            String libraryName = unprocessedLibrary.name();
            int depth = unprocessedLibrary.depth();
            if (depth == 0 || processed.contains(libraryName)) continue;
            processed.add(libraryName);
            boolean foundLibrary = false;
            if (linkSearchFolder != null && this.findLibrary(libraryName, linkSearchFolder) != null) {
                log.appendMsg("Library " + libraryName + ": Already loaded ");
                continue;
            }
            if (searchPaths.isEmpty()) continue;
            String simpleLibraryName = FilenameUtils.getName((String)libraryName);
            List<File> candidateLibraryFiles = this.findLibrary(FilenameUtils.separatorsToUnix((String)libraryName), searchPaths);
            for (File candidateLibraryFile : candidateLibraryFiles) {
                monitor.checkCanceled();
                ArrayList<String> newLibraryList = new ArrayList<String>();
                Program library = this.loadLibrary(simpleLibraryName, programFolder, candidateLibraryFile, desiredLoadSpec, newLibraryList, options, consumer, log, monitor);
                for (String newLibraryName : newLibraryList) {
                    unprocessed.add(new UnprocessedLibrary(newLibraryName, depth - 1));
                }
                if (library == null) continue;
                foundLibrary = true;
                if (this.processLibrary(library, libraryName, candidateLibraryFile, provider, desiredLoadSpec, options, log, monitor)) {
                    loadedPrograms.add(new AbstractProgramLoader.LoadedProgram(library, libraryDestFolder));
                    log.appendMsg("Library " + libraryName + ": Saving " + candidateLibraryFile);
                    break;
                }
                library.release(consumer);
                log.appendMsg("Library " + libraryName + ": Examining " + candidateLibraryFile);
                break;
            }
            if (foundLibrary) continue;
            log.appendMsg("Library " + libraryName + ": Not found");
        }
        return loadedPrograms;
    }

    private DomainFile findLibrary(String libraryPath, DomainFolder folder) {
        if (folder == null) {
            return null;
        }
        String projectPath = this.appendPath(folder.getPathname(), libraryPath);
        DomainFile ret = folder.getProjectData().getFile(FilenameUtils.separatorsToUnix((String)projectPath));
        if (ret != null) {
            return ret;
        }
        String libraryName = FilenameUtils.getName((String)libraryPath);
        ret = folder.getFile(libraryName);
        if (ret != null) {
            return ret;
        }
        boolean noExtension = FilenameUtils.getExtension((String)libraryName).equals("");
        Comparator<String> comparator = this.getLibraryNameComparator();
        for (DomainFile file : folder.getFiles()) {
            String candidateName = file.getName();
            if (this.isOptionalLibraryFilenameExtensions() && noExtension) {
                candidateName = FilenameUtils.getBaseName((String)candidateName);
            }
            if (comparator.compare(candidateName, libraryName) != 0) continue;
            return file;
        }
        return null;
    }

    private List<File> findLibrary(String libraryPath, List<String> searchPaths) {
        File f;
        String libraryName = FilenameUtils.getName((String)libraryPath);
        ArrayList<File> results = new ArrayList<File>();
        for (String searchPath : searchPaths) {
            File searchDir;
            if ((searchPath = FilenameUtils.normalizeNoEndSeparator((String)searchPath)) == null || searchPath.isEmpty() || !(searchDir = new File(searchPath)).isAbsolute() || !searchDir.isDirectory()) continue;
            String candidatePath = FilenameUtils.separatorsToSystem((String)this.appendPath(searchPath, libraryPath));
            File f2 = this.resolveLibraryFile(new File(candidatePath));
            if (f2 == null || !f2.isFile()) {
                f2 = this.resolveLibraryFile(new File(searchDir, libraryName));
            }
            if (f2 == null || !f2.isFile() || results.contains(f2)) continue;
            results.add(f2);
        }
        if (FilenameUtils.getPrefixLength((String)libraryPath) > 0 && (f = this.resolveLibraryFile(new File(libraryPath))) != null && f.isAbsolute() && f.isFile() && !results.contains(f)) {
            results.add(f);
        }
        return results;
    }

    private Program loadLibrary(String libraryName, DomainFolder libraryFolder, File libraryFile, LoadSpec desiredLoadSpec, List<String> libraryNameList, List<Option> options, Object consumer, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        try (ByteProvider provider = this.createLibraryByteProvider(libraryFile, desiredLoadSpec, log);){
            if (!this.shouldLoadLibrary(libraryName, libraryFile, provider, desiredLoadSpec, log)) {
                Program program = null;
                return program;
            }
            LoadSpec libLoadSpec = this.matchSupportedLoadSpec(desiredLoadSpec, provider);
            if (libLoadSpec == null) {
                log.appendMsg("Skipping library which is the wrong architecture: " + libraryFile);
                Program program = null;
                return program;
            }
            Program library = this.doLoad(provider, libraryName, libraryFolder, libLoadSpec, libraryNameList, options, consumer, log, monitor);
            if (library == null) {
                log.appendMsg("Library " + libraryFile + " failed to load for some reason");
                Program program = null;
                return program;
            }
            Program program = library;
            return program;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Program doLoad(ByteProvider provider, String programName, DomainFolder programFolder, LoadSpec loadSpec, List<String> libraryNameList, List<Option> options, Object consumer, MessageLog log, TaskMonitor monitor) throws CancelledException, IOException {
        LanguageCompilerSpecPair pair = loadSpec.getLanguageCompilerSpec();
        Language language = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec compilerSpec = language.getCompilerSpecByID(pair.compilerSpecID);
        monitor.setMessage(provider.getName());
        Address imageBaseAddr = language.getAddressFactory().getDefaultAddressSpace().getAddress(loadSpec.getDesiredImageBase());
        Program program = this.createProgram(provider, programName, imageBaseAddr, this.getName(), language, compilerSpec, consumer);
        int transactionID = program.startTransaction("Loading");
        boolean success = false;
        try {
            log.appendMsg("----- Loading " + provider.getAbsolutePath() + " -----");
            this.load(provider, loadSpec, options, program, monitor, log);
            this.createDefaultMemoryBlocks(program, language, log);
            ExternalManager extMgr = program.getExternalManager();
            Program externalNames = extMgr.getExternalLibraryNames();
            Comparator<String> comparator = this.getLibraryNameComparator();
            Arrays.sort(externalNames, comparator);
            for (String name : externalNames) {
                if (comparator.compare(name, provider.getName()) == 0 || comparator.compare(name, program.getName()) == 0 || "<EXTERNAL>".equals(name)) continue;
                libraryNameList.add(name);
            }
            success = true;
            Program program2 = program;
            return program2;
        }
        finally {
            program.endTransaction(transactionID, success);
            if (!success) {
                program.release(consumer);
                program = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixupExternalLibraries(List<Program> programs, DomainFolder searchFolder, boolean saveIfModified, MessageLog messageLog, TaskMonitor monitor) throws CancelledException, IOException {
        Map<String, Program> progsByName = programs.stream().filter(Objects::nonNull).collect(Collectors.toMap(p -> p.getDomainFile().getName(), p -> p));
        monitor.initialize((long)progsByName.size());
        for (Program program : progsByName.values()) {
            monitor.incrementProgress(1L);
            if (monitor.isCancelled()) {
                return;
            }
            ExternalManager extManager = program.getExternalManager();
            String[] extLibNames = extManager.getExternalLibraryNames();
            if (extLibNames.length == 0 || extLibNames.length == 1 && "<EXTERNAL>".equals(extLibNames[0])) continue;
            monitor.setMessage("Resolving..." + program.getName());
            int id = program.startTransaction("Resolving external references");
            try {
                this.resolveExternalLibraries(program, progsByName, searchFolder, monitor, messageLog);
            }
            finally {
                program.endTransaction(id, true);
                if (!saveIfModified || !program.canSave() || !program.isChanged()) continue;
                program.save("Resolve external references", monitor);
            }
        }
    }

    private void resolveExternalLibraries(Program program, Map<String, Program> progsByName, DomainFolder searchFolder, TaskMonitor monitor, MessageLog messageLog) throws CancelledException {
        ExternalManager extManager = program.getExternalManager();
        String[] extLibNames = extManager.getExternalLibraryNames();
        messageLog.appendMsg("Linking external programs to " + program.getName() + "...");
        for (String externalLibName : extLibNames) {
            if ("<EXTERNAL>".equals(externalLibName)) continue;
            monitor.checkCanceled();
            try {
                String externalFileName = FilenameUtils.getName((String)externalLibName);
                Program matchingExtProgram = this.findLibrary(progsByName, externalFileName);
                if (matchingExtProgram != null && matchingExtProgram.getDomainFile().exists()) {
                    extManager.setExternalPath(externalLibName, matchingExtProgram.getDomainFile().getPathname(), false);
                    messageLog.appendMsg("  [" + externalLibName + "] -> [" + matchingExtProgram.getDomainFile().getPathname() + "]");
                    continue;
                }
                DomainFile alreadyImportedLib = this.findLibrary(externalLibName, searchFolder);
                if (alreadyImportedLib != null) {
                    extManager.setExternalPath(externalLibName, alreadyImportedLib.getPathname(), false);
                    messageLog.appendMsg("  [" + externalLibName + "] -> [" + alreadyImportedLib.getPathname() + "] (previously imported)");
                    continue;
                }
                messageLog.appendMsg("  [" + externalLibName + "] -> not found");
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("Bad library name: " + externalLibName), (Throwable)e);
            }
        }
    }

    private Queue<UnprocessedLibrary> createUnprocessedQueue(List<String> libraryNames, int depth) {
        return libraryNames.stream().map(name -> new UnprocessedLibrary((String)name, depth)).collect(Collectors.toCollection(LinkedList::new));
    }

    private List<String> getLibrarySearchPaths(ByteProvider provider, List<Option> options) {
        String parent = this.getProviderFilePath(provider);
        ArrayList<String> paths = new ArrayList<String>();
        if (this.shouldSearchAllPaths(options) || this.isLoadLocalLibraries(options) && parent != null) {
            paths.add(parent);
        }
        if (this.shouldSearchAllPaths(options) || this.isLoadSystemLibraries(options)) {
            paths.addAll(LibrarySearchPathManager.getLibraryPathsList());
        }
        return paths;
    }

    private Program findLibrary(Map<String, Program> programsByName, String libraryName) {
        Comparator<String> comparator = this.getLibraryNameComparator();
        boolean noExtension = FilenameUtils.getExtension((String)libraryName).equals("");
        Iterator<String> iterator = programsByName.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String candidateName = key = iterator.next();
            if (this.isOptionalLibraryFilenameExtensions() && noExtension) {
                candidateName = FilenameUtils.getBaseName((String)candidateName);
            }
            if (comparator.compare(candidateName, libraryName) != 0) continue;
            return programsByName.get(key);
        }
        return null;
    }

    private String appendPath(String ... pathElements) {
        StringBuilder sb = new StringBuilder();
        for (String pathElement : pathElements) {
            boolean elementStartsWithSlash;
            if (pathElement == null || pathElement.isEmpty()) continue;
            boolean sbEndsWithSlash = sb.length() > 0 && "/\\".indexOf(sb.charAt(sb.length() - 1)) != -1;
            boolean bl = elementStartsWithSlash = "/\\".indexOf(pathElement.charAt(0)) != -1;
            if (!sbEndsWithSlash && !elementStartsWithSlash && sb.length() > 0) {
                sb.append("/");
            } else if (elementStartsWithSlash && sbEndsWithSlash) {
                pathElement = pathElement.substring(1);
            }
            sb.append(pathElement);
        }
        return sb.toString();
    }

    protected LoadSpec matchSupportedLoadSpec(LoadSpec desiredLoadSpec, ByteProvider provider) throws IOException {
        LanguageCompilerSpecPair desiredPair = desiredLoadSpec.getLanguageCompilerSpec();
        Collection<LoadSpec> supportedLoadSpecs = this.findSupportedLoadSpecs(provider);
        if (supportedLoadSpecs != null) {
            for (LoadSpec supportedLoadSpec : supportedLoadSpecs) {
                if (!desiredPair.equals((Object)supportedLoadSpec.getLanguageCompilerSpec())) continue;
                return supportedLoadSpec;
            }
        }
        return null;
    }

    private File resolveLibraryFile(File libraryFile) {
        File[] files;
        File ret = libraryFile;
        if (this.isCaseInsensitiveLibraryFilenames()) {
            ret = FileUtilities.resolveFileCaseInsensitive((File)libraryFile);
        }
        if (ret.exists()) {
            return ret;
        }
        if (this.isOptionalLibraryFilenameExtensions() && FilenameUtils.getExtension((String)libraryFile.toString()).equals("") && (files = libraryFile.getParentFile().listFiles()) != null) {
            Comparator<String> libNameComparator = this.getLibraryNameComparator();
            for (File file : files) {
                String baseName = FilenameUtils.getBaseName((String)file.toString());
                if (libNameComparator.compare(libraryFile.getName(), baseName) != 0) continue;
                return file;
            }
        }
        return null;
    }

    private String getProviderFilePath(ByteProvider provider) {
        FSRL fsrl = provider.getFSRL();
        if (fsrl != null && !fsrl.getFS().hasContainer()) {
            return FilenameUtils.getFullPathNoEndSeparator((String)fsrl.getPath());
        }
        File f = provider.getFile();
        return f != null ? f.getParent() : null;
    }

    private Comparator<String> getLibraryNameComparator() {
        return this.isCaseInsensitiveLibraryFilenames() ? String.CASE_INSENSITIVE_ORDER : (s1, s2) -> s1.compareTo((String)s2);
    }

    private record UnprocessedLibrary(String name, int depth) {
    }
}

