/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.navigation;

import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigationUtils;
import ghidra.app.plugin.core.gotoquery.GoToHelper;
import ghidra.app.plugin.core.gotoquery.GoToQueryResultsTableModel;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.GoToOverrideService;
import ghidra.app.services.GoToService;
import ghidra.app.services.GoToServiceListener;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.QueryData;
import ghidra.app.util.query.TableService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AddressEvaluator;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.table.AddressArrayTableModel;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class GoToQuery {
    private Pattern FILE_OFFSET_REGEX = Pattern.compile("file\\s*\\(\\s*((0x[0-9a-fA-F]+|[0-9]+))\\s*\\)", 2);
    private QueryData queryData;
    private Address fromAddress;
    private GhidraProgramTableModel<?> model;
    private GoToServiceListener listener;
    private TaskMonitor monitor;
    protected ProgramGroup programs;
    private GoToService goToService;
    private GoToQueryThreadedTableModelListener tableModelListener;
    private final int maxHits;
    private final Plugin plugin;
    private final Navigatable navigatable;
    private NavigationOptions navigationOptions;

    public GoToQuery(Navigatable navigatable, Plugin plugin, GoToService goToService, QueryData queryData, Address fromAddr, GoToServiceListener listener, NavigationOptions navigationOptions, TaskMonitor monitor) {
        this.navigatable = navigatable;
        this.queryData = queryData;
        this.plugin = plugin;
        this.goToService = goToService;
        this.navigationOptions = navigationOptions;
        ToolOptions opt = plugin.getTool().getOptions("Search");
        this.maxHits = opt.getInt("Search Limit", 500);
        this.fromAddress = fromAddr;
        this.monitor = monitor;
        this.listener = listener != null ? listener : new DummyGoToServiceListener();
        this.programs = this.getAllPrograms();
        this.tableModelListener = new GoToQueryThreadedTableModelListener();
    }

    private ProgramGroup getAllPrograms() {
        ProgramManager progService = (ProgramManager)this.plugin.getTool().getService(ProgramManager.class);
        return new ProgramGroup(progService.getAllOpenPrograms(), this.navigatable.getProgram());
    }

    public boolean processQuery() {
        if (this.processAddressExpression()) {
            return true;
        }
        if (this.processWildCard()) {
            return true;
        }
        if (this.processFileOffset()) {
            return true;
        }
        if (this.processSymbolInParsedScope()) {
            return true;
        }
        if (this.processSymbolInPrograms(this.getSearchPrograms())) {
            return true;
        }
        if (this.processAddress()) {
            return true;
        }
        if (this.processDynamicOrCaseInsensitive()) {
            return true;
        }
        this.notifyListener(false);
        return false;
    }

    private boolean checkForOverride() {
        GoToOverrideService override = this.goToService.getOverrideService();
        if (override == null) {
            return false;
        }
        ProgramLocation pLoc = override.goTo(this.queryData.getQueryString());
        if (pLoc != null) {
            this.goToService.goTo(this.navigatable, pLoc, pLoc.getProgram());
            this.notifyListener(true);
            return true;
        }
        return false;
    }

    private boolean processAddress() {
        if (this.checkForOverride()) {
            return true;
        }
        String queryString = this.queryData.getQueryString();
        for (Program program : this.getSearchPrograms()) {
            Address[] addresses;
            Address[] validAddresses = this.validateAddresses(program, addresses = program.parseAddress(queryString, this.queryData.isCaseSensitive()));
            if (validAddresses.length <= 0) continue;
            this.goToAddresses(program, validAddresses);
            return true;
        }
        Program currentProgram = this.navigatable.getProgram();
        Address fileAddress = this.getFileAddress(currentProgram, queryString);
        if (fileAddress != null) {
            this.goToAddresses(currentProgram, new Address[]{fileAddress});
            return true;
        }
        return false;
    }

    private Address getFileAddress(Program program, String queryString) {
        if (this.fromAddress == null) {
            return null;
        }
        try {
            Address address = this.fromAddress.getAddressSpace().getAddress(queryString);
            if (address != null && program.getMemory().contains(address)) {
                return address;
            }
        }
        catch (AddressFormatException addressFormatException) {
            // empty catch block
        }
        return null;
    }

    private void goToAddresses(Program program, Address[] validAddresses) {
        if (validAddresses.length == 1) {
            this.goTo(program, validAddresses[0], this.fromAddress);
            this.notifyListener(true);
            return;
        }
        Swing.runIfSwingOrRunLater(() -> {
            this.model = new AddressArrayTableModel("Goto: ", (ServiceProvider)this.plugin.getTool(), program, validAddresses, this.monitor);
            this.model.addInitialLoadListener(this.tableModelListener);
        });
    }

    private void goToProgramLocations(Program program, List<ProgramLocation> locations) {
        if (locations.size() == 1) {
            this.goTo(program, locations.get(0));
            this.notifyListener(true);
            return;
        }
        Swing.runIfSwingOrRunLater(() -> {
            this.model = new GoToQueryResultsTableModel(program, (ServiceProvider)this.plugin.getTool(), locations, this.monitor);
            this.model.addInitialLoadListener(this.tableModelListener);
        });
    }

    private boolean processDynamicOrCaseInsensitive() {
        if (!this.queryData.isIncludeDynamicLables() && this.queryData.isCaseSensitive()) {
            return false;
        }
        Swing.runIfSwingOrRunLater(() -> {
            this.model = new GoToQueryResultsTableModel(this.navigatable.getProgram(), this.queryData, (ServiceProvider)this.plugin.getTool(), this.maxHits, this.monitor);
            this.model.addInitialLoadListener(this.tableModelListener);
        });
        return true;
    }

    private boolean processSymbolInPrograms(Iterable<Program> searchPrograms) {
        for (Program program : searchPrograms) {
            List<ProgramLocation> locations = this.getValidSymbolLocationsForProgram(program);
            if (locations.isEmpty()) continue;
            this.goToProgramLocations(program, locations);
            return true;
        }
        return false;
    }

    private List<ProgramLocation> getValidSymbolLocationsForProgram(Program program) {
        ArrayList<ProgramLocation> locations = new ArrayList<ProgramLocation>();
        SymbolTable symTable = program.getSymbolTable();
        SymbolIterator it = symTable.getSymbols(this.queryData.getQueryString());
        while (it.hasNext() && locations.size() < this.maxHits) {
            Symbol symbol = it.next();
            ProgramLocation location = this.getProgramLocationForSymbol(symbol, program);
            if (location != null) {
                locations.add(location);
                continue;
            }
            locations.addAll(this.getExtenalLinkageLocations(symbol));
        }
        return locations;
    }

    private Collection<ProgramLocation> getExtenalLinkageLocations(Symbol symbol) {
        Address[] externalLinkageAddresses;
        ArrayList<ProgramLocation> locations = new ArrayList<ProgramLocation>();
        Program program = symbol.getProgram();
        for (Address address : externalLinkageAddresses = NavigationUtils.getExternalLinkageAddresses(program, symbol.getAddress())) {
            ProgramLocation location = GoToHelper.getProgramLocationForAddress(address, program);
            if (location == null) continue;
            locations.add(location);
        }
        return locations;
    }

    private ProgramLocation getProgramLocationForSymbol(Symbol symbol, Program program) {
        Address symbolAddress = symbol.getAddress();
        if (symbolAddress.isExternalAddress()) {
            return null;
        }
        if (symbolAddress.isMemoryAddress() && !program.getMemory().contains(symbolAddress)) {
            return null;
        }
        return symbol.getProgramLocation();
    }

    private boolean processSymbolInParsedScope() {
        String symbolName;
        String queryInput = this.queryData.getQueryString();
        int colonPos = queryInput.lastIndexOf("::");
        if (colonPos < 0) {
            return false;
        }
        String scopeName = queryInput.substring(0, colonPos);
        if (this.goToSymbolInScope(scopeName, symbolName = queryInput.substring(colonPos + 2))) {
            this.notifyListener(true);
            return true;
        }
        return false;
    }

    private Iterable<Program> getSearchPrograms() {
        return this.navigationOptions.isGoToRestrictedToCurrentProgram() ? Collections.singleton(this.navigatable.getProgram()) : this.programs;
    }

    private boolean processAddressExpression() {
        String queryInput = this.queryData.getQueryString();
        if (!this.isAddressExpression(queryInput)) {
            return false;
        }
        boolean relative = queryInput.matches("^\\s*[+-].*");
        Address baseAddr = relative ? this.fromAddress : null;
        for (Program program : this.getSearchPrograms()) {
            Address evalAddr = AddressEvaluator.evaluate((Program)program, (Address)baseAddr, (String)queryInput);
            if (evalAddr == null) continue;
            boolean success = this.goTo(program, new ProgramLocation(program, evalAddr));
            this.notifyListener(success);
            return true;
        }
        return false;
    }

    private QueryData cleanupQuery(Program program, QueryData qData) {
        String preColonString;
        String input = qData.getQueryString();
        int colonPosition = input.indexOf("::");
        if (colonPosition >= 0 && (this.isAddressSpaceName(program, preColonString = input.substring(0, colonPosition)) || this.isBlockName(program, preColonString))) {
            input = input.substring(colonPosition + 2);
            qData = new QueryData(input, qData.isCaseSensitive(), qData.isIncludeDynamicLables());
        }
        return qData;
    }

    private boolean processWildCard() {
        if (!this.isWildCard()) {
            return false;
        }
        Swing.runIfSwingOrRunLater(() -> {
            Program program = this.navigatable.getProgram();
            this.model = new GoToQueryResultsTableModel(program, this.cleanupQuery(program, this.queryData), (ServiceProvider)this.plugin.getTool(), this.maxHits, this.monitor);
            this.model.addInitialLoadListener(this.tableModelListener);
        });
        return true;
    }

    private boolean processFileOffset() {
        String input = this.queryData.getQueryString();
        Matcher matcher = this.FILE_OFFSET_REGEX.matcher(input);
        if (matcher.matches()) {
            try {
                long offset = Long.decode(matcher.group(1));
                Program currentProgram = this.navigatable.getProgram();
                Memory mem = currentProgram.getMemory();
                List addresses = mem.locateAddressesForFileOffset(offset);
                if (addresses.size() > 0) {
                    this.goToAddresses(currentProgram, addresses.toArray(new Address[0]));
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isWildCard() {
        String queryInput = this.queryData.getQueryString();
        return queryInput.indexOf(42) > -1 || queryInput.indexOf(63) > -1;
    }

    private boolean isAddressExpression(String input) {
        return input.indexOf(43) >= 0 || input.indexOf(45) >= 0 || input.indexOf(42) > 0;
    }

    private boolean isAddressSpaceName(Program program, String input) {
        return program.getAddressFactory().getAddressSpace(input) != null;
    }

    private boolean isBlockName(Program program, String input) {
        MemoryBlock[] blocks;
        for (MemoryBlock element : blocks = program.getMemory().getBlocks()) {
            if (!element.getName().equals(input)) continue;
            return true;
        }
        return false;
    }

    private Address[] validateAddresses(Program program, Address[] addrs) {
        Memory memory = program.getMemory();
        ArrayList<Address> list = new ArrayList<Address>();
        for (Address element : addrs) {
            boolean isValid = memory.contains(element);
            if (!isValid) continue;
            if (this.isPreferredAddress(element)) {
                return new Address[]{element};
            }
            list.add(element);
        }
        if (list.size() == addrs.length) {
            return addrs;
        }
        Address[] a = new Address[list.size()];
        return list.toArray(a);
    }

    private boolean isPreferredAddress(Address address) {
        if (!this.navigationOptions.preferCurrentAddressSpace()) {
            return false;
        }
        return this.isInCurrentAddressSpace(address);
    }

    private boolean isInCurrentAddressSpace(Address address) {
        if (this.fromAddress == null) {
            return true;
        }
        AddressSpace currentSpace = this.fromAddress.getAddressSpace();
        return currentSpace.equals(address.getAddressSpace());
    }

    private boolean goToSymbolInScope(String scopeName, String symbolStr) {
        Iterator<Program> iterator = this.getSearchPrograms().iterator();
        if (iterator.hasNext()) {
            List symbols;
            Program program = iterator.next();
            SymbolTable symTable = program.getSymbolTable();
            Namespace scope = this.getScope(program, program.getGlobalNamespace(), scopeName);
            if (scope != null && !(symbols = symTable.getSymbols(symbolStr, scope)).isEmpty()) {
                return this.gotoLabels(program, symbols);
            }
            return this.goToSymbolInMemoryBlock(scopeName, symbolStr, program);
        }
        return false;
    }

    private boolean gotoLabels(Program program, List<Symbol> symbols) {
        if (symbols.size() == 1) {
            return this.gotoLabel(program, symbols.get(0));
        }
        ArrayList<ProgramLocation> programLocations = new ArrayList<ProgramLocation>();
        for (Symbol symbol : symbols) {
            ProgramLocation programLocation = symbol.getProgramLocation();
            if (programLocation == null) continue;
            programLocations.add(symbol.getProgramLocation());
        }
        this.goToProgramLocations(program, programLocations);
        return true;
    }

    private boolean goToSymbolInMemoryBlock(String scopeName, String symbolStr, Program program) {
        List globalSymbols = program.getSymbolTable().getLabelOrFunctionSymbols(symbolStr, null);
        if (globalSymbols.isEmpty()) {
            return false;
        }
        ArrayList<Symbol> matchingSymbols = new ArrayList<Symbol>();
        for (Symbol symbol : globalSymbols) {
            Address address = symbol.getAddress();
            MemoryBlock block = program.getMemory().getBlock(address);
            if (block == null || !block.getName().equals(scopeName)) continue;
            matchingSymbols.add(symbol);
        }
        if (matchingSymbols.isEmpty()) {
            return false;
        }
        return this.gotoLabels(program, matchingSymbols);
    }

    private Namespace getScope(Program program, Namespace parent, String scopeName) {
        int colonIndex = scopeName.lastIndexOf("::");
        if (colonIndex >= 0) {
            String parentScopeName = scopeName.substring(0, colonIndex);
            scopeName = scopeName.substring(colonIndex + 1);
            if ((parent = this.getScope(program, parent, parentScopeName)) == null) {
                return null;
            }
        }
        SymbolTable symTable = program.getSymbolTable();
        Namespace namespace = symTable.getNamespace(scopeName, parent);
        return namespace;
    }

    private boolean gotoLabel(Program program, Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        ProgramLocation loc = symbol.getProgramLocation();
        if (loc == null) {
            return false;
        }
        return this.goToService.goTo(this.navigatable, loc, program);
    }

    private boolean goTo(Program program, ProgramLocation loc) {
        if (loc == null) {
            return false;
        }
        if (program == null) {
            program = this.navigatable.getProgram();
        }
        return this.goToService.goTo(this.navigatable, loc, program);
    }

    private boolean goTo(Program program, Address gotoAddress, Address refAddress) {
        if (program == null) {
            program = this.navigatable.getProgram();
        }
        if (program.getMemory().contains(gotoAddress)) {
            this.goToService.goTo(this.navigatable, program, gotoAddress, refAddress);
            return true;
        }
        return false;
    }

    private void notifyListener(boolean hasData) {
        this.listener.gotoCompleted(this.queryData.getQueryString(), hasData);
    }

    private class DummyGoToServiceListener
    implements GoToServiceListener {
        private DummyGoToServiceListener() {
        }

        @Override
        public void gotoCompleted(String queryString, boolean foundResults) {
        }

        @Override
        public void gotoFailed(Exception exc) {
        }
    }

    protected class ProgramGroup
    implements Iterable<Program> {
        private List<Program> programList;

        public ProgramGroup(Program[] programs, Program navigatableProgram) {
            this.programList = new ArrayList<Program>(Arrays.asList(programs));
            if (!this.programList.contains(navigatableProgram)) {
                this.programList.add(navigatableProgram);
            }
        }

        @Override
        public Iterator<Program> iterator() {
            ArrayList<Program> newList = new ArrayList<Program>(this.programList);
            Program currentProgram = GoToQuery.this.navigatable.getProgram();
            int index = newList.indexOf(currentProgram);
            Collections.swap(newList, 0, index);
            return newList.iterator();
        }
    }

    private class GoToQueryThreadedTableModelListener
    implements ThreadedTableModelListener {
        private GoToQueryThreadedTableModelListener() {
        }

        public void loadPending() {
        }

        public void loadingStarted() {
        }

        public void loadingFinished(boolean wasCancelled) {
            boolean hasData;
            int rowCount = GoToQuery.this.model.getRowCount();
            boolean bl = hasData = rowCount > 0;
            if (!hasData) {
                GoToQuery.this.notifyListener(false);
                return;
            }
            if (rowCount == 1) {
                GoToQuery.this.goTo(null, GoToQuery.this.model.getProgramLocation(0, 0));
                GoToQuery.this.notifyListener(true);
                return;
            }
            PluginTool tool = GoToQuery.this.plugin.getTool();
            if (tool == null) {
                return;
            }
            TableService service = (TableService)tool.getService(TableService.class);
            TableComponentProvider<?> provider = service.showTable("Goto " + GoToQuery.this.queryData.getQueryString(), "Goto", GoToQuery.this.model, "Go To", GoToQuery.this.navigatable);
            if (GoToQuery.this.model.getRowCount() >= GoToQuery.this.maxHits) {
                this.showMaxSearchWarning(provider.getComponent(), GoToQuery.this.model.getRowCount());
            }
            GoToQuery.this.notifyListener(true);
        }

        private void showMaxSearchWarning(Component parent, int matchCount) {
            SwingUtilities.invokeLater(() -> Msg.showWarn(this.getClass(), (Component)parent, (String)"Search Limit Exceeded!", (Object)("Stopped search after finding " + matchCount + " matches.\nThe Search limit can be changed in the Edit->Options, under Tool Options")));
        }
    }
}

