/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfRecord;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class OmfCommentRecord
extends OmfRecord {
    public static final byte COMMENT_CLASS_TRANSLATOR = 0;
    public static final byte COMMENT_CLASS_LIBMOD = -93;
    public static final byte COMMENT_CLASS_DEFAULT_LIBRARY = -97;
    private byte commentType;
    private byte commentClass;
    private String value;

    public OmfCommentRecord(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        this.commentType = reader.readNextByte();
        this.commentClass = reader.readNextByte();
        byte[] bytes = reader.readNextByteArray(this.getRecordLength() - 3);
        if (this.commentClass == 0 || this.commentClass == -93 || this.commentClass == -97) {
            this.value = new String(bytes, StandardCharsets.US_ASCII);
        }
        this.readCheckSumByte(reader);
    }

    public byte getCommentClass() {
        return this.commentClass;
    }

    public String getValue() {
        return this.value;
    }
}

