/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingDialog;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.actions.SharedStubKeyBindingAction;
import docking.help.HelpManager;
import ghidra.framework.main.ApplicationLevelPlugin;
import ghidra.framework.model.Project;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import help.Help;
import help.HelpService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Developer", category="Testing", shortDescription="Write JavaHelp Info", description="This plugin identifies those plugin actions that do not have help associated with them. The file, GhidraHelpInfo.txt, is written to your home directory.")
public class JavaHelpPlugin
extends Plugin
implements ApplicationLevelPlugin {
    static final String infoName = "GhidraHelpInfo.txt";
    private static final Set<String> noHelpActions = new HashSet<String>();

    public JavaHelpPlugin(PluginTool tool) {
        super(tool);
        DockingAction action = new DockingAction("Generate Help Info File", this.getName()){

            public void actionPerformed(ActionContext context) {
                TaskLauncher.launch((Task)new WriterTask());
            }
        };
        DockingWindowManager.getHelpService().excludeFromHelp((Object)action);
        action.setMenuBarData(new MenuData(new String[]{"&Tools", "Write Help Info File"}));
        tool.addAction((DockingActionIf)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHelpInfo(TaskMonitor monitor) {
        Project project = this.tool.getProject();
        if (project == null) {
            Msg.showWarn((Object)((Object)this), null, (String)"Cannot Generate Help Report", (Object)"You must have a project open to generate help information.");
            return;
        }
        HelpService help = Help.getHelpService();
        if (help == null || !(help instanceof HelpManager)) {
            Msg.showError((Object)((Object)this), null, (String)"Cannot Generate Help Report", (Object)"HelpManager failed to initialize properly");
            return;
        }
        HelpManager hm = (HelpManager)help;
        String filename = System.getProperty("user.home") + File.separator + infoName;
        File file = new File(filename);
        if (file.exists()) {
            file.delete();
        }
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileOutputStream(file));
            Map map = hm.getInvalidHelpLocations(monitor);
            monitor.initialize((long)map.size());
            monitor.setMessage("Filtering help items...");
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                DockingAction action;
                monitor.checkCanceled();
                Object helpObj = iter.next();
                if (helpObj instanceof DockingAction && this.shouldSkipHelpCheck(action = (DockingAction)helpObj)) {
                    iter.remove();
                }
                monitor.initialize(1L);
            }
            out.println("Unresolved Help Locations: " + map.size());
            ArrayList<HelpInfoObject> helpInfos = new ArrayList<HelpInfoObject>(map.size());
            monitor.initialize((long)map.size());
            monitor.setMessage("Procesing actions...");
            iter = map.keySet().iterator();
            int i = 1;
            while (iter.hasNext()) {
                monitor.checkCanceled();
                Object helpObj = iter.next();
                HelpLocation helpLoc = (HelpLocation)map.get(helpObj);
                HelpInfoObject helpInfoObject = new HelpInfoObject(helpObj, helpLoc);
                if (!helpInfos.contains(helpInfoObject)) {
                    helpInfos.add(helpInfoObject);
                }
                monitor.initialize(1L);
            }
            if (helpInfos.size() == 0) {
                Msg.showInfo((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Help Validation Complete", (Object)"No items missing help were found");
                return;
            }
            Collections.sort(helpInfos);
            monitor.setMessage("Writing items missing help...");
            for (HelpInfoObject helpInfo : helpInfos) {
                monitor.checkCanceled();
                this.writeHelpInfo(out, helpInfo, i++);
                monitor.initialize(1L);
            }
            out.flush();
            Msg.showInfo((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Help Info File Write Completed", (Object)("Unresolved Help Locations: " + map.size() + "\nHelp info file written to\n" + filename));
        }
    }

    private boolean shouldSkipHelpCheck(DockingAction action) {
        String actionName = action.getOwner() + " - " + action.getName();
        if (action instanceof SharedStubKeyBindingAction) {
            return true;
        }
        if (noHelpActions.contains(actionName)) {
            return true;
        }
        return this.isKeybindingOnly(action);
    }

    private boolean isKeybindingOnly(DockingAction action) {
        if (action.getToolBarData() != null) {
            return false;
        }
        if (action.getMenuBarData() != null) {
            return false;
        }
        return action.getPopupMenuData() == null;
    }

    private void writeHelpInfo(PrintWriter out, HelpInfoObject helpInfo, int num) {
        Object helpObj = helpInfo.helpObject;
        HelpLocation helpLoc = helpInfo.location;
        out.println();
        out.println(num + "). HELP OBJECT: " + helpObj.getClass().getName());
        if (helpObj instanceof DockingAction) {
            DockingAction action = (DockingAction)helpObj;
            out.println("     ACTION: " + action.getOwner() + " - " + action.getName());
            out.println("     INCEPTION:" + action.getInceptionInformation());
        } else if (helpObj instanceof DockingDialog) {
            DockingDialog dlg = (DockingDialog)helpObj;
            out.println("     DIALOG TITLE: " + dlg.getTitle());
        } else if (helpObj instanceof ComponentProvider) {
            ComponentProvider provider = (ComponentProvider)helpObj;
            out.println("     PROVIDER: " + provider.getName());
        } else if (helpObj instanceof JButton) {
            Container c;
            JButton button = (JButton)helpObj;
            out.println("     BUTTON: " + button.getText());
            for (c = button; c != null && !(c instanceof Window); c = c.getParent()) {
            }
            if (c instanceof Dialog) {
                out.println("     DIALOG: " + ((Dialog)c).getTitle());
            }
            if (c instanceof Frame) {
                out.println("     FRAME: " + ((Frame)c).getTitle());
            }
        }
        out.println("     HELP-LOCATION: " + helpLoc);
    }

    static {
        noHelpActions.add("DockingWindows - Help");
        noHelpActions.add("DockingWindows - HelpInfo");
        noHelpActions.add("DockingWindows - Set KeyBinding");
        noHelpActions.add("Tool - Contents");
        noHelpActions.add("Tool - Release Notes");
        noHelpActions.add("TipOfTheDayPlugin - Tips of the day");
        noHelpActions.add("MemoryUsagePlugin - Show VM memory");
        noHelpActions.add("Tool - Show Log");
        noHelpActions.add("GhidraScriptMgrPlugin - Ghidra API Help");
    }

    private class HelpInfoObject
    implements Comparable<HelpInfoObject> {
        private Object helpObject;
        private HelpLocation location;

        HelpInfoObject(Object object, HelpLocation location) {
            this.helpObject = object;
            this.location = location;
        }

        @Override
        public int compareTo(HelpInfoObject o) {
            if (this.helpObject instanceof DockingAction) {
                if (!(o.helpObject instanceof DockingAction)) {
                    return -1;
                }
                DockingAction action = (DockingAction)this.helpObject;
                String myInceptionInfo = action.getInceptionInformation();
                DockingAction otherDockingAction = (DockingAction)o.helpObject;
                String otherInceptionInfo = otherDockingAction.getInceptionInformation();
                return myInceptionInfo.compareTo(otherInceptionInfo);
            }
            String myClassName = this.helpObject.getClass().getName();
            String otherClassName = o.helpObject.getClass().getName();
            return myClassName.compareTo(otherClassName);
        }

        public String toString() {
            return this.location + " for " + this.helpObject;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.helpObject == null ? 0 : this.helpObject.hashCode());
            result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HelpInfoObject other = (HelpInfoObject)obj;
            if (this.helpObject == null ? other.helpObject != null : !this.helpObject.equals(other.helpObject)) {
                return false;
            }
            return !(this.location == null ? other.location != null : !this.location.equals((Object)other.location));
        }
    }

    private class WriterTask
    extends Task {
        WriterTask() {
            super("Finding Actions Without Help", true, true, true, true);
        }

        public void run(TaskMonitor monitor) {
            JavaHelpPlugin.this.writeHelpInfo(monitor);
        }
    }
}

