/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.MenuData;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.context.ProgramSymbolContextAction;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;

public class PinSymbolAction
extends ProgramSymbolContextAction {
    public PinSymbolAction(String owner, String popupGroup) {
        super("Pin Symbol", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Set Pinned"}, popupGroup));
        this.setDescription("Pins the symbol(s) to the address so that it is unaffected by memory block moves or image base changes.");
        this.setHelpLocation(new HelpLocation("SymbolTablePlugin", "Pinning a Symbol"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(ProgramSymbolActionContext context) {
        Program program = context.getProgram();
        int transactionID = program.startTransaction("Pin Symbol(s)");
        try {
            for (Symbol symbol : context.getSymbols()) {
                if (!(symbol instanceof CodeSymbol) && !(symbol instanceof FunctionSymbol) || symbol.isExternal() || symbol.isPinned()) continue;
                symbol.setPinned(true);
            }
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }

    @Override
    protected boolean isEnabledForContext(ProgramSymbolActionContext context) {
        for (Symbol symbol : context.getSymbols()) {
            if (!(symbol instanceof CodeSymbol) && !(symbol instanceof FunctionSymbol) || symbol.isExternal() || symbol.isPinned()) continue;
            return true;
        }
        return false;
    }
}

