/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.scalartable;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.button.GRadioButton;
import docking.widgets.label.GLabel;
import docking.widgets.textfield.IntegerTextField;
import ghidra.app.plugin.core.scalartable.RangeFilterTextField;
import ghidra.app.plugin.core.scalartable.ScalarSearchPlugin;
import ghidra.app.plugin.core.scalartable.ScalarSearchProvider;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class ScalarSearchDialog
extends DialogComponentProvider {
    private static String NULL_SELECTION = "Nothing currently selected";
    private JButton beginSearchButton;
    private ScalarSearchPlugin plugin;
    private JPanel mainPanel;
    private IntegerTextField exactValueField;
    private RangeFilterTextField minField;
    private RangeFilterTextField maxField;
    private SearchPanel searchLayout;
    private RangeFilter rangeFilter;
    private JRadioButton searchAllScalars;
    private JRadioButton searchAScalar;
    private JRadioButton searchSelectionRadioButton;
    private JRadioButton searchAllRadioButton;
    private ScalarSearchProvider provider;

    ScalarSearchDialog(ScalarSearchPlugin plugin) {
        super("Search for Scalars", true, true, true, true);
        this.plugin = plugin;
        this.mainPanel = this.buildMainPanel();
        HelpService helpService = DockingWindowManager.getHelpService();
        helpService.registerHelp((Object)this.mainPanel, new HelpLocation(plugin.getName(), "Scalar_Search"));
        this.addWorkPanel(this.mainPanel);
        this.buildSearchButton();
        this.addCancelButton();
        this.setPreferredSize(425, 300);
    }

    public void show() {
        this.clearStatusText();
        this.exactValueField.requestFocus();
        this.exactValueField.selectAll();
        PluginTool tool = this.plugin.getTool();
        tool.showDialog((DialogComponentProvider)this, (ComponentProvider)this.provider);
    }

    public void setFilterValues(long minFilterValue, long maxFilterValue) {
        this.minField.setValue(minFilterValue);
        this.maxField.setValue(maxFilterValue);
    }

    public void setSpecificScalarValue(int value) {
        this.exactValueField.setValue(value);
    }

    public void setSearchAScalar() {
        this.searchAScalar.setSelected(true);
        this.exactValueField.setEnabled(true);
        this.minField.setEnabled(false);
        this.maxField.setEnabled(false);
    }

    ScalarSearchProvider getProvider() {
        return this.provider;
    }

    private JPanel buildMainPanel() {
        JPanel newMainPanel = new JPanel();
        newMainPanel.setLayout(new BorderLayout());
        newMainPanel.add((Component)this.buildSearchLayout(), "North");
        return newMainPanel;
    }

    private JPanel buildSearchLayout() {
        this.searchLayout = new SearchPanel();
        JPanel finalPanel = new JPanel(new BorderLayout());
        finalPanel.add((Component)this.searchLayout, "North");
        finalPanel.add(this.buildSelectionPanel(), "South");
        return finalPanel;
    }

    private Component createMinFilterWidget() {
        this.minField = new RangeFilterTextField(RangeFilterTextField.FilterType.MIN, this.plugin.getCurrentProgram());
        return this.minField.getComponent();
    }

    private Component createMaxFilterWidget() {
        this.maxField = new RangeFilterTextField(RangeFilterTextField.FilterType.MAX, this.plugin.getCurrentProgram());
        return this.maxField.getComponent();
    }

    private Component buildSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder("Search Scope"));
        this.searchSelectionRadioButton = new GRadioButton("Search Selection");
        this.searchAllRadioButton = new GRadioButton("Search All");
        this.searchSelectionRadioButton.setToolTipText("Search only the current selection");
        this.searchAllRadioButton.setToolTipText("Search the entire program");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.searchSelectionRadioButton);
        buttonGroup.add(this.searchAllRadioButton);
        ProgramSelection selection = this.plugin.getProgramSelection();
        if (selection == null) {
            this.searchAllRadioButton.setSelected(true);
            this.searchSelectionRadioButton.setEnabled(false);
        } else {
            this.searchSelectionRadioButton.setSelected(true);
        }
        panel.add(this.searchAllRadioButton);
        panel.add(this.searchSelectionRadioButton);
        JPanel selectionPanel = new JPanel();
        selectionPanel.setLayout(new BorderLayout());
        selectionPanel.add((Component)panel, "North");
        HelpService helpService = DockingWindowManager.getHelpService();
        helpService.registerHelp((Object)selectionPanel, new HelpLocation(this.plugin.getName(), "Scalar_Selection_Scope"));
        return selectionPanel;
    }

    private void buildSearchButton() {
        this.beginSearchButton = new JButton("Search");
        this.beginSearchButton.setMnemonic('B');
        this.beginSearchButton.addActionListener(ev -> this.searchCallback());
        this.addButton(this.beginSearchButton);
    }

    private void searchCallback() {
        if (this.searchAllRadioButton.isSelected()) {
            this.provider = new ScalarSearchProvider(this.plugin, null);
            this.updateProviderFilterValues();
            this.provider.setVisible(true);
            this.close();
            return;
        }
        ProgramSelection currentSelection = this.plugin.getProgramSelection();
        if (currentSelection == null) {
            this.setStatusText(NULL_SELECTION);
            return;
        }
        this.provider = new ScalarSearchProvider(this.plugin, currentSelection);
        this.updateProviderFilterValues();
        this.provider.setVisible(true);
        this.close();
    }

    private void updateProviderFilterValues() {
        if (this.searchAScalar.isSelected()) {
            this.provider.updateSearchRangeValues(this);
        } else {
            this.provider.updateSearchRangeValues(this);
        }
    }

    long getMinSearchValue() {
        if (this.searchAScalar.isSelected()) {
            return this.exactValueField.getLongValue();
        }
        return this.minField.getFilterValue();
    }

    long getMaxSearchValue() {
        if (this.searchAScalar.isSelected()) {
            return this.exactValueField.getLongValue();
        }
        return this.maxField.getFilterValue();
    }

    String getMinSearchValueText() {
        if (this.searchAScalar.isSelected()) {
            return this.exactValueField.getText();
        }
        return this.minField.getText();
    }

    String getMaxSearchValueText() {
        if (this.searchAScalar.isSelected()) {
            return this.exactValueField.getText();
        }
        return this.maxField.getText();
    }

    private class SearchPanel
    extends JPanel {
        public SearchPanel() {
            HelpLocation help = new HelpLocation(ScalarSearchDialog.this.plugin.getName(), "Search_For");
            HelpService helpService = DockingWindowManager.getHelpService();
            helpService.registerHelp((Object)this, help);
            this.setLayout(new BorderLayout());
            this.setBorder(new TitledBorder("Search Type"));
            ScalarSearchDialog.this.searchAllScalars = new GRadioButton("Scalars in Range:");
            ScalarSearchDialog.this.searchAScalar = new GRadioButton("Specific Scalar:");
            ScalarSearchDialog.this.searchAllScalars.setToolTipText("Search program (or selection) for scalar operands or defined scalar data types with values in the following range:");
            ScalarSearchDialog.this.searchAScalar.setToolTipText("Search program (or selection) for scalar operands or defined scalar data types with the following value:");
            ScalarSearchDialog.this.searchAllScalars.addActionListener(e -> {
                if (ScalarSearchDialog.this.searchAllScalars.isSelected()) {
                    ScalarSearchDialog.this.minField.setEnabled(true);
                    ScalarSearchDialog.this.maxField.setEnabled(true);
                    ScalarSearchDialog.this.exactValueField.setEnabled(false);
                }
            });
            ScalarSearchDialog.this.searchAScalar.addActionListener(e -> {
                if (ScalarSearchDialog.this.searchAScalar.isSelected()) {
                    ScalarSearchDialog.this.minField.setEnabled(false);
                    ScalarSearchDialog.this.maxField.setEnabled(false);
                    ScalarSearchDialog.this.exactValueField.setEnabled(true);
                }
            });
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(ScalarSearchDialog.this.searchAllScalars);
            buttonGroup.add(ScalarSearchDialog.this.searchAScalar);
            JPanel allScalarsPanel = new JPanel();
            allScalarsPanel.setLayout(new BorderLayout());
            allScalarsPanel.add((Component)ScalarSearchDialog.this.searchAllScalars, "North");
            ScalarSearchDialog.this.rangeFilter = new RangeFilter();
            allScalarsPanel.add(Box.createHorizontalStrut(18), "West");
            allScalarsPanel.add((Component)ScalarSearchDialog.this.rangeFilter, "Center");
            JPanel aScalarPanel = new JPanel();
            aScalarPanel.setLayout(new BorderLayout());
            aScalarPanel.add((Component)ScalarSearchDialog.this.searchAScalar, "North");
            ScalarSearchDialog.this.exactValueField = new IntegerTextField(8);
            aScalarPanel.add(Box.createHorizontalStrut(18), "West");
            aScalarPanel.add((Component)ScalarSearchDialog.this.exactValueField.getComponent(), "Center");
            this.add((Component)allScalarsPanel, "North");
            this.add((Component)aScalarPanel, "Center");
            ScalarSearchDialog.this.searchAllScalars.setSelected(true);
            ScalarSearchDialog.this.exactValueField.setEnabled(false);
        }
    }

    private class RangeFilter
    extends JPanel {
        private HelpLocation help;

        public RangeFilter() {
            this.help = new HelpLocation(ScalarSearchDialog.this.plugin.getName(), "Filter_Scalars");
            HelpService helpService = DockingWindowManager.getHelpService();
            helpService.registerHelp((Object)this, this.help);
            this.setLayout(new BoxLayout(this, 2));
            this.add(Box.createHorizontalStrut(4));
            this.add((Component)new GLabel("Min:"));
            this.add(Box.createHorizontalStrut(5));
            this.add(ScalarSearchDialog.this.createMinFilterWidget());
            this.add(Box.createHorizontalStrut(10));
            this.add((Component)new GLabel("Max:"));
            this.add(Box.createHorizontalStrut(5));
            this.add(ScalarSearchDialog.this.createMaxFilterWidget());
        }
    }
}

