/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;

class FunctionComparisonData {
    protected Program program;
    protected Function function;
    protected Data data;
    protected AddressSetView addressSet = new AddressSet();

    FunctionComparisonData() {
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFunction(Function function) {
        if (function == null) {
            this.clear();
            return;
        }
        this.function = function;
        this.data = null;
        this.program = function.getProgram();
        this.addressSet = function.getBody();
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        if (data == null) {
            this.clear();
            return;
        }
        this.data = data;
        this.function = null;
        this.program = data.getProgram();
        this.addressSet = new AddressSet(data.getMinAddress(), data.getMaxAddress());
    }

    public AddressSetView getAddressSet() {
        return this.addressSet;
    }

    public void setAddressSet(AddressSetView addressSet) {
        this.addressSet = addressSet;
        this.data = null;
        this.function = null;
    }

    public boolean isData() {
        return this.data != null;
    }

    public boolean isFunction() {
        return this.function != null;
    }

    public boolean isEmpty() {
        return this.function == null && this.data == null && this.addressSet == null;
    }

    public void clear() {
        this.function = null;
        this.data = null;
        this.addressSet = new AddressSet();
        this.program = null;
    }

    public String toString() {
        String str = "";
        str = this.function != null ? this.function.getName() : (this.data != null ? this.data.getAddress().toString() : (this.addressSet != null ? this.addressSet.toString() : "none"));
        return str;
    }
}

