/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.function.DataAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.app.services.DataTypeManagerService;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

public class RecentlyUsedAction
extends DataAction {
    private static final KeyStroke DEFAULT_KEY_STROKE = KeyStroke.getKeyStroke(89, 0);
    private static final String GROUP_NAME = "Z_RECENT";

    public RecentlyUsedAction(FunctionPlugin plugin) {
        super("Recently Used", "Recent", (DataType)new ByteDataType(), plugin);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Recently_Used"));
    }

    @Override
    protected KeyStroke getDefaultKeyStroke() {
        return DEFAULT_KEY_STROKE;
    }

    @Override
    protected void initKeyStroke(KeyStroke keyStroke) {
        if (!DEFAULT_KEY_STROKE.equals(keyStroke)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        DataType recentDataType = this.getRecentDataType();
        if (recentDataType == null) {
            return false;
        }
        this.dataType = recentDataType;
        boolean enabled = super.isEnabledForContext(context);
        return enabled;
    }

    @Override
    protected boolean isAddToPopup(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        if (location instanceof FunctionSignatureFieldLocation) {
            return true;
        }
        return location instanceof VariableLocation;
    }

    private DataType getRecentDataType() {
        DataTypeManagerService service = (DataTypeManagerService)this.plugin.getTool().getService(DataTypeManagerService.class);
        if (service == null) {
            return null;
        }
        return service.getRecentlyUsed();
    }

    @Override
    public void setPopupMenu(String name, boolean isSignatureAction) {
        DataType dt = this.getRecentDataType();
        String displayName = "Last Used: " + (dt == null ? "<empty>" : dt.getDisplayName());
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", displayName}, GROUP_NAME));
    }
}

