/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.ComponentProvider;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.equate.EquateTableProvider;
import ghidra.app.plugin.core.equate.RemoveEquateCmd;
import ghidra.app.plugin.core.equate.RenameEquatesCmd;
import ghidra.app.services.GoToService;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Msg;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.util.List;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays the list of equates", description="This plugin provides a window that displays all the equates that have been defined in the program.")
public class EquateTablePlugin
extends ProgramPlugin
implements DomainObjectListener {
    private GoToService goToService;
    private EquateTableProvider provider;
    private SwingUpdateManager updateMgr = new SwingUpdateManager(1000, 3000, () -> this.provider.updateEquates());

    public EquateTablePlugin(PluginTool tool) {
        super(tool);
        this.provider = new EquateTableProvider(this);
    }

    public void init() {
        super.init();
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == GoToService.class) {
            this.provider.setGoToService((GoToService)service);
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == GoToService.class) {
            this.provider.setGoToService(null);
        }
    }

    public void dispose() {
        this.updateMgr.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.provider.dispose();
        super.dispose();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!this.provider.isVisible()) {
            return;
        }
        if (ev.containsEvent(4)) {
            this.updateMgr.updateNow();
            return;
        }
        if (ev.containsEvent(70) || ev.containsEvent(72) || ev.containsEvent(73) || ev.containsEvent(71) || ev.containsEvent(74) || ev.containsEvent(40) || ev.containsEvent(41) || ev.containsEvent(46) || ev.containsEvent(20) || ev.containsEvent(23) || ev.containsEvent(21) || ev.containsEvent(150) || ev.containsEvent(152) || ev.containsEvent(151) || ev.containsEvent(30) || ev.containsEvent(32) || ev.containsEvent(31) || ev.containsEvent(108)) {
            this.updateMgr.update();
        }
    }

    @Override
    protected void programActivated(Program program) {
        if (this.tool.isVisible((ComponentProvider)this.provider)) {
            program.addListener((DomainObjectListener)this);
        }
        this.provider.programOpened(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.provider.programClosed();
    }

    void deleteEquates(List<Equate> equates) {
        if (equates.isEmpty()) {
            return;
        }
        String[] equateNames = new String[equates.size()];
        StringBuffer equateList = new StringBuffer();
        for (int i = 0; i < equates.size(); ++i) {
            equateNames[i] = equates.get(i).getName();
            equateList.append(equateNames[i]);
            if (i >= equates.size() - 1) continue;
            equateList.append(", ");
        }
        String title = "Delete Equate" + (equates.size() > 1 ? "s" : "") + "?";
        String msg = "Do you really want to delete the equate" + (equates.size() > 1 ? "s" : "") + ": " + equates + "  ?\n\n   NOTE: All references will be removed.";
        int option = OptionDialog.showOptionDialog((Component)this.provider.getComponent(), (String)title, (String)msg, (String)"Delete", (int)3);
        if (option != 0) {
            this.tool.execute((Command)new RemoveEquateCmd(equateNames, this.getTool()), (DomainObject)this.currentProgram);
        }
    }

    Program getProgram() {
        return this.currentProgram;
    }

    void goTo(Address addr, int operandIndex) {
        OperandFieldLocation loc = new OperandFieldLocation(this.currentProgram, addr, null, null, null, operandIndex, 0);
        this.goToService.goTo((ProgramLocation)loc);
    }

    EquateTableProvider getProvider() {
        return this.provider;
    }

    void componentShown() {
        if (this.currentProgram != null) {
            this.currentProgram.addListener((DomainObjectListener)this);
        }
    }

    void componentClosed() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
    }

    void renameEquate(Equate oldEquate, String newEquateName) {
        String oldEquateName = oldEquate.getName();
        if (oldEquateName.equals(newEquateName)) {
            return;
        }
        if (this.isValid(oldEquate, newEquateName)) {
            RenameEquatesCmd cmd = new RenameEquatesCmd(oldEquateName, newEquateName);
            this.tool.execute((Command)cmd, (DomainObject)this.currentProgram);
        }
    }

    boolean isValid(Equate equate, String equateStr) {
        if (equateStr == null || equateStr.length() <= 0) {
            return false;
        }
        EquateTable equateTable = this.currentProgram.getEquateTable();
        Equate newEquate = equateTable.getEquate(equateStr);
        if (newEquate != null && !newEquate.equals(equate)) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.provider.getComponent(), (String)"Rename Equate Failed!", (Object)("Equate " + equateStr + " exists with value 0x" + Long.toHexString(newEquate.getValue()) + " (" + newEquate.getValue() + ")"));
            return false;
        }
        return true;
    }
}

