/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.equate.EquateTablePlugin;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateReference;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.ProgramTableModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class EquateReferenceTableModel
extends GDynamicColumnTableModel<EquateReference, Object>
implements ProgramTableModel {
    private EquateTablePlugin plugin;
    private List<EquateReference> referenceList = new ArrayList<EquateReference>();
    private Equate currentEquate = null;

    EquateReferenceTableModel(EquateTablePlugin plugin) {
        super((ServiceProvider)plugin.getTool());
        this.plugin = plugin;
    }

    public String getName() {
        return "Equate References";
    }

    public List<EquateReference> getModelData() {
        return this.referenceList;
    }

    @Override
    public Program getProgram() {
        return this.plugin.getProgram();
    }

    protected TableColumnDescriptor<EquateReference> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new EquateReferenceAddressColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new EquateOperandIndexColumn());
        return descriptor;
    }

    public Object getDataSource() {
        return null;
    }

    Equate getEquate() {
        return this.currentEquate;
    }

    void setEquate(Equate equate) {
        this.currentEquate = equate;
        this.populateReferences();
    }

    private void populateReferences() {
        this.referenceList.clear();
        Program program = this.getProgram();
        if (program == null) {
            return;
        }
        EquateTable equateTable = program.getEquateTable();
        if (equateTable == null || this.currentEquate == null) {
            return;
        }
        Arrays.asList(this.currentEquate.getReferences()).forEach(r -> this.referenceList.add((EquateReference)r));
        this.fireTableDataChanged();
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        EquateReference reference = (EquateReference)this.getRowObject(row);
        OperandFieldLocation loc = new OperandFieldLocation(this.getProgram(), reference.getAddress(), null, null, null, (int)reference.getOpIndex(), 0);
        return loc;
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet addressSet = new AddressSet();
        for (int row : rows) {
            EquateReference reference = (EquateReference)this.getRowObject(row);
            Address addr = reference.getAddress();
            addressSet.addRange(addr, addr);
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }

    private class EquateReferenceAddressColumn
    extends AbstractDynamicTableColumn<EquateReference, Address, Object> {
        private EquateReferenceAddressColumn() {
        }

        public String getColumnName() {
            return "Ref Addr";
        }

        public Address getValue(EquateReference rowObject, Settings settings, Object data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getAddress();
        }
    }

    private class EquateOperandIndexColumn
    extends AbstractDynamicTableColumn<EquateReference, Short, Object> {
        private EquateOperandIndexColumn() {
        }

        public String getColumnName() {
            return "Op Index";
        }

        public Short getValue(EquateReference rowObject, Settings settings, Object data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getOpIndex();
        }
    }
}

