/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.label.GDHtmlLabel;
import docking.widgets.label.GDLabel;
import ghidra.app.merge.listing.ConflictPanel;
import ghidra.app.merge.listing.ResolveConflictChangeEvent;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.util.HTMLUtilities;
import ghidra.util.datastruct.LongArrayList;
import ghidra.util.layout.MaximizeSpecificColumnGridLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;

public class VerticalChoicesPanel
extends ConflictPanel {
    private static final long serialVersionUID = 1L;
    static final int HEADER = 0;
    static final int INFORMATION = 1;
    static final int RADIO_BUTTON = 2;
    static final int CHECK_BOX = 3;
    private GDHtmlLabel headerLabel;
    private JPanel rowPanel;
    private ArrayList<ArrayList<JComponent>> rowComps;
    private ArrayList<String[]> rows;
    private LongArrayList rowTypes;
    private ButtonGroup group;
    private int columnCount = 1;
    private MaximizeSpecificColumnGridLayout layout;
    private int indent;
    private static final int DEFAULT_TOP = 2;
    private static final int DEFAULT_LEFT = 4;
    private static final int DEFAULT_BOTTOM = 2;
    private static final int DEFAULT_RIGHT = 4;
    private Insets defaultInsets;
    private Insets textVsButtonInsets;
    private Insets textVsCheckBoxInsets;

    public VerticalChoicesPanel() {
        this.init();
    }

    public VerticalChoicesPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder("Resolve Conflict"));
        this.setLayout(new BorderLayout());
        this.headerLabel = new GDHtmlLabel(" ");
        this.headerLabel.setHorizontalAlignment(0);
        this.add((Component)this.headerLabel, "North");
        this.rowComps = new ArrayList();
        this.rows = new ArrayList();
        this.rowTypes = new LongArrayList();
        this.group = new ButtonGroup();
        this.layout = new MaximizeSpecificColumnGridLayout(5, 5, this.columnCount);
        this.layout.maximizeColumn(0);
        this.rowPanel = new JPanel((LayoutManager)this.layout);
        this.add((Component)this.rowPanel, "Center");
        this.rowPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GRadioButton rb = new GRadioButton();
        GCheckBox cb = new GCheckBox();
        this.indent = Math.max(rb.getPreferredSize().width, cb.getPreferredSize().width);
        this.defaultInsets = new Insets(2, 4, 2, 4);
        int labelHeight = (int)new GDLabel("A").getPreferredSize().getHeight();
        double buttonHeight = new MyRadioButton("A", 2).getPreferredSize().getHeight();
        int borderHeight = (int)((buttonHeight - (double)labelHeight) / 2.0);
        if (borderHeight < 0) {
            borderHeight = 0;
        }
        this.textVsButtonInsets = new Insets(2 + borderHeight, 4, 2 + borderHeight, 4);
        double checkBoxHeight = new MyCheckBox("A", 2).getPreferredSize().getHeight();
        borderHeight = (int)((checkBoxHeight - (double)labelHeight) / 2.0);
        if (borderHeight < 0) {
            borderHeight = 0;
        }
        this.textVsCheckBoxInsets = new Insets(2 + borderHeight, 4, 2 + borderHeight, 4);
        this.add((Component)this.createUseForAllCheckBox(), "South");
    }

    void setTitle(String conflictType) {
        ((TitledBorder)this.getBorder()).setTitle("Resolve " + conflictType + " Conflict");
    }

    void setHeader(String text) {
        if (text != null && text.length() != 0) {
            this.headerLabel.setText(ConflictUtility.wrapAsHTML(text));
            this.add((Component)this.headerLabel, "North");
        } else {
            this.headerLabel.setText("");
            this.remove((Component)this.headerLabel);
        }
        this.validate();
        this.invalidate();
    }

    void setRowHeader(String[] items) {
        int i;
        this.adjustColumnCount(items.length);
        JComponent[] headerComps = this.getRowComponents(0);
        if (headerComps != null) {
            for (i = 0; i < headerComps.length; ++i) {
                this.rowPanel.remove(headerComps[i]);
            }
            headerComps = null;
            if (this.rowComps.isEmpty()) {
                this.rowComps.add(0, new ArrayList());
            } else {
                this.rowComps.set(0, new ArrayList());
            }
        }
        if (this.rowTypes.isEmpty()) {
            this.rowTypes.add(0L);
        } else {
            this.rowTypes.set(0, Long.valueOf(0L));
        }
        if (items != null && items.length > 0) {
            if (this.rows.isEmpty()) {
                this.rows.add(0, items);
            } else {
                this.rows.set(0, items);
            }
            headerComps = new JComponent[items.length];
            for (i = 0; i < headerComps.length; ++i) {
                headerComps[i] = new MyLabel(items[i]);
                headerComps[i].setName(this.getComponentName(0, i));
                this.setRowComponent(headerComps[i], 0, i, this.defaultInsets);
                headerComps[i].setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
            }
        }
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
    }

    private void adjustColumnCount(int numberOfColumns) {
        if (numberOfColumns <= 0) {
            numberOfColumns = 1;
        }
        if (this.columnCount != numberOfColumns) {
            this.columnCount = numberOfColumns;
            this.layout = new MaximizeSpecificColumnGridLayout(5, 5, this.columnCount);
            this.layout.maximizeColumn(0);
            this.rowPanel.setLayout((LayoutManager)this.layout);
        }
    }

    private JComponent[] getRowComponents(int row) {
        if (this.rowComps.isEmpty()) {
            return new JComponent[0];
        }
        ArrayList<JComponent> list = this.rowComps.get(row);
        if (list == null || list.size() == 0) {
            return new JComponent[0];
        }
        JComponent[] comps = list.toArray(new JComponent[list.size()]);
        return comps;
    }

    private void setRowComponent(JComponent comp, int row, int column, Insets insets) {
        this.rowPanel.add(comp);
        int numRows = this.rowComps.size();
        if (row >= numRows) {
            for (int i = numRows; i <= row; ++i) {
                this.rowComps.add(i, new ArrayList());
            }
        }
        ArrayList<JComponent> list = this.rowComps.get(row);
        for (int i = list.size(); i <= column; ++i) {
            list.add(null);
        }
        list.set(column, comp);
    }

    void addRadioButtonRow(String[] items, String name, int conflictOption, final ChangeListener listener) {
        this.adjustColumnCount(items.length);
        final int row = this.rows.size();
        this.rowTypes.add(2L);
        this.rows.add(items);
        final MyRadioButton firstComp = new MyRadioButton(items[0], conflictOption);
        this.group.add((AbstractButton)((Object)firstComp));
        firstComp.setName(name);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (listener != null && ((JRadioButton)e.getSource()).isSelected()) {
                    ResolveConflictChangeEvent event = new ResolveConflictChangeEvent((Object)firstComp, row, VerticalChoicesPanel.this.getSelectedOptions());
                    listener.stateChanged(event);
                }
            }
        };
        firstComp.addItemListener(itemListener);
        this.setRowComponent((JComponent)((Object)firstComp), row, 0, this.defaultInsets);
        for (int i = 1; i < items.length; ++i) {
            MyLabel newComp = new MyLabel(items[i]);
            newComp.setName(this.getComponentName(row, i));
            this.setRowComponent((JComponent)((Object)newComp), row, i, this.textVsButtonInsets);
        }
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
    }

    void addCheckBoxRow(String[] items, String name, int conflictOption, final ChangeListener listener) {
        this.adjustColumnCount(items.length);
        int row = this.rows.size();
        this.rowTypes.add(3L);
        this.rows.add(items);
        MyCheckBox firstComp = new MyCheckBox(items[0], conflictOption);
        firstComp.setName(name);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (listener != null) {
                    listener.stateChanged(null);
                }
            }
        };
        firstComp.addItemListener(itemListener);
        this.setRowComponent((JComponent)((Object)firstComp), row, 0, this.defaultInsets);
        for (int i = 1; i < items.length; ++i) {
            MyLabel newComp = new MyLabel(items[i]);
            newComp.setName(this.getComponentName(row, i));
            this.setRowComponent((JComponent)((Object)newComp), row, i, this.textVsCheckBoxInsets);
        }
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
    }

    void addInfoRow(String[] items) {
        this.adjustColumnCount(items.length);
        int row = this.rows.size();
        this.rowTypes.add(1L);
        this.rows.add(items);
        MyLabel firstComp = new MyLabel(items[0]);
        firstComp.setBorder(BorderFactory.createEmptyBorder(0, this.indent, 0, 0));
        firstComp.setName(this.getComponentName(row, 0));
        this.setRowComponent((JComponent)((Object)firstComp), row, 0, this.defaultInsets);
        for (int i = 1; i < items.length; ++i) {
            MyLabel newComp = new MyLabel(items[i]);
            newComp.setName(this.getComponentName(row, i));
            this.setRowComponent((JComponent)((Object)newComp), row, i, this.defaultInsets);
        }
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
    }

    @Override
    public void clear() {
        this.setHeader(null);
        ListIterator<ArrayList<JComponent>> iter = this.rowComps.listIterator();
        while (iter.hasNext()) {
            ArrayList<JComponent> compList = iter.next();
            ListIterator<JComponent> compIter = compList.listIterator();
            while (compIter.hasNext()) {
                Component rowComp = compIter.next();
                this.rowPanel.remove(rowComp);
            }
            compList.clear();
        }
        this.rowComps.clear();
        this.rows.clear();
        this.rowTypes.clear();
        this.group = new ButtonGroup();
        this.columnCount = 1;
        this.rowPanel.validate();
        this.validate();
        this.invalidate();
    }

    String getComponentName(int row, int column) {
        return "ChoiceComponentRow" + row + "Col" + column;
    }

    @Override
    public boolean allChoicesAreResolved() {
        for (int row = 0; row < this.rows.size(); ++row) {
            JComponent comp = this.getComponent(row, 0);
            if (comp instanceof MyRadioButton && ((MyRadioButton)((Object)comp)).isSelected()) {
                return true;
            }
            if (!(comp instanceof MyCheckBox) || !((MyCheckBox)((Object)comp)).isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getNumConflictsResolved() {
        int count = 0;
        for (int row = 0; row < this.rows.size(); ++row) {
            JComponent comp = this.getComponent(row, 0);
            if (comp instanceof MyRadioButton && ((MyRadioButton)((Object)comp)).isSelected()) {
                ++count;
                continue;
            }
            if (!(comp instanceof MyCheckBox) || !((MyCheckBox)((Object)comp)).isSelected()) continue;
            ++count;
        }
        return count;
    }

    protected int getSelectedOptions() {
        int option = 0;
        for (int row = 0; row < this.rows.size(); ++row) {
            JComponent comp = this.getComponent(row, 0);
            if (comp instanceof MyRadioButton && ((MyRadioButton)((Object)comp)).isSelected()) {
                option |= ((MyRadioButton)((Object)comp)).getOption();
                continue;
            }
            if (!(comp instanceof MyCheckBox) || !((MyCheckBox)((Object)comp)).isSelected()) continue;
            option |= ((MyCheckBox)((Object)comp)).getOption();
        }
        return option;
    }

    private JComponent getComponent(int row, int column) {
        JComponent[] comps = this.getRowComponents(row);
        if (column < comps.length) {
            return comps[column];
        }
        return null;
    }

    @Override
    public boolean allChoicesAreSame() {
        return this.allChoicesAreResolved();
    }

    @Override
    public int getUseForAllChoice() {
        int conflictOption = 0;
        int rowCount = this.rowComps.size();
        for (int row = 0; row < rowCount; ++row) {
            JComponent[] comps = this.getRowComponents(row);
            for (int i = 0; i < comps.length; ++i) {
                JComponent component = comps[i];
                if (component instanceof MyRadioButton && ((MyRadioButton)((Object)component)).isSelected()) {
                    conflictOption |= ((MyRadioButton)((Object)component)).option;
                    continue;
                }
                if (!(component instanceof MyCheckBox) || !((MyCheckBox)((Object)component)).isSelected()) continue;
                conflictOption |= ((MyCheckBox)((Object)component)).option;
            }
        }
        return conflictOption;
    }

    @Override
    public void removeAllListeners() {
    }

    @Override
    public boolean hasChoice() {
        Iterator iterator = this.rowTypes.iterator();
        while (iterator.hasNext()) {
            long rowType = (Long)iterator.next();
            if (rowType != 2L && rowType != 3L) continue;
            return true;
        }
        return false;
    }

    private class MyRadioButton
    extends GRadioButton {
        private static final long serialVersionUID = 1L;
        private int option;

        public MyRadioButton(String text, int option) {
            super(text);
            this.option = option;
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    String displayedText = MyRadioButton.this.getText();
                    if (displayedText == null) {
                        MyRadioButton.this.setToolTipText(null);
                        return;
                    }
                    int displayedWidth = MyRadioButton.this.getWidth() - VerticalChoicesPanel.this.indent;
                    Font displayedFont = MyRadioButton.this.getFont();
                    FontMetrics fontMetrics = displayedFont != null ? MyRadioButton.this.getFontMetrics(displayedFont) : null;
                    int stringWidth = fontMetrics != null ? fontMetrics.stringWidth(displayedText) : 0;
                    MyRadioButton.this.setToolTipText(stringWidth > displayedWidth ? displayedText : null);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }

        private int getOption() {
            return this.option;
        }
    }

    private class MyCheckBox
    extends GCheckBox {
        private static final long serialVersionUID = 1L;
        private int option;

        public MyCheckBox(String text, int option) {
            super(text);
            this.option = option;
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    String displayedText = MyCheckBox.this.getText();
                    if (displayedText == null) {
                        MyCheckBox.this.setToolTipText(null);
                        return;
                    }
                    int displayedWidth = MyCheckBox.this.getWidth() - VerticalChoicesPanel.this.indent;
                    Font displayedFont = MyCheckBox.this.getFont();
                    FontMetrics fontMetrics = displayedFont != null ? MyCheckBox.this.getFontMetrics(displayedFont) : null;
                    int stringWidth = fontMetrics != null ? fontMetrics.stringWidth(displayedText) : 0;
                    MyCheckBox.this.setToolTipText(stringWidth > displayedWidth ? displayedText : null);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }

        private int getOption() {
            return this.option;
        }
    }

    private class MyLabel
    extends GDHtmlLabel {
        public MyLabel(final String text) {
            super(text);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    String displayedText = MyLabel.this.getText();
                    if (displayedText == null) {
                        MyLabel.this.setToolTipText(null);
                        return;
                    }
                    Border border2 = MyLabel.this.getBorder();
                    Insets borderInsets = border2 != null ? border2.getBorderInsets((Component)((Object)MyLabel.this)) : null;
                    int left2 = borderInsets != null ? borderInsets.left : 0;
                    int displayedWidth = MyLabel.this.getWidth() - left2;
                    Font displayedFont = MyLabel.this.getFont();
                    FontMetrics fontMetrics = displayedFont != null ? MyLabel.this.getFontMetrics(displayedFont) : null;
                    int stringWidth = fontMetrics != null ? fontMetrics.stringWidth(displayedText) : 0;
                    MyLabel.this.setToolTipText(stringWidth > displayedWidth ? "<html>" + HTMLUtilities.escapeHTML((String)text) : null);
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                }

                @Override
                public void componentShown(ComponentEvent e) {
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                }
            });
        }
    }
}

