/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.analysis;

import ghidra.app.cmd.disassemble.SetFlowOverrideCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class SharedReturnAnalysisCmd
extends BackgroundCommand {
    private AddressSetView set;
    private boolean assumeContiguousFunctions = false;
    private boolean considerConditionalBranches = false;

    public SharedReturnAnalysisCmd(AddressSetView set, boolean assumeContiguousFunctions, boolean considerConditionalBranches) {
        super("Shared Return Analysis", false, true, false);
        this.set = set;
        this.assumeContiguousFunctions = assumeContiguousFunctions;
        this.considerConditionalBranches = considerConditionalBranches;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        try {
            SymbolTable symbolTable = program.getSymbolTable();
            SymbolIterator fnSymbols = symbolTable.getSymbols(this.set, SymbolType.FUNCTION, true);
            while (fnSymbols.hasNext()) {
                monitor.checkCanceled();
                Symbol s = fnSymbols.next();
                Address entry = s.getAddress();
                this.processFunctionJumpReferences(program, entry, monitor);
            }
            if (this.assumeContiguousFunctions) {
                AddressSet jumpScanSet = new AddressSet();
                fnSymbols = symbolTable.getSymbols(this.set, SymbolType.FUNCTION, true);
                while (fnSymbols.hasNext()) {
                    monitor.checkCanceled();
                    Symbol s = fnSymbols.next();
                    this.checkAboveFunction(s, jumpScanSet);
                    this.checkBelowFunction(s, jumpScanSet);
                }
                Address functionAfterSrc = null;
                Address functionBeforeSrc = null;
                ReferenceManager refMgr = program.getReferenceManager();
                AddressIterator refSrcIter = refMgr.getReferenceSourceIterator((AddressSetView)jumpScanSet, true);
                while (refSrcIter.hasNext()) {
                    Function nextFunction;
                    monitor.checkCanceled();
                    Address srcAddr = refSrcIter.next();
                    RefType flow = null;
                    Address destAddr = null;
                    for (Reference ref : refMgr.getReferencesFrom(srcAddr)) {
                        RefType refType = ref.getReferenceType();
                        if (!refType.isFlow()) continue;
                        if (flow != null) break;
                        flow = refType;
                        destAddr = ref.getToAddress();
                    }
                    if (destAddr == null || flow == null || !flow.isJump() || !flow.isUnConditional() || srcAddr.getAddressSpace() != destAddr.getAddressSpace()) continue;
                    if (functionAfterSrc != null && functionAfterSrc.getAddressSpace() != srcAddr.getAddressSpace()) {
                        functionAfterSrc = null;
                    }
                    if (functionBeforeSrc != null && functionBeforeSrc.getAddressSpace() != srcAddr.getAddressSpace()) {
                        functionBeforeSrc = null;
                    }
                    if (srcAddr.compareTo((Object)destAddr) < 0) {
                        if (functionAfterSrc == Address.NO_ADDRESS) continue;
                        if (functionAfterSrc == null || functionAfterSrc.compareTo((Object)srcAddr) <= 0) {
                            nextFunction = this.getFunctionAfter(program, srcAddr);
                            if (nextFunction != null) {
                                functionAfterSrc = nextFunction.getEntryPoint();
                            } else {
                                functionAfterSrc = Address.NO_ADDRESS;
                                continue;
                            }
                        }
                        if (destAddr.compareTo((Object)functionAfterSrc) < 0) continue;
                        this.createFunction(program, destAddr, monitor);
                        continue;
                    }
                    if (functionAfterSrc == null) {
                        nextFunction = this.getFunctionAfter(program, srcAddr);
                        functionAfterSrc = nextFunction != null ? nextFunction.getEntryPoint() : Address.NO_ADDRESS;
                    }
                    if (functionBeforeSrc == Address.NO_ADDRESS) {
                        if (functionAfterSrc == Address.NO_ADDRESS || srcAddr.compareTo((Object)functionAfterSrc) < 0) continue;
                        functionBeforeSrc = null;
                        nextFunction = this.getFunctionAfter(program, srcAddr);
                        functionAfterSrc = nextFunction != null ? nextFunction.getEntryPoint() : Address.NO_ADDRESS;
                    }
                    if (functionBeforeSrc == null || functionAfterSrc != Address.NO_ADDRESS && srcAddr.compareTo((Object)functionAfterSrc) >= 0) {
                        Function prevFunction = this.getFunctionBefore(program, srcAddr);
                        if (prevFunction != null) {
                            functionBeforeSrc = prevFunction.getEntryPoint();
                        } else {
                            functionBeforeSrc = Address.NO_ADDRESS;
                            continue;
                        }
                    }
                    if (destAddr.compareTo(functionBeforeSrc) >= 0) continue;
                    this.createFunction(program, destAddr, monitor);
                }
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return true;
    }

    private Function getFunctionBefore(Program program, Address addr) {
        Listing listing = program.getListing();
        FunctionIterator prevFunctionIter = listing.getFunctions(this.getRangeBefore(program, addr), false);
        if (prevFunctionIter.hasNext()) {
            return (Function)prevFunctionIter.next();
        }
        return null;
    }

    private AddressSetView getRangeBefore(Program program, Address addr) {
        AddressSpace space = addr.getAddressSpace();
        Address min = space.getMinAddress();
        if (addr.equals((Object)min)) {
            return new AddressSet();
        }
        try {
            return new AddressSet(min, addr.subtractNoWrap(1L));
        }
        catch (AddressOverflowException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private Function getFunctionAfter(Program program, Address addr) {
        Listing listing = program.getListing();
        FunctionIterator nextFunctionIter = listing.getFunctions(this.getRangeAfter(program, addr), true);
        if (nextFunctionIter.hasNext()) {
            return (Function)nextFunctionIter.next();
        }
        return null;
    }

    private AddressSetView getRangeAfter(Program program, Address addr) {
        AddressSpace space = addr.getAddressSpace();
        Address max = space.getMaxAddress();
        if (addr.equals((Object)max)) {
            return new AddressSet();
        }
        try {
            return new AddressSet(addr.addNoWrap(1L), max);
        }
        catch (AddressOverflowException e) {
            throw new AssertException((Throwable)e);
        }
    }

    private void createFunction(Program program, Address entry, TaskMonitor monitor) throws CancelledException {
        if (program.getFunctionManager().getFunctionAt(entry) != null) {
            this.processFunctionJumpReferences(program, entry, monitor);
        } else {
            if (this.hasFallThruTo(program, entry)) {
                return;
            }
            AutoAnalysisManager analysisMgr = AutoAnalysisManager.getAnalysisManager(program);
            analysisMgr.createFunction(entry, false);
        }
    }

    private boolean hasFallThruTo(Program program, Address location) {
        Instruction fallInstr;
        Instruction instr = program.getListing().getInstructionAt(location);
        if (instr == null) {
            return true;
        }
        Address fallFrom = instr.getFallFrom();
        return fallFrom != null && (fallInstr = program.getListing().getInstructionContaining(fallFrom)) != null && location.equals((Object)fallInstr.getFallThrough());
    }

    private void checkAboveFunction(Symbol functionSymbol, AddressSet jumpScanSet) {
        Address fnAddr;
        Program program = functionSymbol.getProgram();
        Function prevFunction = this.getFunctionBefore(program, fnAddr = functionSymbol.getAddress());
        if (prevFunction != null) {
            jumpScanSet.addRange(prevFunction.getEntryPoint(), fnAddr);
            return;
        }
        jumpScanSet.addRange(fnAddr.getAddressSpace().getMinAddress(), fnAddr);
    }

    private void checkBelowFunction(Symbol functionSymbol, AddressSet jumpScanSet) {
        Address fnAddr;
        Program program;
        Function nextFunction;
        Function function = (Function)functionSymbol.getObject();
        AddressSetView body = function.getBody();
        if (body.getNumAddressRanges() > 1) {
            jumpScanSet.add(body);
        }
        if ((nextFunction = this.getFunctionAfter(program = functionSymbol.getProgram(), fnAddr = functionSymbol.getAddress())) != null) {
            jumpScanSet.addRange(fnAddr, nextFunction.getEntryPoint().subtract(1L));
            if (body.getNumAddressRanges() <= 1) {
                jumpScanSet.delete(body);
            }
            return;
        }
        jumpScanSet.addRange(fnAddr, fnAddr.getAddressSpace().getMaxAddress());
        if (body.getNumAddressRanges() <= 1) {
            jumpScanSet.delete(body);
        }
    }

    private void checkAllJumpReferences(Program program, TaskMonitor monitor) throws CancelledException {
        SymbolTable symbolTable = program.getSymbolTable();
        InstructionIterator instructionIter = program.getListing().getInstructions(this.set, true);
        while (instructionIter.hasNext()) {
            Symbol s;
            Reference ref;
            monitor.checkCanceled();
            Instruction instr = instructionIter.next();
            FlowType ft = instr.getFlowType();
            if (!ft.isJump() || (ref = this.getSingleFlowReferenceFrom(instr)) == null || program.getFunctionManager().getFunctionAt(instr.getMinAddress()) != null || (s = symbolTable.getPrimarySymbol(ref.getToAddress())) == null || s.getSymbolType() != SymbolType.FUNCTION || instr.getFlowOverride() != FlowOverride.NONE) continue;
            SetFlowOverrideCmd cmd = new SetFlowOverrideCmd(instr.getMinAddress(), FlowOverride.CALL_RETURN);
            cmd.applyTo((DomainObject)program);
        }
    }

    private void processFunctionJumpReferences(Program program, Address entry, TaskMonitor monitor) throws CancelledException {
        if (this.hasFallThruTo(program, entry)) {
            return;
        }
        List<Reference> fnRefList = this.getJumpRefsToFunction(program, entry, monitor);
        if (fnRefList == null) {
            return;
        }
        FunctionManager funcMgr = program.getFunctionManager();
        for (Reference ref : fnRefList) {
            Function functionContaining;
            Address refInstrAddr;
            Reference checkRef;
            monitor.checkCanceled();
            Instruction instr = program.getListing().getInstructionAt(ref.getFromAddress());
            if (instr == null || (checkRef = this.getSingleFlowReferenceFrom(instr)) == null || funcMgr.getFunctionAt(refInstrAddr = instr.getMinAddress()) != null || (functionContaining = funcMgr.getFunctionContaining(refInstrAddr)) != null && functionContaining.getEntryPoint().equals((Object)entry) || !checkRef.getToAddress().equals((Object)ref.getToAddress()) || instr.getFlowOverride() != FlowOverride.NONE) continue;
            SetFlowOverrideCmd cmd = new SetFlowOverrideCmd(refInstrAddr, FlowOverride.CALL_RETURN);
            cmd.applyTo((DomainObject)program);
        }
    }

    private List<Reference> getJumpRefsToFunction(Program program, Address entry, TaskMonitor monitor) throws CancelledException {
        ArrayList<Reference> fnRefList = null;
        ReferenceIterator referencesTo = program.getReferenceManager().getReferencesTo(entry);
        while (referencesTo.hasNext()) {
            monitor.checkCanceled();
            Reference ref = referencesTo.next();
            if (!ref.getReferenceType().isJump() || ref.getReferenceType().isConditional() && !this.considerConditionalBranches) continue;
            if (fnRefList == null) {
                fnRefList = new ArrayList<Reference>();
            }
            fnRefList.add(ref);
        }
        return fnRefList;
    }

    private Reference getSingleFlowReferenceFrom(Instruction instr) {
        Reference ref = null;
        int flowCnt = 0;
        for (Reference refFrom : instr.getReferencesFrom()) {
            if (!refFrom.isMemoryReference() || !refFrom.getReferenceType().isFlow()) continue;
            if (++flowCnt > 1) {
                return null;
            }
            ref = refFrom;
        }
        return ref;
    }
}

