/*
 * Decompiled with CFR 0.152.
 */
package ghidra.taint.gui.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.util.ProgramLocation;
import ghidra.taint.gui.field.TaintFieldLocation;
import ghidra.taint.model.TaintSet;
import ghidra.taint.model.TaintVec;
import java.math.BigInteger;

public class TaintFieldFactory
extends FieldFactory {
    public static final String PROPERTY_NAME = "Taint";
    public static final String FIELD_NAME = "Taint";

    public TaintFieldFactory() {
        super("Taint");
    }

    protected TaintFieldFactory(FieldFormatModel formatModel, HighlightProvider highlightProvider, Options displayOptions, Options fieldOptions) {
        super("Taint", formatModel, highlightProvider, displayOptions, fieldOptions);
    }

    public FieldFactory newInstance(FieldFormatModel formatModel, HighlightProvider highlightProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new TaintFieldFactory(formatModel, highlightProvider, (Options)displayOptions, (Options)fieldOptions);
    }

    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        StringPropertyMap taintMap = cu.getProgram().getUsrPropertyManager().getStringPropertyMap("Taint");
        if (taintMap == null) {
            return null;
        }
        TaintVec vec = new TaintVec(cu.getLength());
        for (int i = 0; i < vec.length; ++i) {
            String taintString = taintMap.getString(cu.getAddress().add((long)i));
            vec.set(i, taintString == null ? TaintSet.EMPTY : TaintSet.parse(taintString));
        }
        return ListingTextField.createSingleLineTextField((FieldFactory)this, proxy, (FieldElement)new TextFieldElement(new AttributedString(vec.toDisplay(), this.color, this.getMetrics()), 0, 0), (int)(this.startX + varWidth), (int)this.width, (HighlightProvider)this.hlProvider);
    }

    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation loc) {
        if (!(loc instanceof TaintFieldLocation)) {
            return null;
        }
        TaintFieldLocation tfLoc = (TaintFieldLocation)loc;
        return new FieldLocation(index, fieldNum, 0, tfLoc.getCharOffset());
    }

    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        ProxyObj proxy = bf.getProxy();
        Object obj = proxy.getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        return new TaintFieldLocation(proxy.getListingLayoutModel().getProgram(), cu.getAddress(), col);
    }

    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return category == 4;
    }
}

