/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.listing;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceCodeUnit;
import ghidra.trace.util.TraceRegisterUtils;

public interface TraceBaseCodeUnitsView<T extends TraceCodeUnit> {
    public Trace getTrace();

    public int size();

    public T getBefore(long var1, Address var3);

    public T getFloor(long var1, Address var3);

    public T getContaining(long var1, Address var3);

    public T getAt(long var1, Address var3);

    public T getCeiling(long var1, Address var3);

    public T getAfter(long var1, Address var3);

    public Iterable<? extends T> get(long var1, Address var3, Address var4, boolean var5);

    public Iterable<? extends T> get(long var1, AddressSetView var3, boolean var4);

    public Iterable<? extends T> get(long var1, AddressRange var3, boolean var4);

    public Iterable<? extends T> get(long var1, Address var3, boolean var4);

    public Iterable<? extends T> get(long var1, boolean var3);

    public Iterable<? extends T> getIntersecting(TraceAddressSnapRange var1);

    public AddressSetView getAddressSetView(long var1);

    public AddressSetView getAddressSetView(long var1, AddressRange var3);

    public boolean containsAddress(long var1, Address var3);

    public boolean coversRange(Range<Long> var1, AddressRange var2);

    public boolean coversRange(TraceAddressSnapRange var1);

    public boolean intersectsRange(Range<Long> var1, AddressRange var2);

    public boolean intersectsRange(TraceAddressSnapRange var1);

    default public T getForRegister(long snap, Register register) {
        return this.getForRegister(this.getTrace().getPlatformManager().getHostPlatform(), snap, register);
    }

    public T getForRegister(TracePlatform var1, long var2, Register var4);

    default public T getContaining(long snap, Register register) {
        return this.getContaining(this.getTrace().getPlatformManager().getHostPlatform(), snap, register);
    }

    public T getContaining(TracePlatform var1, long var2, Register var4);

    default public Iterable<? extends T> get(long snap, Register register, boolean forward) {
        return this.get(snap, TraceRegisterUtils.rangeForRegister(register), forward);
    }
}

