/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import com.google.common.collect.Range;
import ghidra.dbg.util.PathPredicates;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class SuccessorsRelativeVisitor
implements TreeTraversal.SpanIntersectingVisitor {
    protected final PathPredicates predicates;

    public SuccessorsRelativeVisitor(PathPredicates predicates) {
        this.predicates = predicates;
    }

    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre == null ? TraceObjectValPath.of() : pre.append(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath path) {
        List<String> keyList = path.getKeyList();
        return TreeTraversal.VisitResult.result(this.predicates.matches(keyList), this.predicates.successorCouldMatch(keyList, true) && value.isObject());
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.isObject() ? value.getChild() : null;
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Range<Long> span, TraceObjectValPath pre) {
        Set nextKeys = this.predicates.getNextKeys(pre.getKeyList());
        if (nextKeys.isEmpty()) {
            return Stream.empty();
        }
        Stream<Object> attrStream = nextKeys.contains("") ? object.getAttributes().stream().filter(v -> DBTraceUtils.intersect(span, v.getLifespan())) : Stream.empty();
        Stream<Object> elemStream = nextKeys.contains("[]") ? object.getElements().stream().filter(v -> DBTraceUtils.intersect(span, v.getLifespan())) : Stream.empty();
        Stream restStream = nextKeys.stream().filter(k -> !"".equals(k) && !"[]".equals(k)).flatMap(k -> object.getValues(span, (String)k).stream());
        return Stream.concat(Stream.concat(attrStream, elemStream), restStream);
    }
}

