/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceVariableSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceReferenceSpace;
import ghidra.trace.model.Trace;
import ghidra.trace.model.symbol.TraceReference;
import ghidra.trace.model.symbol.TraceSymbolWithLifespan;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.Lock;

public class DBTraceReference
implements TraceReference {
    protected final DBTraceReferenceSpace.DBTraceReferenceEntry ent;

    public DBTraceReference(DBTraceReferenceSpace.DBTraceReferenceEntry ent) {
        this.ent = ent;
    }

    @Override
    public DBTrace getTrace() {
        return this.ent.space.trace;
    }

    public TraceThread getThread() {
        return this.ent.space.getThread();
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            this.ent.doDelete();
            this.ent.space.trace.setChanged(new TraceChangeRecord<DBTraceReferenceSpace.DBTraceReferenceEntry, DBTraceReference>(Trace.TraceReferenceChangeType.DELETED, this.ent.space, this.ent, this));
            if (this.isPrimary()) {
                Collection<? extends DBTraceReference> remaining = this.ent.space.getReferencesFrom(this.getStartSnap(), this.getFromAddress(), this.getOperandIndex());
                if (remaining.isEmpty()) {
                    return;
                }
                DBTraceReference newPrimary = remaining.iterator().next();
                newPrimary.ent.setPrimary(true);
                this.ent.space.trace.setChanged(new TraceChangeRecord<DBTraceReference, Boolean>(Trace.TraceReferenceChangeType.PRIMARY_CHANGED, this.ent.space, this, false, true));
            }
        }
    }

    @Override
    public Range<Long> getLifespan() {
        return this.ent.getLifespan();
    }

    @Override
    public long getStartSnap() {
        return DBTraceUtils.lowerEndpoint(this.getLifespan());
    }

    public Address getFromAddress() {
        return this.ent.getX1();
    }

    public Address getToAddress() {
        return this.ent.toAddress;
    }

    @Override
    public void setPrimary(boolean primary) {
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            if (primary == this.isPrimary()) {
                return;
            }
            DBTraceReference oldPrimary = this.ent.space.getPrimaryReferenceFrom(this.getStartSnap(), this.getFromAddress(), this.getOperandIndex());
            if (oldPrimary != null) {
                oldPrimary.ent.setPrimary(false);
                this.ent.space.trace.setChanged(new TraceChangeRecord<DBTraceReference, Boolean>(Trace.TraceReferenceChangeType.PRIMARY_CHANGED, this.ent.space, oldPrimary, true, false));
            }
            this.ent.setPrimary(true);
            this.ent.space.trace.setChanged(new TraceChangeRecord<DBTraceReference, Boolean>(Trace.TraceReferenceChangeType.PRIMARY_CHANGED, this.ent.space, this, false, true));
        }
    }

    public boolean isPrimary() {
        return this.ent.isPrimary();
    }

    public long getSymbolID() {
        return this.ent.symbolId;
    }

    public RefType getReferenceType() {
        return this.ent.refType;
    }

    public int getOperandIndex() {
        return this.ent.opIndex;
    }

    public SourceType getSource() {
        return this.ent.getSourceType();
    }

    @Override
    public void setReferenceType(RefType refType) {
        if (refType == RefType.EXTERNAL_REF) {
            throw new IllegalArgumentException("Trace does not allow external references");
        }
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            this.ent.setRefType(refType);
        }
    }

    @Override
    public void setAssociatedSymbol(Symbol symbol) {
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            TraceSymbolWithLifespan symWl;
            AbstractDBTraceSymbol dbSym = this.getTrace().getSymbolManager().assertIsMine(symbol);
            if (this.ent.symbolId == symbol.getID()) {
                return;
            }
            Address toAddress = this.getToAddress();
            if (dbSym instanceof AbstractDBTraceVariableSymbol) {
                TraceSymbolWithLifespan symWl2;
                AbstractDBTraceVariableSymbol varSym = (AbstractDBTraceVariableSymbol)dbSym;
                DBTraceNamespaceSymbol parent = varSym.getParentNamespace();
                if (parent instanceof TraceSymbolWithLifespan && !(symWl2 = (TraceSymbolWithLifespan)((Object)parent)).getLifespan().isConnected(this.getLifespan())) {
                    throw new IllegalArgumentException("Associated symbol and reference must have connected lifespans");
                }
                if (!varSym.getVariableStorage().contains(toAddress)) {
                    throw new IllegalArgumentException(String.format("Variable symbol storage of '%s' must contain Reference's to address (%s)", varSym.getName(), toAddress));
                }
            } else if (!Objects.equals(symbol.getAddress(), toAddress)) {
                throw new IllegalArgumentException(String.format("Symbol address (%s) of '%s' must match Reference's to address (%s)", symbol.getAddress(), symbol.getName(), toAddress));
            }
            if (symbol instanceof TraceSymbolWithLifespan && !(symWl = (TraceSymbolWithLifespan)symbol).getLifespan().isConnected(this.getLifespan())) {
                throw new IllegalArgumentException("Associated symbol and reference must have connected lifespans");
            }
            this.ent.setSymbolId(symbol.getID());
            this.getTrace().setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, DBTraceReference>(Trace.TraceSymbolChangeType.ASSOCIATION_ADDED, this.ent.space, dbSym, null, this));
        }
    }

    @Override
    public void clearAssociatedSymbol() {
        try (LockHold hold = LockHold.lock((Lock)this.ent.space.lock.writeLock());){
            if (this.ent.symbolId == -1L) {
                return;
            }
            AbstractDBTraceSymbol oldSymbol = this.getTrace().getSymbolManager().getSymbolByID(this.ent.symbolId);
            this.ent.setSymbolId(-1L);
            this.getTrace().setChanged(new TraceChangeRecord<AbstractDBTraceSymbol, Object>((TraceChangeType<AbstractDBTraceSymbol, Object>)Trace.TraceSymbolChangeType.ASSOCIATION_REMOVED, this.ent.space, oldSymbol, this, null));
        }
    }

    public int hashCode() {
        return this.ent.getX1().hashCode();
    }
}

