/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Collections2;
import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.AutoParameterImpl;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.listing.VariableSizeException;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.listing.VariableUtilities;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.address.DBTraceOverlaySpaceAdapter;
import ghidra.trace.database.bookmark.DBTraceBookmarkType;
import ghidra.trace.database.data.DBTraceDataTypeManager;
import ghidra.trace.database.listing.DBTraceCommentAdapter;
import ghidra.trace.database.listing.DBTraceData;
import ghidra.trace.database.program.DBTraceProgramView;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceVariableSymbol;
import ghidra.trace.database.symbol.DBTraceFunctionStackFrame;
import ghidra.trace.database.symbol.DBTraceFunctionSymbolView;
import ghidra.trace.database.symbol.DBTraceLabelSymbol;
import ghidra.trace.database.symbol.DBTraceLocalVariableSymbol;
import ghidra.trace.database.symbol.DBTraceNamespaceSymbol;
import ghidra.trace.database.symbol.DBTraceParameterSymbol;
import ghidra.trace.database.symbol.DBTraceReference;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.bookmark.TraceBookmarkType;
import ghidra.trace.model.symbol.TraceFunctionSymbol;
import ghidra.trace.model.symbol.TraceLocalVariableSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@DBAnnotatedObjectInfo(version=1)
public class DBTraceFunctionSymbol
extends DBTraceNamespaceSymbol
implements TraceFunctionSymbol,
DBTraceOverlaySpaceAdapter.DecodesAddresses {
    static final String TABLE_NAME = "Functions";
    private static final byte CUSTOM_STORAGE_MASK = -128;
    private static final byte CUSTOM_STORAGE_CLEAR = 127;
    private static final byte NO_RETURN_MASK = 64;
    private static final byte NO_RETURN_CLEAR = -65;
    private static final byte VAR_ARGS_MASK = 32;
    private static final byte VAR_ARGS_CLEAR = -33;
    private static final byte INLINE_MASK = 16;
    private static final byte INLINE_CLEAR = -17;
    static final String ENTRY_COLUMN_NAME = "Entry";
    static final String START_SNAP_COLUMN_NAME = "Start";
    static final String END_SNAP_COLUMN_NAME = "End";
    static final String THUNKED_COLUMN_NAME = "Thunked";
    static final String FIXUP_COLUMN_NAME = "Fixup";
    static final String CALLING_CONVENTION_COLUMN_NAME = "CallingConvention";
    static final String SIGNATURE_SOURCE_COLUMN_NAME = "SignatureSource";
    static final String STACK_PURGE_COLUMN_NAME = "StackPurge";
    static final String STACK_RETURN_OFFSET_COLUMN_NAME = "ReturnOffset";
    @DBAnnotatedColumn(value="Entry")
    static DBObjectColumn ENTRY_COLUMN;
    @DBAnnotatedColumn(value="Start")
    static DBObjectColumn START_SNAP_COLUMN;
    @DBAnnotatedColumn(value="End")
    static DBObjectColumn END_SNAP_COLUMN;
    @DBAnnotatedColumn(value="Thunked")
    static DBObjectColumn THUNKED_COLUMN;
    @DBAnnotatedColumn(value="Fixup")
    static DBObjectColumn FIXUP_COLUMN;
    @DBAnnotatedColumn(value="CallingConvention")
    static DBObjectColumn CALLING_CONVENTION_COLUMN;
    @DBAnnotatedColumn(value="SignatureSource")
    static DBObjectColumn SIGNATURE_SOURCE_COLUMN;
    @DBAnnotatedColumn(value="StackPurge")
    static DBObjectColumn STACK_PURGE_COLUMN;
    @DBAnnotatedColumn(value="ReturnOffset")
    static DBObjectColumn STACK_RETURN_OFFSET_COLUMN;
    @DBAnnotatedField(column="Entry", codec=DBTraceOverlaySpaceAdapter.AddressDBFieldCodec.class)
    protected Address entryPoint = Address.NO_ADDRESS;
    @DBAnnotatedField(column="Start")
    protected long startSnap;
    @DBAnnotatedField(column="End")
    protected long endSnap;
    @DBAnnotatedField(column="Thunked", indexed=true)
    protected long thunkedKey = -1L;
    @DBAnnotatedField(column="Fixup")
    protected String callFixup;
    @DBAnnotatedField(column="CallingConvention")
    protected byte callingConventionID = (byte)-1;
    @DBAnnotatedField(column="SignatureSource")
    protected SourceType signatureSource = SourceType.ANALYSIS;
    @DBAnnotatedField(column="StackPurge")
    protected int stackPurge;
    @DBAnnotatedField(column="ReturnOffset")
    protected int stackReturnOffset;
    protected Range<Long> lifespan;
    protected DBTraceFunctionSymbol thunked;
    protected List<DBTraceLocalVariableSymbol> locals;
    protected List<DBTraceParameterSymbol> params;
    protected DBTraceParameterSymbol ret;
    protected List<AutoParameterImpl> autoParams;
    protected final DBTraceFunctionStackFrame frame = new DBTraceFunctionStackFrame(this);
    protected boolean foundBadVariables = false;

    public DBTraceFunctionSymbol(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(manager, store, record);
    }

    @Override
    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.lifespan = DBTraceUtils.toRange(this.startSnap, this.endSnap);
        this.thunked = this.thunkedKey == -1L ? null : (DBTraceFunctionSymbol)this.manager.functionStore.getObjectAt(this.thunkedKey);
    }

    protected void set(Range<Long> lifespan, Address entryPoint, String name, DBTraceFunctionSymbol thunked, DBTraceNamespaceSymbol parent, SourceType source) {
        this.name = name;
        this.parentID = parent.getID();
        this.doSetSource(source);
        this.entryPoint = entryPoint;
        this.startSnap = DBTraceUtils.lowerEndpoint(lifespan);
        this.endSnap = DBTraceUtils.upperEndpoint(lifespan);
        this.thunkedKey = thunked == null ? -1L : thunked.getKey();
        this.update(new DBObjectColumn[]{NAME_COLUMN, PARENT_COLUMN, START_SNAP_COLUMN, END_SNAP_COLUMN, FLAGS_COLUMN, ENTRY_COLUMN, THUNKED_COLUMN});
        this.parent = parent;
        this.lifespan = lifespan;
        this.thunked = thunked;
    }

    @Override
    protected void validateNameAndParent(String newName, DBTraceNamespaceSymbol newParent) throws DuplicateNameException {
    }

    protected void doCreateReturnParameter() {
        this.ret = (DBTraceParameterSymbol)this.manager.parameterStore.create();
        this.ret.set("<RETURN>", this, DataType.DEFAULT, VariableStorage.UNASSIGNED_STORAGE, -1, SourceType.DEFAULT);
    }

    protected static boolean isBadVariable(AbstractDBTraceVariableSymbol var) {
        return var.getAddress() == Address.NO_ADDRESS || var.getVariableStorage().isBadStorage();
    }

    protected void doLoadVariables() {
        if (!this.doLoadSymbolBasedVariables()) {
            return;
        }
    }

    protected boolean doLoadSymbolBasedVariables() {
        if (this.locals != null) {
            return false;
        }
        this.locals = new ArrayList<DBTraceLocalVariableSymbol>();
        this.params = new ArrayList<DBTraceParameterSymbol>();
        for (DBTraceLocalVariableSymbol lVar : this.manager.localVars.getChildren(this)) {
            this.locals.add(lVar);
        }
        for (DBTraceParameterSymbol pVar : this.manager.parameters.getChildren(this)) {
            this.params.add(pVar);
        }
        this.locals.sort(VariableUtilities::compare);
        this.params.sort(Comparator.comparing(DBTraceParameterSymbol::getOrdinal));
        this.ret = this.params.remove(0);
        assert (this.ret.getOrdinal() == -1);
        return true;
    }

    protected void doRenumberParameterOrdinals() {
        int ordinal = this.autoParams == null ? 0 : this.autoParams.size();
        for (DBTraceParameterSymbol param : this.params) {
            param.setOrdinal(ordinal++);
        }
    }

    protected void doPurgeBadVariables() {
        DBTraceParameterSymbol retVar;
        if (!this.foundBadVariables) {
            return;
        }
        ArrayList badns = new ArrayList();
        badns.addAll(Collections2.filter(this.manager.allLocals.getChildren(this), DBTraceFunctionSymbol::isBadVariable));
        if (badns.isEmpty()) {
            return;
        }
        DBTraceBookmarkType errType = this.manager.trace.getBookmarkManager().getOrDefineBookmarkType("Error");
        this.manager.trace.getBookmarkManager().addBookmark((Range)this.getLifespan(), this.entryPoint, (TraceBookmarkType)errType, "Bad Variables Removed", "Removed " + badns.size() + " bad variables");
        for (AbstractDBTraceVariableSymbol s : badns) {
            s.delete();
        }
        if (this.hasCustomVariableStorage() && (retVar = this.getReturn()).getVariableStorage().isBadStorage()) {
            DataType dt = retVar.getDataType();
            retVar.doSetStorageAndDataType(DBTraceFunctionSymbol.getDynamicReturnStorage(dt), dt);
        }
    }

    protected static SourceType max(SourceType a, SourceType b) {
        return a == b || a.isHigherPriorityThan(b) ? a : b;
    }

    protected void doUpdateSignatureSourceAfterVariableChange(SourceType source, DataType dt) {
        if (Undefined.isUndefined((DataType)dt)) {
            return;
        }
        SourceType highest = DBTraceFunctionSymbol.max(SourceType.ANALYSIS, DBTraceFunctionSymbol.max(source, this.signatureSource));
        if (this.signatureSource != highest) {
            this.signatureSource = highest;
            this.update(SIGNATURE_SOURCE_COLUMN);
        }
    }

    @Override
    public Range<Long> getLifespan() {
        return this.lifespan;
    }

    @Override
    public long getStartSnap() {
        return this.startSnap;
    }

    @Override
    public void setEndSnap(long endSnap) {
        if (this.endSnap == endSnap) {
            return;
        }
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            Range<Long> newLifespan = DBTraceUtils.toRange(this.startSnap, endSnap);
            this.endSnap = endSnap;
            this.update(END_SNAP_COLUMN);
            Range<Long> oldLifespan = this.lifespan;
            this.lifespan = newLifespan;
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, Range<Long>>(Trace.TraceSymbolChangeType.LIFESPAN_CHANGED, this.getSpace(), this, oldLifespan, newLifespan));
        }
    }

    @Override
    public long getEndSnap() {
        return this.endSnap;
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.FUNCTION;
    }

    @Override
    protected Pair<String, SourceType> validateNameAndSource(String newName, SourceType newSource) throws InvalidInputException {
        if (newName == null || "".contentEquals(newName) || SymbolUtilities.getDefaultFunctionName((Address)this.entryPoint).equals(newName)) {
            return new ImmutablePair((Object)"", (Object)SourceType.DEFAULT);
        }
        if (newSource == SourceType.DEFAULT) {
            throw new IllegalArgumentException("Cannot assign non-default name with DEFAULT source");
        }
        return new ImmutablePair((Object)newName, (Object)newSource);
    }

    @Override
    public String getName() {
        if (this.getSource() == SourceType.DEFAULT) {
            if (this.thunked != null) {
                if (this.thunked.getSource() == SourceType.DEFAULT && this.thunked.thunked == null) {
                    return "thunk_" + this.thunked.getName();
                }
                return this.thunked.getName();
            }
            return SymbolUtilities.getDefaultFunctionName((Address)this.entryPoint);
        }
        return super.getName();
    }

    @Override
    public Address getAddress() {
        return this.entryPoint;
    }

    public void setCallFixup(String newCallFixup) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.setCallFixup(newCallFixup);
                return;
            }
            String oldCallFixup = this.callFixup;
            if (Objects.equals(oldCallFixup, newCallFixup)) {
                return;
            }
            this.callFixup = newCallFixup;
            this.update(FIXUP_COLUMN);
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, String>(Trace.TraceFunctionChangeType.CHANGED_CALL_FIXUP, this.getSpace(), this, oldCallFixup, newCallFixup));
        }
    }

    public String getCallFixup() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                String string = this.thunked.getCallFixup();
                return string;
            }
            String string = this.callFixup;
            return string;
        }
    }

    public String getComment(int commentType) {
        return this.manager.trace.getCommentAdapter().getComment(this.startSnap, this.entryPoint, commentType);
    }

    public String getComment() {
        return this.getComment(3);
    }

    public String[] getCommentAsArray() {
        return DBTraceCommentAdapter.arrayFromComment(this.getComment());
    }

    public void setComment(int commentType, String comment) {
        this.manager.trace.getCommentAdapter().setComment(this.lifespan, this.entryPoint, commentType, comment);
    }

    public void setComment(String comment) {
        this.setComment(3, comment);
    }

    public String getRepeatableComment() {
        return this.getComment(4);
    }

    public String[] getRepeatableCommentAsArray() {
        return DBTraceCommentAdapter.arrayFromComment(this.getRepeatableComment());
    }

    public void setRepeatableComment(String comment) {
        this.setComment(4, comment);
    }

    public Address getEntryPoint() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Address address = this.entryPoint;
            return address;
        }
    }

    public DataType getReturnType() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            DataType dataType = this.getReturn().getDataType();
            return dataType;
        }
    }

    public void setReturnType(DataType type, SourceType source) throws InvalidInputException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.getReturn().setDataType(type, source);
        }
    }

    @Override
    public DBTraceParameterSymbol getReturn() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                DBTraceParameterSymbol dBTraceParameterSymbol = this.thunked.getReturn();
                return dBTraceParameterSymbol;
            }
            this.doLoadVariables();
            DBTraceParameterSymbol dBTraceParameterSymbol = this.ret;
            return dBTraceParameterSymbol;
        }
    }

    public void setReturn(DataType type, VariableStorage storage, SourceType source) throws InvalidInputException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.setReturn(type, storage, source);
                return;
            }
            type = type.clone((DataTypeManager)this.manager.dataTypeManager);
            if (storage.isValid() && storage.size() != type.getLength()) {
                storage = VariableUtilities.resizeStorage((VariableStorage)storage, (DataType)type, (boolean)true, (Function)this);
            }
            this.getReturn().setDataType(type, storage, true, source);
        }
    }

    public FunctionSignature getSignature() {
        return this.getSignature(false);
    }

    public FunctionSignature getSignature(boolean formalSignature) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked == null) {
                this.doLoadVariables();
            }
            FunctionDefinitionDataType functionDefinitionDataType = new FunctionDefinitionDataType((Function)this, formalSignature);
            return functionDefinitionDataType;
        }
    }

    protected boolean hasExplicitCallingConvention() {
        return this.callingConventionID != -1 && this.callingConventionID != -2;
    }

    public String getPrototypeString(boolean formalSignature, boolean includeCallingConvention) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked == null) {
                this.doLoadVariables();
            }
            StringBuilder sb = new StringBuilder();
            DBTraceParameterSymbol retVar = this.getReturn();
            sb.append((formalSignature ? retVar.getFormalDataType() : retVar.getDataType()).getDisplayName());
            sb.append(' ');
            if (includeCallingConvention && this.hasExplicitCallingConvention()) {
                String cc = this.getCallingConventionName();
                sb.append(cc);
                sb.append(' ');
            }
            sb.append(this.getName());
            sb.append('(');
            Parameter[] parameters = this.getParameters();
            int n = parameters.length;
            boolean emptyList = true;
            for (int i = 0; i < n; ++i) {
                Parameter param = parameters[i];
                if (formalSignature && param.isAutoParameter()) continue;
                DataType dt = formalSignature ? param.getFormalDataType() : param.getDataType();
                sb.append(dt.getDisplayName());
                sb.append(' ');
                sb.append(param.getName());
                emptyList = false;
                if (i >= n - 1) continue;
                sb.append(", ");
            }
            if (this.hasVarArgs()) {
                sb.append(", ");
                sb.append("...");
            } else if (emptyList && this.getSignatureSource() != SourceType.DEFAULT) {
                sb.append("void");
            }
            sb.append(")");
            String string = sb.toString();
            return string;
        }
    }

    public SourceType getSignatureSource() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                SourceType sourceType = this.thunked.getSignatureSource();
                return sourceType;
            }
            if (!this.getReturn().isValid()) {
                SourceType sourceType = SourceType.DEFAULT;
                return sourceType;
            }
            for (Parameter param : this.getParameters()) {
                if (param.isValid()) continue;
                SourceType sourceType = SourceType.DEFAULT;
                return sourceType;
            }
            SourceType sourceType = this.signatureSource;
            return sourceType;
        }
    }

    public void setSignatureSource(SourceType signatureSource) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.setSignatureSource(signatureSource);
                return;
            }
            this.signatureSource = signatureSource;
            this.update(SIGNATURE_SOURCE_COLUMN);
        }
    }

    public StackFrame getStackFrame() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                StackFrame stackFrame = this.thunked.getStackFrame();
                return stackFrame;
            }
            DBTraceFunctionStackFrame dBTraceFunctionStackFrame = this.frame;
            return dBTraceFunctionStackFrame;
        }
    }

    public int getStackPurgeSize() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                int n = this.thunked.getStackPurgeSize();
                return n;
            }
            int n = this.stackPurge;
            return n;
        }
    }

    public Set<FunctionTag> getTags() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            HashSet<FunctionTag> result = new HashSet<FunctionTag>();
            for (DBTraceSymbolManager.DBTraceFunctionTagMapping mapping : this.manager.tagMappingsByFunc.get((Object)this.getKey())) {
                result.add((FunctionTag)this.manager.tagStore.getObjectAt(mapping.getTagKey()));
            }
            HashSet<FunctionTag> hashSet = result;
            return hashSet;
        }
    }

    public boolean addTag(String tagName) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceSymbolManager.DBTraceFunctionTag tag = (DBTraceSymbolManager.DBTraceFunctionTag)this.manager.tagsByName.getOne((Object)tagName);
            if (tag != null) {
                for (DBTraceSymbolManager.DBTraceFunctionTagMapping mapping : this.manager.tagMappingsByFunc.get((Object)this.getKey())) {
                    if (mapping.getTagKey() != tag.getKey()) continue;
                    boolean bl = false;
                    return bl;
                }
            } else {
                tag = (DBTraceSymbolManager.DBTraceFunctionTag)this.manager.tagStore.create();
                tag.setName(tagName);
                this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionTagChangeType.ADDED, null, tag));
            }
            DBTraceSymbolManager.DBTraceFunctionTagMapping mapping = (DBTraceSymbolManager.DBTraceFunctionTagMapping)this.manager.tagMappingStore.create();
            mapping.set(this, tag);
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, DBTraceSymbolManager.DBTraceFunctionTag>(Trace.TraceFunctionChangeType.TAG_APPLIED, this.getSpace(), this, null, tag));
            boolean bl = true;
            return bl;
        }
    }

    public void removeTag(String tagName) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceSymbolManager.DBTraceFunctionTag tag = (DBTraceSymbolManager.DBTraceFunctionTag)this.manager.tagsByName.getOne((Object)tagName);
            if (tag == null) {
                return;
            }
            for (DBTraceSymbolManager.DBTraceFunctionTagMapping mapping : this.manager.tagMappingsByFunc.get((Object)this.getKey())) {
                if (mapping.getTagKey() != tag.getKey()) continue;
                this.manager.tagMappingStore.delete((DBAnnotatedObject)mapping);
                this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, Object>((TraceChangeType<DBTraceFunctionSymbol, Object>)Trace.TraceFunctionChangeType.TAG_REMOVED, this.getSpace(), this, tag, null));
            }
        }
    }

    public void setStackPurgeSize(int newStackPurge) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.setStackPurgeSize(newStackPurge);
                return;
            }
            int oldStackPurge = this.stackPurge;
            if (oldStackPurge == newStackPurge) {
                return;
            }
            this.stackPurge = newStackPurge;
            this.update(STACK_PURGE_COLUMN);
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, Integer>(Trace.TraceFunctionChangeType.CHANGED_PURGE, this.getSpace(), this, oldStackPurge, newStackPurge));
        }
    }

    public boolean isStackPurgeSizeValid() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                boolean bl = this.thunked.isStackPurgeSizeValid();
                return bl;
            }
            boolean bl = this.stackPurge < 0x1000000;
            return bl;
        }
    }

    protected Variable resolveVariable(Variable var, boolean voidOK, boolean useUnassignedStorage) throws InvalidInputException {
        DataType dt = var.getDataType();
        if (var instanceof Parameter) {
            dt = ((Parameter)var).getFormalDataType();
        }
        DBTraceProgramView program = this.getProgram();
        dt = VariableUtilities.checkDataType((DataType)dt, (boolean)voidOK, (int)Math.min(1, var.getLength()), (Program)program);
        DataType resolvedDt = this.manager.dataTypeManager.resolve(dt, null);
        VariableStorage storage = VariableStorage.UNASSIGNED_STORAGE;
        if (!useUnassignedStorage) {
            storage = var.getVariableStorage();
            if (storage.isAutoStorage()) {
                storage = new VariableStorage((Program)program, storage.getVarnodes());
            }
            if (resolvedDt.getLength() != storage.size()) {
                storage = VariableUtilities.resizeStorage((VariableStorage)storage, (DataType)resolvedDt, (boolean)true, (Function)this);
            }
        }
        LocalVariableImpl resolvedVar = new LocalVariableImpl(var.getName(), var.getFirstUseOffset(), resolvedDt, storage, true, (Program)program, var.getSource());
        resolvedVar.setComment(var.getComment());
        return resolvedVar;
    }

    protected static VariableStorage getDynamicReturnStorage(DataType dt) {
        DataType baseType = DBTraceData.getBaseDataType(dt);
        return baseType instanceof VoidDataType ? VariableStorage.VOID_STORAGE : VariableStorage.UNASSIGNED_STORAGE;
    }

    protected void doUpdateParametersAndReturn() {
        if (this.params == null) {
            this.doLoadVariables();
        }
        if (this.hasCustomVariableStorage()) {
            this.autoParams = null;
            this.doRenumberParameterOrdinals();
            return;
        }
        DataType[] dataTypes = new DataType[this.params.size() + 1];
        for (int i = 0; i < this.params.size(); ++i) {
            DBTraceParameterSymbol param = this.params.get(i);
            param.doSetDynamicStorage(VariableStorage.UNASSIGNED_STORAGE);
            dataTypes[i + 1] = param.getDataType();
        }
        dataTypes[0] = this.ret.getFormalDataType();
        this.ret.doSetDynamicStorage(DBTraceFunctionSymbol.getDynamicReturnStorage(dataTypes[0]));
        PrototypeModel cc = this.getCallingConvention();
        if (cc == null) {
            cc = this.manager.functions.getDefaultCallingConvention();
        }
        if (cc == null) {
            return;
        }
        VariableStorage[] storages = cc.getStorageLocations((Program)this.getProgram(), dataTypes, true);
        this.ret.doSetDynamicStorage(storages[0]);
        int autoIndex = 0;
        int paramIndex = 0;
        this.autoParams = null;
        for (int i = 1; i < storages.length; ++i) {
            VariableStorage s = storages[i];
            if (s.isAutoStorage()) {
                if (this.autoParams == null) {
                    this.autoParams = new ArrayList<AutoParameterImpl>();
                }
                DataType dt = VariableUtilities.getAutoDataType((Function)this, (DataType)this.ret.getFormalDataType(), (VariableStorage)s);
                try {
                    this.autoParams.add(new AutoParameterImpl(dt, autoIndex++, s, (Function)this));
                    continue;
                }
                catch (InvalidInputException e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.params.get(paramIndex++).doSetDynamicStorage(s);
        }
        this.doRenumberParameterOrdinals();
    }

    @Override
    public DBTraceParameterSymbol addParameter(Variable var, SourceType source) throws DuplicateNameException, InvalidInputException {
        return this.insertParameter(this.getParameterCount(), var, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBTraceParameterSymbol insertParameter(int ordinal, Variable var, SourceType source) throws DuplicateNameException, InvalidInputException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            int stackOffset;
            if (this.thunked != null) {
                DBTraceParameterSymbol dBTraceParameterSymbol = this.thunked.insertParameter(ordinal, var, source);
                return dBTraceParameterSymbol;
            }
            this.doLoadVariables();
            this.doPurgeBadVariables();
            int autoCnt = this.autoParams == null ? 0 : this.autoParams.size();
            int index = ordinal - autoCnt;
            if (index < 0 || index > this.params.size()) {
                throw new IndexOutOfBoundsException("Ordinal value must be in [" + autoCnt + ".." + (this.params.size() + autoCnt) + "]: " + ordinal);
            }
            DBTraceFunctionSymbol.assertNotUniqueSpace(var);
            boolean hasCustomStorage = this.hasCustomVariableStorage();
            if (hasCustomStorage && var.hasStackStorage() && !this.frame.isParameterOffset(stackOffset = (int)var.getLastStorageVarnode().getOffset())) {
                throw new InvalidInputException("Variable contains invalid stack parameter offset: " + var.getName() + " offset " + stackOffset);
            }
            var = this.resolveVariable(var, false, !hasCustomStorage);
            String varName = var.getName();
            SourceType paramSource = source;
            if (paramSource == SourceType.DEFAULT || SymbolUtilities.isDefaultParameterName((String)varName)) {
                varName = "";
                paramSource = SourceType.DEFAULT;
            }
            VariableStorage storage = var.getVariableStorage();
            if (!hasCustomStorage) {
                storage = VariableStorage.UNASSIGNED_STORAGE;
            } else if (storage.isAutoStorage()) {
                storage = new VariableStorage((Program)this.getProgram(), storage.getVarnodes());
            }
            try {
                DBTraceParameterSymbol p = null;
                if (storage != VariableStorage.UNASSIGNED_STORAGE) {
                    for (DBTraceParameterSymbol oldParam : this.params) {
                        if (oldParam.getVariableStorage().intersects(storage)) {
                            p = oldParam;
                            break;
                        }
                        VariableUtilities.checkVariableConflict((Function)this, (Variable)(p != null ? p : var), (VariableStorage)storage, (boolean)true);
                    }
                }
                if (p != null) {
                    if (index >= this.params.size()) {
                        index = this.params.size() - 1;
                    }
                    Msg.warn((Object)this, (Object)("Inserting overlapping parameter for function " + this + " at " + p.getVariableStorage() + " - Replacing existing parameter!"));
                    if (p.getOrdinal() - autoCnt != index) {
                        if (p != this.params.remove(p.getOrdinal() - autoCnt)) {
                            throw new AssertionError((Object)"Inconsistent function parameter cache");
                        }
                        this.params.add(index, p);
                        this.doUpdateParametersAndReturn();
                        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSymbolChangeType.CHANGED, this.getSpace(), p));
                    }
                    if (!"".equals(varName)) {
                        p.setName(varName, paramSource);
                    }
                    p.doSetStorageAndDataType(storage, var.getDataType());
                } else {
                    if (index > this.params.size()) {
                        index = this.params.size();
                    }
                    p = (DBTraceParameterSymbol)this.manager.parameterStore.create();
                    p.set(varName, this, var.getDataType(), storage, ordinal, paramSource);
                    this.params.add(index, p);
                    this.doUpdateParametersAndReturn();
                    this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSymbolChangeType.ADDED, this.getSpace(), p));
                }
                if (var.getComment() != null) {
                    p.setComment(var.getComment());
                }
                this.doUpdateSignatureSourceAfterVariableChange(source, p.getDataType());
                DBTraceParameterSymbol dBTraceParameterSymbol = p;
                this.frame.invalidate();
                return dBTraceParameterSymbol;
            }
            catch (Throwable throwable) {
                this.frame.invalidate();
                throw throwable;
            }
        }
    }

    public void replaceParameters(List<? extends Variable> newParams, Function.FunctionUpdateType updateType, boolean force, SourceType source) throws DuplicateNameException, InvalidInputException {
        this.updateFunction(null, null, newParams, updateType, force, source);
    }

    public void replaceParameters(Function.FunctionUpdateType updateType, boolean force, SourceType source, Variable ... newParams) throws DuplicateNameException, InvalidInputException {
        this.updateFunction(null, null, Arrays.asList(newParams), updateType, force, source);
    }

    public void updateFunction(String callingConvention, Variable returnVar, Function.FunctionUpdateType updateType, boolean force, SourceType source, Variable ... newParams) throws DuplicateNameException, InvalidInputException {
        this.updateFunction(callingConvention, returnVar, Arrays.asList(newParams), updateType, force, source);
    }

    protected static void doCheckForParameterNameConflict(Variable param, Collection<? extends Variable> newParams, Collection<String> nonParamNames) throws DuplicateNameException {
        String name = param.getName();
        if (name == null || name.length() == 0 || SymbolUtilities.isDefaultParameterName((String)name)) {
            return;
        }
        for (Variable variable : newParams) {
            if (param == variable || !name.equals(variable.getName())) continue;
            throw new DuplicateNameException("Duplicate parameter name '" + name + "'");
        }
        if (nonParamNames.contains(name)) {
            throw new DuplicateNameException("Duplicate variable name '" + name + "'");
        }
    }

    protected void doCheckStorageConflicts(List<? extends Variable> newParams, boolean removeConflictingLocals) throws VariableSizeException {
        VariableUtilities.VariableConflictHandler localConflictHandler = removeConflictingLocals ? conflicts -> {
            for (Variable var : conflicts) {
                this.removeVariable(var);
            }
            return true;
        } : null;
        for (Variable variable : newParams) {
            VariableUtilities.checkVariableConflict(newParams, (Variable)variable, (VariableStorage)variable.getVariableStorage(), null);
            VariableUtilities.checkVariableConflict(this.locals, (Variable)variable, (VariableStorage)variable.getVariableStorage(), (VariableUtilities.VariableConflictHandler)localConflictHandler);
        }
    }

    protected static int findPointerParameterNamed(List<? extends Variable> params, String name) {
        for (int i = 0; i < params.size(); ++i) {
            Variable p = params.get(i);
            if (!(p.getDataType() instanceof Pointer) || !name.equals(p.getName())) continue;
            return i;
        }
        return -1;
    }

    protected static int findExplicitThisParameter(List<? extends Variable> params) {
        return DBTraceFunctionSymbol.findPointerParameterNamed(params, THIS_PARAM_NAME);
    }

    protected static boolean removeExplicitThisParameter(List<? extends Variable> params, String callingConventionName) {
        if (!"__thiscall".equals(callingConventionName)) {
            return false;
        }
        int thisIndex = DBTraceFunctionSymbol.findExplicitThisParameter(params);
        if (thisIndex < 0) {
            return false;
        }
        params.remove(thisIndex);
        return true;
    }

    protected boolean doRemoveExplicitThisParameter() {
        if (!"__thiscall".equals(this.getCallingConventionName())) {
            return false;
        }
        int thisIndex = DBTraceFunctionSymbol.findExplicitThisParameter(this.params);
        if (thisIndex < 0) {
            return false;
        }
        this.removeParameter(thisIndex);
        return true;
    }

    protected static int findExplicitReturnStorageParameter(List<? extends Variable> params) {
        return DBTraceFunctionSymbol.findPointerParameterNamed(params, RETURN_PTR_PARAM_NAME);
    }

    protected static boolean removeExplicitReturnStorageParameter(List<? extends Variable> params) {
        int paramIndex = DBTraceFunctionSymbol.findExplicitReturnStorageParameter(params);
        if (paramIndex < 0) {
            return false;
        }
        params.remove(paramIndex);
        return true;
    }

    protected boolean doRemoveExplicitReturnStorageParameter() {
        int paramIndex = DBTraceFunctionSymbol.findExplicitReturnStorageParameter(this.params);
        if (paramIndex < 0) {
            return false;
        }
        this.removeParameter(paramIndex);
        return true;
    }

    protected static Variable revertIndirectParameter(Variable param, boolean create) {
        DataType dt = param.getDataType();
        if (!(dt instanceof Pointer)) {
            return param;
        }
        Pointer pdt = (Pointer)dt;
        try {
            if (create) {
                return new ParameterImpl(param.getName(), pdt.getDataType(), param.getProgram());
            }
            param.setDataType(pdt.getDataType(), VariableStorage.UNASSIGNED_STORAGE, false, param.getSource());
            return param;
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected static DataType revertTypeIfIndirect(DataType dt, VariableStorage s) {
        if (!s.isForcedIndirect()) {
            return dt;
        }
        if (!(dt instanceof Pointer)) {
            return dt;
        }
        return ((Pointer)dt).getDataType();
    }

    protected static DataType getFormalDataTypeOf(Variable var) {
        if (var instanceof Parameter) {
            Parameter param = (Parameter)var;
            return param.getFormalDataType();
        }
        return var.getDataType();
    }

    protected static void assertNotUniqueSpace(Variable var) {
        if (!var.isUniqueVariable()) {
            return;
        }
        throw new IllegalArgumentException("Cannot use a unique-space variable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void updateFunction(String callingConvention, Variable returnVar, List<? extends Variable> newParams, Function.FunctionUpdateType updateType, boolean force, SourceType source) throws DuplicateNameException, InvalidInputException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            void i;
            DataType dt;
            Variable newParam;
            void var14_20;
            if (this.thunked != null) {
                this.thunked.updateFunction(callingConvention, returnVar, newParams, updateType, force, source);
                return;
            }
            this.doLoadVariables();
            this.doPurgeBadVariables();
            boolean useCustomStorage = updateType == Function.FunctionUpdateType.CUSTOM_STORAGE;
            this.setCustomVariableStorage(useCustomStorage);
            if (callingConvention != null) {
                this.setCallingConvention(callingConvention);
            }
            callingConvention = this.getCallingConventionName();
            if (returnVar == null) {
                returnVar = this.ret;
            } else if (returnVar != this.ret) {
                returnVar.setName("<RETURN>", returnVar.getSource());
                DBTraceFunctionSymbol.assertNotUniqueSpace(returnVar);
            }
            DataType returnType = returnVar.getDataType();
            VariableStorage returnStorage = returnVar.getVariableStorage();
            if (!useCustomStorage) {
                Variable firstParam;
                newParams = new ArrayList<Variable>(newParams);
                boolean thisParamRemoved = DBTraceFunctionSymbol.removeExplicitThisParameter(newParams, callingConvention);
                if (DBTraceFunctionSymbol.removeExplicitReturnStorageParameter(newParams)) {
                    returnVar = DBTraceFunctionSymbol.revertIndirectParameter(returnVar, true);
                }
                returnType = DBTraceFunctionSymbol.getFormalDataTypeOf(returnVar);
                returnStorage = VariableStorage.UNASSIGNED_STORAGE;
                if (updateType == Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS && !thisParamRemoved && "__thiscall".contentEquals(callingConvention) && newParams.size() != 0 && (firstParam = newParams.get(0)).getSource() == SourceType.DEFAULT && firstParam.getLength() == this.manager.dataTypeManager.getDataOrganization().getPointerSize()) {
                    newParams.remove(0);
                }
            }
            this.getReturn().setDataType(returnType, returnStorage, true, source);
            HashSet<String> nonParamNames = new HashSet<String>();
            for (Object s : this.manager.labels.getChildren(this)) {
                nonParamNames.add(((AbstractDBTraceSymbol)s).getName());
            }
            for (Object s : this.manager.localVars.getChildren(this)) {
                nonParamNames.add(((AbstractDBTraceSymbol)s).getName());
            }
            ArrayList<? extends Variable> resolvedParams = new ArrayList<Variable>();
            for (Variable variable : newParams) {
                if (!useCustomStorage && variable instanceof AutoParameterImpl) continue;
                DBTraceFunctionSymbol.assertNotUniqueSpace(variable);
                DBTraceFunctionSymbol.doCheckForParameterNameConflict(variable, newParams, nonParamNames);
                resolvedParams.add((Variable)this.resolveVariable(variable, false, !useCustomStorage));
            }
            newParams = resolvedParams;
            if (useCustomStorage) {
                this.doCheckStorageConflicts(newParams, force);
            }
            List<DBTraceParameterSymbol> oldParams = this.params;
            this.params = new ArrayList<DBTraceParameterSymbol>();
            for (DBTraceParameterSymbol param : oldParams) {
                param.setName(null, SourceType.DEFAULT);
            }
            boolean bl = false;
            while (var14_20 < oldParams.size() && var14_20 < newParams.size()) {
                DBTraceParameterSymbol oldParam = oldParams.get((int)var14_20);
                newParam = newParams.get((int)var14_20);
                dt = DBTraceFunctionSymbol.getFormalDataTypeOf(newParam);
                oldParam.setName(newParam.getName(), newParam.getSource());
                oldParam.doSetStorageAndDataType(newParam.getVariableStorage(), dt);
                oldParam.setComment(newParam.getComment());
                this.params.add(oldParam);
                this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSymbolChangeType.CHANGED, this.getSpace(), oldParam));
                ++var14_20;
            }
            for (i = var14_20; i < oldParams.size(); ++i) {
                oldParams.get((int)i).delete();
            }
            for (i = var14_20; i < newParams.size(); ++i) {
                newParam = newParams.get((int)i);
                dt = DBTraceFunctionSymbol.getFormalDataTypeOf(newParam);
                VariableStorage storage = useCustomStorage ? newParam.getVariableStorage() : VariableStorage.UNASSIGNED_STORAGE;
                String newName = newParam.getName();
                if (newName == null || newName.length() == 0) {
                    newName = SymbolUtilities.getDefaultParamName((int)i);
                }
                DBTraceParameterSymbol s = (DBTraceParameterSymbol)this.manager.parameterStore.create();
                s.set(newName, this, dt, storage, (int)i, newParam.getSource());
                s.setComment(newParam.getComment());
                this.params.add(s);
                this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceSymbolChangeType.ADDED, this.getSpace(), s));
            }
            if (source.isHigherPriorityThan(this.signatureSource)) {
                this.signatureSource = source;
                this.update(SIGNATURE_SOURCE_COLUMN);
            }
            this.doUpdateParametersAndReturn();
        }
        finally {
            this.frame.invalidate();
        }
    }

    protected void doDeleteVariable(AbstractDBTraceVariableSymbol var) {
        if (DBTraceFunctionSymbol.isBadVariable(var)) {
            return;
        }
        this.doLoadVariables();
        if (var instanceof DBTraceParameterSymbol) {
            if (this.params.remove(var)) {
                this.frame.invalidate();
                this.doUpdateParametersAndReturn();
            }
        } else if (this.locals.remove(var)) {
            this.frame.invalidate();
        }
    }

    public void removeParameter(int ordinal) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.removeParameter(ordinal);
                return;
            }
            this.doLoadVariables();
            int index = ordinal;
            if (index < 0) {
                throw new IndexOutOfBoundsException(ordinal);
            }
            if (this.autoParams != null) {
                if (index < this.autoParams.size()) {
                    return;
                }
                index -= this.autoParams.size();
            }
            if (index >= this.params.size()) {
                throw new IndexOutOfBoundsException(ordinal);
            }
            this.params.get(ordinal).delete();
        }
    }

    @Override
    public Parameter moveParameter(int fromOrdinal, int toOrdinal) throws InvalidInputException {
        if (toOrdinal < 0) {
            throw new InvalidInputException("destination ordinal cannot be negative");
        }
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            int autoCnt;
            if (this.thunked != null) {
                Parameter parameter = this.thunked.moveParameter(fromOrdinal, toOrdinal);
                return parameter;
            }
            this.doLoadVariables();
            if (fromOrdinal < 0) {
                Parameter parameter = null;
                return parameter;
            }
            int n = autoCnt = this.autoParams == null ? 0 : this.autoParams.size();
            if (fromOrdinal < autoCnt || toOrdinal < autoCnt) {
                throw new InvalidInputException("Neither source nor destination ordinal can be within auto-parameters");
            }
            int fromIndex = fromOrdinal - autoCnt;
            int toIndex = toOrdinal - autoCnt;
            if (fromIndex > this.params.size()) {
                Parameter parameter = null;
                return parameter;
            }
            DBTraceParameterSymbol param = this.params.get(fromIndex);
            if (toIndex == fromIndex) {
                DBTraceParameterSymbol dBTraceParameterSymbol = param;
                return dBTraceParameterSymbol;
            }
            this.params.remove(fromIndex);
            if (toIndex >= this.params.size()) {
                this.params.add(param);
            } else {
                this.params.add(toIndex, param);
            }
            this.doUpdateParametersAndReturn();
            this.frame.invalidate();
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED_PARAMETERS, this.getSpace(), this));
            DBTraceParameterSymbol dBTraceParameterSymbol = param;
            return dBTraceParameterSymbol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBTraceLocalVariableSymbol addLocalVariable(Variable var, SourceType source) throws DuplicateNameException, InvalidInputException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            String varName;
            if (this.thunked != null) {
                DBTraceLocalVariableSymbol dBTraceLocalVariableSymbol = this.thunked.addLocalVariable(var, source);
                return dBTraceLocalVariableSymbol;
            }
            this.doLoadVariables();
            this.doPurgeBadVariables();
            var = this.resolveVariable(var, false, false);
            VariableStorage storage = var.getVariableStorage();
            int firstUseOffset = var.getFirstUseOffset();
            if (var.hasStackStorage() && firstUseOffset != 0) {
                Msg.warn((Object)this, (Object)("Stack variable first-use offset forced to 0 for function " + this + " at " + storage));
                firstUseOffset = 0;
            }
            if (SymbolUtilities.isDefaultParameterName((String)(varName = var.getName()))) {
                varName = "local_";
                source = SourceType.DEFAULT;
            }
            Variable lv = null;
            for (DBTraceLocalVariableSymbol oldLocal : this.locals) {
                if (oldLocal.getFirstUseOffset() != firstUseOffset || !oldLocal.getVariableStorage().intersects(storage)) continue;
                lv = oldLocal;
                break;
            }
            try {
                VariableUtilities.checkVariableConflict((Function)this, (Variable)(lv != null ? lv : var), (VariableStorage)storage, (boolean)true);
                if (lv != null) {
                    Msg.warn((Object)this, (Object)("Adding overlapping local variable for function " + this + " at " + lv.getVariableStorage() + " - Modifying existing variable!"));
                    if (!"local_".equals(this.name)) {
                        lv.setName(varName, source);
                    }
                    lv.doSetStorageAndDataType(storage, var.getDataType());
                } else {
                    lv = (DBTraceLocalVariableSymbol)this.manager.localVarStore.create();
                    lv.set(varName, this, var.getDataType(), storage, firstUseOffset, source);
                    this.locals.add((DBTraceLocalVariableSymbol)lv);
                    this.locals.sort(VariableUtilities::compare);
                }
                if (var.getComment() != null) {
                    lv.setComment(var.getComment());
                }
                Variable variable = lv;
                this.frame.invalidate();
                return variable;
            }
            catch (Throwable throwable) {
                this.frame.invalidate();
                throw throwable;
            }
        }
    }

    public void removeVariable(Variable var) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.removeVariable(var);
                return;
            }
            this.doLoadVariables();
            if (!(var instanceof AbstractDBTraceVariableSymbol)) {
                return;
            }
            AbstractDBTraceVariableSymbol dbVar = (AbstractDBTraceVariableSymbol)var;
            if (this.params.contains(dbVar) || this.locals.contains(dbVar)) {
                dbVar.delete();
            }
        }
    }

    @Override
    public Parameter getParameter(int ordinal) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                Parameter parameter = this.thunked.getParameter(ordinal);
                return parameter;
            }
            this.doLoadVariables();
            if (ordinal == -1) {
                DBTraceParameterSymbol dBTraceParameterSymbol = this.ret;
                return dBTraceParameterSymbol;
            }
            if (this.autoParams != null) {
                if (ordinal < this.autoParams.size()) {
                    Parameter parameter = (Parameter)this.autoParams.get(ordinal);
                    return parameter;
                }
                ordinal -= this.autoParams.size();
            }
            if (ordinal < this.params.size()) {
                Parameter parameter = this.params.get(ordinal);
                return parameter;
            }
            Parameter parameter = null;
            return parameter;
        }
    }

    public int getParameterCount() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                int n = this.thunked.getParameterCount();
                return n;
            }
            this.doLoadVariables();
            if (this.autoParams != null) {
                int n = this.autoParams.size() + this.params.size();
                return n;
            }
            int n = this.params.size();
            return n;
        }
    }

    public int getAutoParameterCount() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                int n = this.thunked.getAutoParameterCount();
                return n;
            }
            this.doLoadVariables();
            if (this.autoParams != null) {
                int n = this.autoParams.size();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    @Override
    public Parameter[] getParameters() {
        return this.getParameters(null);
    }

    protected <T extends Variable, U extends T> void collect(Collection<T> into, Collection<U> from, VariableFilter filter) {
        if (from == null) {
            return;
        }
        if (filter == null) {
            into.addAll(from);
        } else {
            into.addAll(Collections2.filter(from, arg_0 -> ((VariableFilter)filter).matches(arg_0)));
        }
    }

    @Override
    public Parameter[] getParameters(VariableFilter filter) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                Parameter[] parameterArray = this.thunked.getParameters(filter);
                return parameterArray;
            }
            this.doLoadVariables();
            ArrayList result = new ArrayList();
            this.collect(result, this.autoParams, filter);
            this.collect(result, this.params, filter);
            Parameter[] parameterArray = result.toArray(new Parameter[result.size()]);
            return parameterArray;
        }
    }

    @Override
    public TraceLocalVariableSymbol[] getLocalVariables() {
        return this.getLocalVariables(null);
    }

    @Override
    public TraceLocalVariableSymbol[] getLocalVariables(VariableFilter filter) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                TraceLocalVariableSymbol[] traceLocalVariableSymbolArray = this.thunked.getLocalVariables(filter);
                return traceLocalVariableSymbolArray;
            }
            this.doLoadVariables();
            ArrayList result = new ArrayList();
            this.collect(result, this.locals, filter);
            TraceLocalVariableSymbol[] traceLocalVariableSymbolArray = result.toArray(new TraceLocalVariableSymbol[result.size()]);
            return traceLocalVariableSymbolArray;
        }
    }

    @Override
    public Variable[] getVariables(VariableFilter filter) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                Parameter[] parameterArray = this.thunked.getParameters();
                return parameterArray;
            }
            this.doLoadVariables();
            ArrayList result = new ArrayList();
            this.collect(result, this.autoParams, filter);
            this.collect(result, this.params, filter);
            this.collect(result, this.locals, filter);
            Variable[] variableArray = result.toArray(new Variable[result.size()]);
            return variableArray;
        }
    }

    @Override
    public Variable[] getAllVariables() {
        return this.getVariables(null);
    }

    public void setBody(AddressSetView newBody) throws OverlappingFunctionException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceFunctionSymbolView.assertProperSpace(this.entryPoint.getAddressSpace(), newBody);
            if (!newBody.contains(this.entryPoint)) {
                throw new IllegalArgumentException("Function body must contain the entry point");
            }
            AddressSetView oldBody = this.getBody();
            if (oldBody.equals(newBody)) {
                return;
            }
            this.manager.functions.assertNotOverlapping(this, this.getEntryPoint(), this.getLifespan(), newBody);
            for (DBTraceLabelSymbol label : this.manager.labels.getChildren(this)) {
                if (newBody.contains(label.getAddress())) continue;
                label.delete();
            }
            long id = this.getID();
            this.manager.delID(null, this.entryPoint.getAddressSpace(), id);
            for (AddressRange rng : newBody) {
                this.manager.putID(this.lifespan, null, rng, id);
            }
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, AddressSetView>(Trace.TraceFunctionChangeType.CHANGED_BODY, this.getSpace(), this, oldBody, newBody));
        }
    }

    protected byte getFlags() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (this.thunked != null) {
                byte by = this.thunked.getFlags();
                return by;
            }
            byte by = this.flags;
            return by;
        }
    }

    protected void orFlags(byte with) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.orFlags(with);
                return;
            }
            this.flags = (byte)(this.flags | with);
            this.update(FLAGS_COLUMN);
        }
    }

    protected void andFlags(byte with) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.orFlags(with);
                return;
            }
            this.flags = (byte)(this.flags & with);
            this.update(FLAGS_COLUMN);
        }
    }

    public boolean hasVarArgs() {
        return (this.getFlags() & 0x20) != 0;
    }

    public void setVarArgs(boolean hasVarArgs) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.hasVarArgs() == hasVarArgs) {
                return;
            }
            if (hasVarArgs) {
                this.orFlags((byte)32);
            } else {
                this.andFlags((byte)-33);
            }
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED_PARAMETERS, this.getSpace(), this));
        }
    }

    public boolean isInline() {
        return (this.getFlags() & 0x10) != 0;
    }

    public void setInline(boolean isInline) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.isInline() == isInline) {
                return;
            }
            if (isInline) {
                this.orFlags((byte)16);
            } else {
                this.andFlags((byte)-17);
            }
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, Boolean>(Trace.TraceFunctionChangeType.CHANGED_INLINE, this.getSpace(), this, !isInline, isInline));
        }
    }

    public boolean hasNoReturn() {
        return (this.getFlags() & 0x40) != 0;
    }

    public void setNoReturn(boolean hasNoReturn) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.hasNoReturn() == hasNoReturn) {
                return;
            }
            if (hasNoReturn) {
                this.orFlags((byte)64);
            } else {
                this.andFlags((byte)-65);
            }
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, Boolean>(Trace.TraceFunctionChangeType.CHANGED_NORETURN, this.getSpace(), this, !hasNoReturn, hasNoReturn));
        }
    }

    public boolean hasCustomVariableStorage() {
        return (this.getFlags() & 0xFFFFFF80) != 0;
    }

    public void setCustomVariableStorage(boolean hasCustomVariableStorage) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (hasCustomVariableStorage == this.hasCustomVariableStorage()) {
                return;
            }
            this.doLoadVariables();
            if (!hasCustomVariableStorage) {
                this.doRemoveExplicitThisParameter();
                if (this.doRemoveExplicitReturnStorageParameter()) {
                    DBTraceFunctionSymbol.revertIndirectParameter(this.ret, false);
                }
            }
            Parameter[] parameters = this.getParameters();
            HashMap<Parameter, VariableStorage> oldStorages = new HashMap<Parameter, VariableStorage>(this.params.size());
            HashMap<Parameter, DataType> oldFormalTypes = new HashMap<Parameter, DataType>(this.params.size());
            for (Parameter parameter : parameters) {
                if (parameter.isAutoParameter()) continue;
                oldStorages.put(parameter, parameter.getVariableStorage());
                if (!hasCustomVariableStorage) {
                    oldFormalTypes.put(parameter, DBTraceFunctionSymbol.revertTypeIfIndirect(parameter.getFormalDataType(), parameter.getVariableStorage()));
                    continue;
                }
                oldFormalTypes.put(parameter, parameter.getFormalDataType());
            }
            VariableStorage oldRetStorage = this.ret.getVariableStorage();
            DataType oldRetType = this.ret.getFormalDataType();
            this.autoParams = null;
            if (hasCustomVariableStorage) {
                this.orFlags((byte)-128);
            } else {
                this.andFlags((byte)127);
            }
            int ordinal = 0;
            for (Parameter p : parameters) {
                if (p.isAutoParameter()) {
                    try {
                        this.insertParameter(ordinal, (Variable)new ParameterImpl(p, (Program)this.getProgram()), SourceType.ANALYSIS);
                        ++ordinal;
                    }
                    catch (DuplicateNameException e) {
                        Msg.info((Object)this, (Object)"Clobbered auto-parameter during transition to custom storage");
                    }
                    continue;
                }
                DBTraceParameterSymbol dbP = (DBTraceParameterSymbol)p;
                VariableStorage oldStorage = (VariableStorage)oldStorages.get(p);
                VariableStorage newStorage = hasCustomVariableStorage ? oldStorage.clone((Program)this.getProgram()) : VariableStorage.UNASSIGNED_STORAGE;
                DataType newType = this.manager.checkIndirection(oldStorage, (DataType)oldFormalTypes.get(p));
                dbP.doSetStorageAndDataType(newStorage, newType);
            }
            VariableStorage variableStorage = hasCustomVariableStorage ? oldRetStorage.clone((Program)this.getProgram()) : VariableStorage.UNASSIGNED_STORAGE;
            DataType newRetType = this.manager.checkIndirection(oldRetStorage, oldRetType);
            this.ret.doSetStorageAndDataType(variableStorage, newRetType);
            if (!hasCustomVariableStorage) {
                this.doUpdateParametersAndReturn();
            }
            this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED_PARAMETERS, this.getSpace(), this));
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.frame.invalidate();
        }
    }

    public PrototypeModel getCallingConvention() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            CompilerSpec cs = this.manager.trace.getBaseCompilerSpec();
            if (cs == null) {
                PrototypeModel prototypeModel = null;
                return prototypeModel;
            }
            if (-2 == this.callingConventionID) {
                PrototypeModel prototypeModel = null;
                return prototypeModel;
            }
            if (-1 == this.callingConventionID) {
                PrototypeModel prototypeModel = cs.getDefaultCallingConvention();
                return prototypeModel;
            }
            String ccName = (String)this.manager.callingConventionMap.inverse().get((Object)this.callingConventionID);
            if (ccName == null) {
                PrototypeModel prototypeModel = null;
                return prototypeModel;
            }
            PrototypeModel prototypeModel = cs.getCallingConvention(ccName);
            return prototypeModel;
        }
    }

    public String getCallingConventionName() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (-2 == this.callingConventionID) {
                String string = null;
                return string;
            }
            if (-1 == this.callingConventionID) {
                String string = "default";
                return string;
            }
            String string = (String)this.manager.callingConventionMap.inverse().get((Object)this.callingConventionID);
            return string;
        }
    }

    public String getDefaultCallingConventionName() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            PrototypeModel cc = this.manager.functions.getDefaultCallingConvention();
            if (cc == null) {
                String string = "default";
                return string;
            }
            String ccName = cc.getName();
            if (ccName == null) {
                String string = "default";
                return string;
            }
            String string = ccName;
            return string;
        }
    }

    public void setCallingConvention(String name) throws InvalidInputException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.thunked != null) {
                this.thunked.setCallingConvention(name);
                return;
            }
            if (Objects.equals(this.getCallingConventionName(), name)) {
                return;
            }
            this.doLoadVariables();
            this.callingConventionID = this.manager.findOrRecordCallingConvention(name);
            this.update(CALLING_CONVENTION_COLUMN);
            boolean hasCustomStorage = this.hasCustomVariableStorage();
            if (!hasCustomStorage) {
                this.doRemoveExplicitThisParameter();
            }
            this.frame.invalidate();
            if (!hasCustomStorage) {
                this.createClassStructIfNeeded();
                this.doLoadVariables();
                this.doRemoveExplicitThisParameter();
                this.doUpdateParametersAndReturn();
                this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED_PARAMETERS, this.getSpace(), this));
                this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED_RETURN, this.getSpace(), this));
            } else {
                this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED, this.getSpace(), this));
            }
        }
    }

    protected void createClassStructIfNeeded() {
        PrototypeModel cc = this.getCallingConvention();
        if (cc == null || cc.getGenericCallingConvention() != GenericCallingConvention.thiscall) {
            return;
        }
        DBTraceNamespaceSymbol parentNS = this.getParentNamespace();
        if (!(parentNS instanceof GhidraClass)) {
            return;
        }
        DBTraceDataTypeManager dtm = this.manager.dataTypeManager;
        Structure classStruct = VariableUtilities.findExistingClassStruct((GhidraClass)((GhidraClass)parentNS), (DataTypeManager)dtm);
        if (classStruct == null) {
            classStruct = VariableUtilities.findOrCreateClassStruct((GhidraClass)((GhidraClass)parentNS), (DataTypeManager)dtm);
            dtm.resolve((DataType)classStruct, null);
        }
    }

    public boolean isThunk() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = this.thunked != null;
            return bl;
        }
    }

    @Override
    public DBTraceFunctionSymbol getThunkedFunction(boolean recursive) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            if (recursive) {
                if (this.thunked != null) {
                    DBTraceFunctionSymbol dBTraceFunctionSymbol = this.thunked.getThunkedFunction(recursive);
                    return dBTraceFunctionSymbol;
                }
                DBTraceFunctionSymbol dBTraceFunctionSymbol = this;
                return dBTraceFunctionSymbol;
            }
            DBTraceFunctionSymbol dBTraceFunctionSymbol = this.thunked;
            return dBTraceFunctionSymbol;
        }
    }

    private List<Address> getFunctionThunkAddresses(long functionKey, boolean recursive) {
        Collection thunkSymbols = this.manager.functionsByThunked.get((Object)this.getKey());
        if (thunkSymbols == null || thunkSymbols.isEmpty()) {
            return null;
        }
        ArrayList<Address> result = new ArrayList<Address>();
        for (DBTraceFunctionSymbol thunkSymbol : thunkSymbols) {
            List<Address> thunkAddrs;
            result.add(thunkSymbol.entryPoint);
            if (!recursive || (thunkAddrs = this.getFunctionThunkAddresses(thunkSymbol.getKey(), true)) == null) continue;
            result.addAll(thunkAddrs);
        }
        return result;
    }

    public Address[] getFunctionThunkAddresses(boolean recursive) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            List<Address> result = this.getFunctionThunkAddresses(this.getKey(), recursive);
            if (result == null) {
                Address[] addressArray = null;
                return addressArray;
            }
            Address[] addressArray = result.toArray(new Address[result.size()]);
            return addressArray;
        }
    }

    public void setThunkedFunction(Function thunkedFunction) throws IllegalArgumentException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            DBTraceFunctionSymbol dbFunc = this.manager.assertIsMine(thunkedFunction);
            if (this.getThunkedFunction(true) == dbFunc) {
                throw new IllegalArgumentException("Cannot create circle of thunks");
            }
            if (this.thunkedKey == dbFunc.getKey()) {
                return;
            }
            DBTraceFunctionSymbol oldThunk = this.thunked;
            this.thunkedKey = dbFunc.getKey();
            this.update(THUNKED_COLUMN);
            this.thunked = dbFunc;
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceFunctionSymbol, DBTraceFunctionSymbol>(Trace.TraceFunctionChangeType.CHANGED_THUNK, this.getSpace(), this, oldThunk, dbFunc));
        }
    }

    public ExternalLocation getExternalLocation() {
        return null;
    }

    public Set<Function> getCallingFunctions(TaskMonitor monitor) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            HashSet result = new HashSet();
            for (DBTraceReference dBTraceReference : this.manager.trace.getReferenceManager().getReferencesToRange(this.lifespan, (AddressRange)new AddressRangeImpl(this.entryPoint, this.entryPoint))) {
                if (monitor.isCancelled()) break;
                Address fromAddr = dBTraceReference.getFromAddress();
                Range span = this.lifespan.intersection(dBTraceReference.getLifespan());
                result.addAll(this.manager.functions.getIntersecting((Range<Long>)span, this.getThread(), (AddressRange)new AddressRangeImpl(fromAddr, fromAddr), true, true));
            }
            HashSet hashSet = result;
            return hashSet;
        }
    }

    public Set<Function> getCalledFunctions(TaskMonitor monitor) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            HashSet<Function> result = new HashSet<Function>();
            for (AddressRange rng : this.getBody()) {
                for (DBTraceReference dBTraceReference : this.manager.trace.getReferenceManager().getReferencesFromRange(this.lifespan, rng)) {
                    if (monitor.isCancelled()) {
                        HashSet<Function> hashSet = result;
                        return hashSet;
                    }
                    Address toAddr = dBTraceReference.getToAddress();
                    Range span = this.lifespan.intersection(dBTraceReference.getLifespan());
                    for (DBTraceFunctionSymbol function : this.manager.functions.getIntersecting((Range<Long>)span, this.getThread(), (AddressRange)new AddressRangeImpl(toAddr, toAddr), true, true)) {
                        if (!toAddr.equals((Object)function.getEntryPoint())) continue;
                        result.add(function);
                    }
                }
            }
            HashSet<Function> hashSet = result;
            return hashSet;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void promoteLocalUserLabelsToGlobal() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            ArrayList toPromote = new ArrayList(Collections2.filter(this.manager.labels().getChildren(this), l -> l.getSource() == SourceType.USER_DEFINED));
            for (DBTraceLabelSymbol label : toPromote) {
                try {
                    label.setNamespace(this.manager.getGlobalNamespace());
                }
                catch (DuplicateNameException e) {
                    label.delete();
                }
                catch (CircularDependencyException | InvalidInputException e) {
                    throw new AssertionError((Object)e);
                    return;
                }
            }
        }
    }

    @Override
    public boolean delete() {
        boolean result = super.delete();
        SourceType source = this.getSource();
        if (result && source != SourceType.DEFAULT) {
            try {
                this.manager.labels.add((Range)this.lifespan, (TraceThread)null, this.entryPoint, this.name, (TraceNamespaceSymbol)this.parent, source);
            }
            catch (InvalidInputException | IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }
        return result;
    }

    protected void setReturnAddressOffset(int offset) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.stackReturnOffset = offset;
            this.update(STACK_RETURN_OFFSET_COLUMN);
        }
        this.manager.trace.setChanged(new TraceChangeRecord(Trace.TraceFunctionChangeType.CHANGED, this.getSpace(), this));
    }

    protected int getReturnAddressOffset() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            int n = this.stackReturnOffset;
            return n;
        }
    }
}

