/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import com.google.common.collect.Range;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;

public class DBTraceObjectSection
implements TraceObjectSection,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final SectionTranslator translator;
    private AddressRange range;

    public DBTraceObjectSection(DBTraceObject object) {
        this.object = object;
        this.translator = new SectionTranslator(object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public TraceObjectModule getModule() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceObjectModule traceObjectModule = this.object.queryCanonicalAncestorsInterface(TraceObjectModule.class).findAny().orElseThrow();
            return traceObjectModule;
        }
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Range<Long> lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(this.computeSpan(), name);
        }
    }

    @Override
    public String getName() {
        return TraceObjectInterfaceUtils.getValue(this.object, this.computeMinSnap(), "_display", String.class, "");
    }

    @Override
    public void setRange(Range<Long> lifespan, AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", range);
            this.range = range;
        }
    }

    @Override
    public AddressRange getRange() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            if (this.object.getLife().isEmpty()) {
                AddressRange addressRange = this.range;
                return addressRange;
            }
            AddressRange addressRange = this.range = TraceObjectInterfaceUtils.getValue(this.object, this.computeMinSnap(), "_range", AddressRange.class, this.range);
            return addressRange;
        }
    }

    @Override
    public Range<Long> computeSpan() {
        Range<Long> span = DBTraceObjectInterface.super.computeSpan();
        if (span != null) {
            return span;
        }
        return this.getModule().computeSpan();
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class SectionTranslator
    extends DBTraceObjectInterface.Translator<TraceSection> {
        protected SectionTranslator(DBTraceObject object, TraceSection iface) {
            super("_range", object, iface);
        }

        @Override
        protected TraceChangeType<TraceSection, Void> getAddedType() {
            return Trace.TraceSectionChangeType.ADDED;
        }

        @Override
        protected TraceChangeType<TraceSection, Range<Long>> getLifespanChangedType() {
            return null;
        }

        @Override
        protected TraceChangeType<TraceSection, Void> getChangedType() {
            return Trace.TraceSectionChangeType.CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return "_range".equals(key) || "_display".equals(key);
        }

        @Override
        protected TraceChangeType<TraceSection, Void> getDeletedType() {
            return Trace.TraceSectionChangeType.DELETED;
        }
    }
}

