/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import com.google.common.collect.Range;
import ghidra.dbg.target.TargetSection;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DBTraceObjectModule
implements TraceObjectModule,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final ModuleChangeTranslator translator;
    private AddressRange range;
    private Range<Long> lifespan;

    public DBTraceObjectModule(DBTraceObject object) {
        this.object = object;
        this.translator = new ModuleChangeTranslator(object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public TraceSection addSection(String sectionPath, String sectionName, AddressRange range) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            DBTraceObjectManager manager = this.object.getManager();
            List sectionKeyList = PathUtils.parse((String)sectionPath);
            if (!PathUtils.isAncestor(this.object.getCanonicalPath().getKeyList(), (List)sectionKeyList)) {
                throw new IllegalArgumentException("Section path must be a successor of this module's path");
            }
            TraceObjectSection traceObjectSection = manager.addSection(sectionPath, sectionName, this.getLifespan(), range);
            return traceObjectSection;
        }
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Range<Long> lifespan, String name) {
        this.object.setValue(lifespan, "_module_name", name);
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(this.computeSpan(), name);
        }
    }

    @Override
    public String getName() {
        return TraceObjectInterfaceUtils.getValue(this.object, this.getLoadedSnap(), "_module_name", String.class, "");
    }

    @Override
    public void setRange(Range<Long> lifespan, AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", range);
            this.range = range;
        }
    }

    @Override
    public void setRange(AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(this.computeSpan(), range);
        }
    }

    @Override
    public AddressRange getRange() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            if (this.object.getLife().isEmpty()) {
                AddressRange addressRange = this.range;
                return addressRange;
            }
            AddressRange addressRange = this.range = TraceObjectInterfaceUtils.getValue(this.object, this.getLoadedSnap(), "_range", AddressRange.class, this.range);
            return addressRange;
        }
    }

    @Override
    public void setBase(Address base) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(DBTraceUtils.toRange(base, this.getMaxAddress()));
        }
    }

    @Override
    public Address getBase() {
        AddressRange range = this.getRange();
        return range == null ? null : range.getMinAddress();
    }

    @Override
    public void setMaxAddress(Address max) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(DBTraceUtils.toRange(this.getBase(), max));
        }
    }

    @Override
    public Address getMaxAddress() {
        AddressRange range = this.getRange();
        return range == null ? null : range.getMaxAddress();
    }

    @Override
    public void setLength(long length) throws AddressOverflowException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange((AddressRange)new AddressRangeImpl(this.getBase(), length));
        }
    }

    @Override
    public long getLength() {
        return this.getRange().getLength();
    }

    @Override
    public void setLifespan(Range<Long> lifespan) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            TraceObjectInterfaceUtils.setLifespan(TraceObjectModule.class, this.object, lifespan);
            this.lifespan = lifespan;
            for (TraceObjectSection traceObjectSection : this.getSections()) {
                TraceObjectInterfaceUtils.setLifespan(TraceObjectSection.class, traceObjectSection.getObject(), lifespan);
            }
        }
    }

    @Override
    public Range<Long> getLifespan() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Range<Long> computed = this.computeSpan();
            if (computed != null) {
                this.lifespan = computed;
            }
            Range<Long> range = this.lifespan;
            return range;
        }
    }

    @Override
    public void setLoadedSnap(long loadedSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(DBTraceUtils.toRange(loadedSnap, this.getUnloadedSnap()));
        }
    }

    @Override
    public long getLoadedSnap() {
        return this.computeMinSnap();
    }

    @Override
    public void setUnloadedSnap(long unloadedSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(DBTraceUtils.toRange(this.getLoadedSnap(), unloadedSnap));
        }
    }

    @Override
    public long getUnloadedSnap() {
        return this.computeMaxSnap();
    }

    @Override
    public Collection<? extends TraceObjectSection> getSections() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Collection collection = this.object.querySuccessorsInterface(this.getLifespan(), TraceObjectSection.class).collect(Collectors.toSet());
            return collection;
        }
    }

    @Override
    public TraceObjectSection getSectionByName(String sectionName) {
        PathMatcher matcher = this.object.getTargetSchema().searchFor(TargetSection.class, true);
        PathMatcher applied = matcher.applyKeys(PathPredicates.Align.LEFT, List.of(sectionName));
        return this.object.getSuccessors(this.getLifespan(), (PathPredicates)applied).map(p -> p.getDestination(this.object).queryInterface(TraceObjectSection.class)).findAny().orElse(null);
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class ModuleChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceModule> {
        protected ModuleChangeTranslator(DBTraceObject object, TraceModule iface) {
            super("_range", object, iface);
        }

        @Override
        protected TraceChangeType<TraceModule, Void> getAddedType() {
            return Trace.TraceModuleChangeType.ADDED;
        }

        @Override
        protected TraceChangeType<TraceModule, Range<Long>> getLifespanChangedType() {
            return Trace.TraceModuleChangeType.LIFESPAN_CHANGED;
        }

        @Override
        protected TraceChangeType<TraceModule, Void> getChangedType() {
            return Trace.TraceModuleChangeType.CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return "_range".equals(key) || "_display".equals(key);
        }

        @Override
        protected TraceChangeType<TraceModule, Void> getDeletedType() {
            return Trace.TraceModuleChangeType.DELETED;
        }
    }
}

