/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.breakpoint.DBTraceBreakpointSpace;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceBreakpoint
extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<DBTraceBreakpoint>
implements TraceBreakpoint {
    protected static final String TABLE_NAME = "Breakpoints";
    private static final byte ENABLED_MASK = -128;
    static final String PATH_COLUMN_NAME = "Path";
    static final String NAME_COLUMN_NAME = "Name";
    static final String THREADS_COLUMN_NAME = "Threads";
    static final String FLAGS_COLUMN_NAME = "Flags";
    static final String COMMENT_COLUMN_NAME = "Comment";
    @DBAnnotatedColumn(value="Path")
    static DBObjectColumn PATH_COLUMN;
    @DBAnnotatedColumn(value="Name")
    static DBObjectColumn NAME_COLUMN;
    @DBAnnotatedColumn(value="Threads")
    static DBObjectColumn THREADS_COLUMN;
    @DBAnnotatedColumn(value="Flags")
    static DBObjectColumn FLAGS_COLUMN;
    @DBAnnotatedColumn(value="Comment")
    static DBObjectColumn COMMENT_COLUMN;
    @DBAnnotatedField(column="Path", indexed=true)
    private String path;
    @DBAnnotatedField(column="Name")
    private String name;
    @DBAnnotatedField(column="Threads")
    private long[] threadKeys;
    @DBAnnotatedField(column="Flags")
    private byte flagsByte;
    @DBAnnotatedField(column="Comment")
    private String comment;
    private final Set<TraceBreakpointKind> kinds = EnumSet.noneOf(TraceBreakpointKind.class);
    private final Set<TraceBreakpointKind> kindsView = Collections.unmodifiableSet(this.kinds);
    private boolean enabled;
    protected final DBTraceBreakpointSpace space;

    protected static String tableName(AddressSpace space, long threadKey) {
        return DBTraceUtils.tableName(TABLE_NAME, space, threadKey, 0);
    }

    public DBTraceBreakpoint(DBTraceBreakpointSpace space, DBTraceAddressSnapRangePropertyMapTree<DBTraceBreakpoint, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
        super(tree, store, record);
        this.space = space;
    }

    @Override
    protected void fresh(boolean created) throws IOException {
        super.fresh(created);
        if (created) {
            return;
        }
        this.doFresh();
    }

    private void doFresh() {
        this.kinds.clear();
        for (TraceBreakpointKind k : TraceBreakpointKind.values()) {
            if ((this.flagsByte & k.getBits()) == 0) continue;
            this.kinds.add(k);
        }
        this.enabled = (this.flagsByte & 0xFFFFFF80) != 0;
    }

    @Override
    public DBTrace getTrace() {
        return this.space.trace;
    }

    protected void setRecordValue(DBTraceBreakpoint value) {
    }

    protected DBTraceBreakpoint getRecordValue() {
        return this;
    }

    public void set(String path, String name, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) {
        this.path = path;
        this.name = name;
        if (!(threads instanceof Set)) {
            threads = Set.copyOf(threads);
        }
        this.threadKeys = new long[threads.size()];
        int i = 0;
        for (TraceThread t : threads) {
            this.threadKeys[i++] = t.getKey();
        }
        this.flagsByte = 0;
        this.kinds.clear();
        for (TraceBreakpointKind k : kinds) {
            this.flagsByte = (byte)(this.flagsByte | k.getBits());
            this.kinds.add(k);
        }
        if (enabled) {
            this.flagsByte = (byte)(this.flagsByte | 0xFFFFFF80);
        }
        this.comment = comment;
        this.update(new DBObjectColumn[]{PATH_COLUMN, NAME_COLUMN, THREADS_COLUMN, FLAGS_COLUMN, COMMENT_COLUMN});
        this.enabled = enabled;
    }

    public void set(String path, String name, long[] threadKeys, byte flagsByte, String comment) {
        this.path = path;
        this.name = name;
        this.threadKeys = Arrays.copyOf(threadKeys, threadKeys.length);
        this.flagsByte = flagsByte;
        this.comment = comment;
        this.update(new DBObjectColumn[]{PATH_COLUMN, NAME_COLUMN, THREADS_COLUMN, FLAGS_COLUMN, COMMENT_COLUMN});
        this.doFresh();
    }

    @Override
    public String getPath() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            String string = this.path;
            return string;
        }
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.name = name;
            this.update(NAME_COLUMN);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceBreakpointChangeType.CHANGED, this.space, this));
    }

    @Override
    public String getName() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            String string = this.name;
            return string;
        }
    }

    @Override
    public Set<TraceThread> getThreads() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            if (this.threadKeys.length == 0) {
                Set<TraceThread> set = Set.of();
                return set;
            }
            LinkedHashSet<TraceThread> threads = new LinkedHashSet<TraceThread>(this.threadKeys.length);
            DBTraceThreadManager threadManager = this.space.trace.getThreadManager();
            for (int i = 0; i < this.threadKeys.length; ++i) {
                TraceThread t = threadManager.getThread(this.threadKeys[i]);
                if (t == null) {
                    Msg.warn((Object)this, (Object)("Thread " + this.threadKeys[i] + " has been deleted since creating this breakpoint."));
                }
                threads.add(t);
            }
            Set<TraceThread> set = Collections.unmodifiableSet(threads);
            return set;
        }
    }

    @Override
    public AddressRange getRange() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            AddressRange addressRange = this.range;
            return addressRange;
        }
    }

    @Override
    public Address getMinAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address address = this.range.getMinAddress();
            return address;
        }
    }

    @Override
    public Address getMaxAddress() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Address address = this.range.getMaxAddress();
            return address;
        }
    }

    @Override
    public long getLength() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            long l = this.range.getLength();
            return l;
        }
    }

    protected void setLifespan(Range<Long> newLifespan) throws DuplicateNameException {
        Range oldLifespan;
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.space.manager.checkDuplicatePath(this, this.path, newLifespan);
            oldLifespan = this.lifespan;
            this.doSetLifespan(newLifespan);
        }
        this.space.trace.setChanged(new TraceChangeRecord<DBTraceBreakpoint, Range<Long>>(Trace.TraceBreakpointChangeType.LIFESPAN_CHANGED, this.space, this, oldLifespan, newLifespan));
    }

    @Override
    public Range<Long> getLifespan() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Range range = this.lifespan;
            return range;
        }
    }

    @Override
    public long getPlacedSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            long l = DBTraceUtils.lowerEndpoint((Range<Long>)this.lifespan);
            return l;
        }
    }

    @Override
    public void setClearedSnap(long clearedSnap) throws DuplicateNameException {
        this.setLifespan(DBTraceUtils.toRange(this.getPlacedSnap(), clearedSnap));
    }

    @Override
    public long getClearedSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            long l = DBTraceUtils.upperEndpoint((Range<Long>)this.lifespan);
            return l;
        }
    }

    protected DBTraceBreakpoint doCopy() {
        DBTraceBreakpoint breakpoint = this.space.breakpointMapSpace.put(this, null);
        breakpoint.set(this.path, this.name, this.threadKeys, this.flagsByte, this.comment);
        return breakpoint;
    }

    @Override
    public DBTraceBreakpoint splitAndSet(long snap, boolean en, Collection<TraceBreakpointKind> kinds) {
        DBTraceBreakpoint that;
        Range oldLifespan = null;
        Range<Long> newLifespan = null;
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            if (!this.lifespan.contains((Comparable)Long.valueOf(snap))) {
                throw new IllegalArgumentException("snap = " + snap);
            }
            if (this.flagsByte == DBTraceBreakpoint.computeFlagsByte(en, kinds)) {
                DBTraceBreakpoint dBTraceBreakpoint = this;
                return dBTraceBreakpoint;
            }
            if (snap == this.getPlacedSnap()) {
                this.doSetFlags(en, kinds);
                that = this;
            } else {
                that = this.doCopy();
                that.doSetLifespan(DBTraceUtils.toRange(snap, this.getClearedSnap()));
                that.doSetFlags(en, kinds);
                oldLifespan = this.lifespan;
                newLifespan = DBTraceUtils.toRange(this.getPlacedSnap(), snap - 1L);
                this.doSetLifespan(newLifespan);
            }
        }
        if (that == this) {
            this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceBreakpointChangeType.CHANGED, this.space, this));
        } else {
            this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceBreakpointChangeType.ADDED, this.space, that));
            this.space.trace.setChanged(new TraceChangeRecord<DBTraceBreakpoint, Range<Long>>(Trace.TraceBreakpointChangeType.LIFESPAN_CHANGED, this.space, this, Objects.requireNonNull(oldLifespan), Objects.requireNonNull(newLifespan)));
        }
        return that;
    }

    protected static byte computeFlagsByte(boolean enabled, Collection<TraceBreakpointKind> kinds) {
        byte flags = 0;
        for (TraceBreakpointKind k : kinds) {
            flags = (byte)(flags | k.getBits());
        }
        if (enabled) {
            flags = (byte)(flags | 0xFFFFFF80);
        }
        return flags;
    }

    protected void doSetFlags(boolean enabled, Collection<TraceBreakpointKind> kinds) {
        this.flagsByte = DBTraceBreakpoint.computeFlagsByte(enabled, kinds);
        this.kinds.clear();
        this.kinds.addAll(kinds);
        this.enabled = enabled;
        this.update(FLAGS_COLUMN);
    }

    protected void doSetEnabled(boolean enabled) {
        this.enabled = enabled;
        this.flagsByte = enabled ? (byte)(this.flagsByte | 0xFFFFFF80) : (byte)(this.flagsByte & 0x7F);
        this.update(FLAGS_COLUMN);
    }

    protected void doSetKinds(Collection<TraceBreakpointKind> kinds) {
        for (TraceBreakpointKind k : TraceBreakpointKind.values()) {
            if (kinds.contains((Object)k)) {
                this.flagsByte = (byte)(this.flagsByte | k.getBits());
                this.kinds.add(k);
                continue;
            }
            this.flagsByte = (byte)(this.flagsByte & ~k.getBits());
            this.kinds.remove((Object)k);
        }
        this.update(FLAGS_COLUMN);
    }

    @Override
    public void setEnabled(boolean enabled) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.doSetEnabled(enabled);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceBreakpointChangeType.CHANGED, this.space, this));
    }

    @Override
    public boolean isEnabled(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            boolean bl = this.enabled;
            return bl;
        }
    }

    @Override
    public void setKinds(Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.doSetKinds(kinds);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceBreakpointChangeType.CHANGED, this.space, this));
    }

    @Override
    public Set<TraceBreakpointKind> getKinds() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            Set<TraceBreakpointKind> set = this.kindsView;
            return set;
        }
    }

    @Override
    public void setComment(String comment) {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            this.comment = comment;
            this.update(COMMENT_COLUMN);
        }
        this.space.trace.setChanged(new TraceChangeRecord(Trace.TraceBreakpointChangeType.CHANGED, this.space, this));
    }

    @Override
    public String getComment() {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.readLock());){
            String string = this.comment;
            return string;
        }
    }

    @Override
    public void delete() {
        this.space.deleteBreakpoint(this);
    }
}

