/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace.data;

import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.trace.data.PcodeTraceMemoryAccess;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.pcode.exec.trace.data.PcodeTraceRegistersAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.memory.TraceMemoryState;
import java.nio.ByteBuffer;

public class DefaultPcodeTraceThreadAccess
implements PcodeTraceMemoryAccess,
PcodeTraceRegistersAccess {
    protected final PcodeTraceMemoryAccess memory;
    protected final PcodeTraceRegistersAccess registers;

    protected DefaultPcodeTraceThreadAccess(PcodeTraceMemoryAccess memory, PcodeTraceRegistersAccess registers) {
        this.memory = memory;
        this.registers = registers;
    }

    @Override
    public Language getLanguage() {
        return this.memory.getLanguage();
    }

    @Override
    public void setState(AddressRange range, TraceMemoryState state) {
        if (range.getAddressSpace().isRegisterSpace()) {
            this.registers.setState(range, state);
            return;
        }
        this.memory.setState(range, state);
    }

    @Override
    public TraceMemoryState getViewportState(AddressRange range) {
        if (range.getAddressSpace().isRegisterSpace()) {
            return this.registers.getViewportState(range);
        }
        return this.memory.getViewportState(range);
    }

    @Override
    public AddressSetView getKnownNow() {
        return this.memory.getKnownNow().union(this.registers.getKnownNow());
    }

    @Override
    public AddressSetView getKnownBefore() {
        return this.memory.getKnownBefore().union(this.registers.getKnownBefore());
    }

    @Override
    public AddressSetView intersectUnknown(AddressSetView view) {
        return this.memory.intersectUnknown(view).union(this.registers.intersectUnknown(view));
    }

    @Override
    public int putBytes(Address start, ByteBuffer buf) {
        if (start.isRegisterAddress()) {
            return this.registers.putBytes(start, buf);
        }
        return this.memory.putBytes(start, buf);
    }

    @Override
    public int getBytes(Address start, ByteBuffer buf) {
        if (start.isRegisterAddress()) {
            return this.registers.getBytes(start, buf);
        }
        return this.memory.getBytes(start, buf);
    }

    @Override
    public Address translate(Address address) {
        if (address.isRegisterAddress()) {
            return this.registers.translate(address);
        }
        return this.memory.translate(address);
    }

    @Override
    public <T> PcodeTracePropertyAccess<T> getPropertyAccess(String name, Class<T> type) {
        throw new UnsupportedOperationException("This is meant for p-code executor use");
    }

    @Override
    public void initializeThreadContext(PcodeThread<?> thread) {
        this.registers.initializeThreadContext(thread);
    }
}

