/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.primitives.UnsignedLong;
import ghidra.pcode.exec.AbstractBytesPcodeExecutorStatePiece;
import ghidra.pcode.exec.AbstractLongOffsetPcodeExecutorStatePiece;
import ghidra.pcode.exec.BytesPcodeExecutorStateSpace;
import ghidra.pcode.exec.trace.TracePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.PcodeTraceDataAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.util.MathUtilities;
import java.nio.ByteBuffer;

public class BytesTracePcodeExecutorStatePiece
extends AbstractBytesPcodeExecutorStatePiece<CachedSpace>
implements TracePcodeExecutorStatePiece<byte[], byte[]> {
    protected final PcodeTraceDataAccess data;

    public BytesTracePcodeExecutorStatePiece(PcodeTraceDataAccess data) {
        super(data.getLanguage());
        this.data = data;
    }

    @Override
    public PcodeTraceDataAccess getData() {
        return this.data;
    }

    @Override
    public void writeDown(PcodeTraceDataAccess into) {
        if (into.getLanguage() != this.language) {
            throw new IllegalArgumentException("Destination platform must be same language as source");
        }
        for (CachedSpace cached : this.spaceMap.values()) {
            cached.writeDown(into);
        }
    }

    protected AbstractLongOffsetPcodeExecutorStatePiece.AbstractSpaceMap<CachedSpace> newSpaceMap() {
        return new TraceBackedSpaceMap();
    }

    protected static class CachedSpace
    extends BytesPcodeExecutorStateSpace<PcodeTraceDataAccess> {
        protected final AddressSet written = new AddressSet();

        public CachedSpace(Language language, AddressSpace space, PcodeTraceDataAccess backing) {
            super(language, space, (Object)backing);
        }

        public void write(long offset, byte[] val, int srcOffset, int length) {
            super.write(offset, val, srcOffset, length);
            Address loc = this.space.getAddress(offset);
            Address end = loc.addWrap((long)(length - 1));
            if (loc.compareTo((Object)end) <= 0) {
                this.written.add(loc, end);
            } else {
                this.written.add(loc, this.space.getMaxAddress());
                this.written.add(this.space.getMinAddress(), end);
            }
        }

        protected void readUninitializedFromBacking(RangeSet<UnsignedLong> uninitialized) {
            if (!uninitialized.isEmpty()) {
                Range toRead = uninitialized.span();
                assert (toRead.hasUpperBound() && toRead.hasLowerBound());
                long lower = this.lower(toRead);
                long upper = this.upper(toRead);
                ByteBuffer buf = ByteBuffer.allocate((int)(upper - lower + 1L));
                ((PcodeTraceDataAccess)this.backing).getBytes(this.space.getAddress(lower), buf);
                for (Range rng : uninitialized.asRanges()) {
                    long l = this.lower(rng);
                    long u = this.upper(rng);
                    this.bytes.putData(l, buf.array(), (int)(l - lower), (int)(u - l + 1L));
                }
            }
        }

        protected void warnUnknown(AddressSetView unknown) {
            this.warnAddressSet("Emulator state initialized from UNKNOWN", unknown);
        }

        protected void writeDown(PcodeTraceDataAccess into) {
            if (this.space.isUniqueSpace()) {
                return;
            }
            byte[] data = new byte[4096];
            ByteBuffer buf = ByteBuffer.wrap(data);
            for (AddressRange range : this.written) {
                int len;
                long lower = range.getMinAddress().getOffset();
                for (long fullLen = range.getLength(); fullLen > 0L; fullLen -= (long)len) {
                    len = MathUtilities.unsignedMin((int)data.length, (long)fullLen);
                    this.bytes.getData(lower, data, 0, len);
                    buf.position(0);
                    buf.limit(len);
                    into.putBytes(this.space.getAddress(lower), buf);
                    lower += (long)len;
                }
            }
        }
    }

    protected class TraceBackedSpaceMap
    extends AbstractLongOffsetPcodeExecutorStatePiece.CacheingSpaceMap<PcodeTraceDataAccess, CachedSpace> {
        protected TraceBackedSpaceMap() {
        }

        protected PcodeTraceDataAccess getBacking(AddressSpace space) {
            return BytesTracePcodeExecutorStatePiece.this.data;
        }

        protected CachedSpace newSpace(AddressSpace space, PcodeTraceDataAccess backing) {
            return new CachedSpace(BytesTracePcodeExecutorStatePiece.this.language, space, backing);
        }
    }
}

