/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import db.IllegalFieldAccessException;
import db.PrimitiveField;
import db.buffers.DataBuffer;
import java.io.IOException;

public final class IntField
extends PrimitiveField {
    public static final IntField MIN_VALUE = new IntField(Integer.MIN_VALUE, true);
    public static final IntField MAX_VALUE = new IntField(Integer.MAX_VALUE, true);
    public static final IntField ZERO_VALUE;
    public static final IntField INSTANCE;
    private int value;

    public IntField() {
    }

    public IntField(int i) {
        this(i, false);
    }

    IntField(int i, boolean immutable) {
        super(immutable);
        this.value = i;
    }

    @Override
    void setNull() {
        super.setNull();
        this.value = 0;
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public void setIntValue(int value) {
        this.updatingPrimitiveValue();
        this.value = value;
    }

    @Override
    int length() {
        return 4;
    }

    @Override
    int write(Buffer buf, int offset) throws IOException {
        return buf.putInt(offset, this.value);
    }

    @Override
    int read(Buffer buf, int offset) throws IOException {
        this.updatingPrimitiveValue();
        this.value = buf.getInt(offset);
        return offset + 4;
    }

    @Override
    int readLength(Buffer buf, int offset) throws IOException {
        return 4;
    }

    @Override
    byte getFieldType() {
        return 2;
    }

    @Override
    public String getValueAsString() {
        return "0x" + Integer.toHexString(this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IntField)) {
            return false;
        }
        return ((IntField)obj).value == this.value;
    }

    @Override
    public int compareTo(Field o) {
        IntField f = (IntField)o;
        if (this.value == f.value) {
            return 0;
        }
        if (this.value < f.value) {
            return -1;
        }
        return 1;
    }

    @Override
    int compareTo(DataBuffer buffer, int offset) {
        int otherValue = buffer.getInt(offset);
        if (this.value == otherValue) {
            return 0;
        }
        if (this.value < otherValue) {
            return -1;
        }
        return 1;
    }

    @Override
    public IntField copyField() {
        if (this.isNull()) {
            IntField copy = new IntField();
            copy.setNull();
            return copy;
        }
        return new IntField((int)this.getLongValue());
    }

    @Override
    public IntField newField() {
        return new IntField();
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public void setLongValue(long value) {
        this.setIntValue((int)value);
    }

    @Override
    public byte[] getBinaryData() {
        return new byte[]{(byte)(this.value >> 24), (byte)(this.value >> 16), (byte)(this.value >> 8), (byte)this.value};
    }

    @Override
    public void setBinaryData(byte[] bytes) {
        if (bytes == null) {
            this.setNull();
            return;
        }
        if (bytes.length != 4) {
            throw new IllegalFieldAccessException();
        }
        this.updatingPrimitiveValue();
        this.value = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    IntField getMinValue() {
        return MIN_VALUE;
    }

    @Override
    IntField getMaxValue() {
        return MAX_VALUE;
    }

    static {
        INSTANCE = ZERO_VALUE = new IntField(0, true);
    }
}

