/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import ghidra.feature.vt.gui.wizard.ChooseAddressSetEditorPanel;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AddressSetPanel
extends AbstractMageJPanel<VTWizardStateKey> {
    private final PluginTool tool;
    private final String name;
    private final VTWizardStateKey programDependencyKey;
    private final VTWizardStateKey addressSetViewKey;
    private final VTWizardStateKey selectionKey;
    private final VTWizardStateKey addressSetChoiceKey;
    private ChooseAddressSetEditorPanel panel;
    private Program program;

    public AddressSetPanel(PluginTool tool, String name, VTWizardStateKey programFileDependencyKey, VTWizardStateKey programDependencyKey, VTWizardStateKey addressSetViewKey, VTWizardStateKey selectionKey, VTWizardStateKey addressSetChoiceKey) {
        this.tool = tool;
        this.name = name;
        this.programDependencyKey = programDependencyKey;
        this.addressSetViewKey = addressSetViewKey;
        this.selectionKey = selectionKey;
        this.addressSetChoiceKey = addressSetChoiceKey;
        this.setLayout(new BorderLayout());
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
    }

    public void dispose() {
    }

    private AddressSet getAddressFactoryAddressSet(WizardState<VTWizardStateKey> state) {
        AddressSpace[] addressSpaces;
        Program programFromState = (Program)state.get((Object)this.programDependencyKey);
        AddressFactory factory = programFromState.getAddressFactory();
        AddressSet everything = new AddressSet();
        for (AddressSpace addressSpace : addressSpaces = factory.getAddressSpaces()) {
            Address minAddress = addressSpace.getMinAddress();
            Address maxAddress = addressSpace.getMaxAddress();
            AddressRangeImpl range = new AddressRangeImpl(minAddress, maxAddress);
            everything.add((AddressRange)range);
        }
        return everything;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("VersionTrackingPlugin", "Address_Set_Panel");
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
        if (this.panel != null) {
            this.remove(this.panel);
        }
        this.program = (Program)state.get((Object)this.programDependencyKey);
        AddressSetView addressSetView = (AddressSetView)state.get((Object)this.addressSetViewKey);
        AddressSetView selection = (AddressSetView)state.get((Object)this.selectionKey);
        ChooseAddressSetEditorPanel.AddressSetChoice addressSetChoice = (ChooseAddressSetEditorPanel.AddressSetChoice)((Object)state.get((Object)this.addressSetChoiceKey));
        if (addressSetChoice == null) {
            addressSetChoice = selection != null && !selection.isEmpty() ? ChooseAddressSetEditorPanel.AddressSetChoice.SELECTION : ChooseAddressSetEditorPanel.AddressSetChoice.ENTIRE_PROGRAM;
        }
        this.panel = new ChooseAddressSetEditorPanel(this.tool, this.name, this.program, selection, addressSetView, addressSetChoice);
        this.panel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AddressSetPanel.this.notifyListenersOfValidityChanged();
            }
        });
        this.add(this.panel, "Center");
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        boolean showPanel;
        Boolean value = (Boolean)state.get((Object)VTWizardStateKey.SHOW_ADDRESS_SET_PANELS);
        boolean bl = showPanel = value == null ? false : value;
        if (!showPanel) {
            return WizardPanelDisplayability.DO_NOT_DISPLAY;
        }
        return WizardPanelDisplayability.CAN_BE_DISPLAYED;
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.updateStateObjectWithPanelInfo(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
        AddressSetView addressSetView = this.panel.getAddressSetView();
        state.put((Object)this.addressSetViewKey, (Object)addressSetView);
        state.put((Object)this.addressSetChoiceKey, (Object)this.panel.getAddressSetChoice());
    }

    public String getTitle() {
        return "Select " + this.name + " Address Range(s)";
    }

    public void initialize() {
    }

    public boolean isValidInformation() {
        boolean empty = this.panel.getAddressSetView().isEmpty();
        String msg = empty ? "At least one address range is required" : "";
        this.notifyListenersOfStatusMessage(msg);
        return !empty;
    }
}

