/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.actions.PopupActionProvider;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.listingpanel.ListingCodeComparisonPanel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.gui.actions.ApplyAndAddAsPrimaryMarkupItemAction;
import ghidra.feature.vt.gui.actions.ApplyAndAddMarkupItemAction;
import ghidra.feature.vt.gui.actions.ApplyAndReplaceMarkupItemAction;
import ghidra.feature.vt.gui.actions.ApplyUsingOptionsAndForcingMarkupItemAction;
import ghidra.feature.vt.gui.actions.DontCareMarkupItemAction;
import ghidra.feature.vt.gui.actions.DontKnowMarkupItemAction;
import ghidra.feature.vt.gui.actions.EditMarkupAddressAction;
import ghidra.feature.vt.gui.actions.RejectMarkupItemAction;
import ghidra.feature.vt.gui.actions.ReplaceDefaultMarkupItemAction;
import ghidra.feature.vt.gui.actions.ReplaceFirstMarkupItemAction;
import ghidra.feature.vt.gui.actions.ResetMarkupItemAction;
import ghidra.feature.vt.gui.duallisting.VTDualListingDragNDropHandler;
import ghidra.feature.vt.gui.duallisting.VTDualListingHighlightProvider;
import ghidra.feature.vt.gui.duallisting.VTListingContext;
import ghidra.feature.vt.gui.duallisting.VTListingNavigator;
import ghidra.feature.vt.gui.editors.AddressInputDialog;
import ghidra.feature.vt.gui.filters.AncillaryFilterDialogComponentProvider;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterDialogModel;
import ghidra.feature.vt.gui.filters.FilterStatusListener;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.markuptable.MarkupItemFilterDialogComponentProvider;
import ghidra.feature.vt.gui.provider.markuptable.MarkupItemRenderer;
import ghidra.feature.vt.gui.provider.markuptable.VTMarkupItemContext;
import ghidra.feature.vt.gui.provider.markuptable.VTMarkupItemsTableModel;
import ghidra.feature.vt.gui.util.AllTextFilter;
import ghidra.feature.vt.gui.util.FilterIconFlashTimer;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import resources.ResourceManager;

public class VTMarkupItemsTableProvider
extends ComponentProviderAdapter
implements FilterDialogModel<VTMarkupItem>,
VTControllerListener,
PopupActionProvider {
    private static final String SHOW_COMPARISON_PANEL = "SHOW_COMPARISON_PANEL";
    private static final Icon SHOW_LISTINGS_ICON = ResourceManager.loadImage((String)"images/application_tile_horizontal.png");
    private static final Icon FILTER_ICON = ResourceManager.loadImage((String)"images/view-filter.png");
    private static final String SHOW_COMPARE_ACTION_GROUP = "A9_ShowCompare";
    private final VTController controller;
    private JComponent component;
    private JPanel markupPanel;
    private JSplitPane splitPane;
    private JPanel markupItemsTablePanel;
    private MarkupItemThreadedTablePanel tablePanel;
    private FunctionComparisonPanel functionComparisonPanel;
    private GhidraTable markupItemsTable;
    private VTMarkupItemsTableModel markupItemsTableModel;
    private ListSelectionListener markupItemSelectionListener;
    private AncillaryFilterDialogComponentProvider<VTMarkupItem> ancillaryFilterDialog;
    private JButton ancillaryFilterButton;
    private FilterIconFlashTimer<VTMarkupItem> iconTimer;
    private Set<Filter<VTMarkupItem>> filters = new HashSet<Filter<VTMarkupItem>>();
    private FilterStatusListener refilterListener = new RefilterListener();
    private boolean filteringFrozen;
    private ToggleDualListingVisibilityAction toggleListingVisibility;
    private boolean processingSourceLocationChange = false;
    private boolean processingDestinationLocationChange = false;
    private boolean processingMarkupItemSelected = false;
    private VTDualListingHighlightProvider sourceHighlightProvider;
    private VTDualListingHighlightProvider destinationHighlightProvider;

    public VTMarkupItemsTableProvider(VTController controller) {
        super(controller.getTool(), "Version Tracking Markup Items", VTPlugin.OWNER);
        this.controller = controller;
        controller.addListener(this);
        this.setWindowGroup("VTResults");
        this.setIcon(ResourceManager.loadImage((String)"images/application_view_detail.png"));
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setIntraGroupPosition(WindowPosition.STACK);
        this.component = this.createComponent();
        this.createActions();
        this.addGeneralCodeComparisonActions();
        this.addToTool();
        this.ancillaryFilterDialog = new MarkupItemFilterDialogComponentProvider(controller, this);
        this.iconTimer = new FilterIconFlashTimer<VTMarkupItem>(VTPlugin.UNFILTERED_ICON, VTPlugin.FILTERED_ICON, this.ancillaryFilterDialog, this.ancillaryFilterButton);
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        HelpLocation helpLocation = new HelpLocation("VersionTrackingPlugin", "Markup Items Table");
        this.setHelpLocation(helpLocation);
        this.setVisible(true);
    }

    private JComponent createComponent() {
        this.markupPanel = new JPanel(new BorderLayout());
        this.markupItemsTable = this.createMarkupItemTable();
        this.markupItemsTablePanel = new JPanel(new BorderLayout());
        JPanel filterAreaPanel = this.createFilterArea();
        this.markupItemsTablePanel.add((Component)((Object)this.tablePanel), "Center");
        this.markupItemsTablePanel.add((Component)filterAreaPanel, "South");
        this.functionComparisonPanel = new FunctionComparisonPanel((ComponentProviderAdapter)this, this.tool, (Function)null, (Function)null);
        this.addSpecificCodeComparisonActions();
        this.functionComparisonPanel.setCurrentTabbedComponent("Listing View");
        this.functionComparisonPanel.setTitlePrefixes("Source:", "Destination:");
        ListingCodeComparisonPanel dualListingPanel = this.functionComparisonPanel.getDualListingPanel();
        if (dualListingPanel != null) {
            dualListingPanel.setLeftProgramLocationListener((ProgramLocationListener)new SourceProgramLocationListener());
            dualListingPanel.setRightProgramLocationListener((ProgramLocationListener)new DestinationProgramLocationListener());
            this.sourceHighlightProvider = new VTDualListingHighlightProvider(this.controller, true);
            this.destinationHighlightProvider = new VTDualListingHighlightProvider(this.controller, false);
            dualListingPanel.addHighlightProviders((HighlightProvider)this.sourceHighlightProvider, (HighlightProvider)this.destinationHighlightProvider);
            this.sourceHighlightProvider.setListingPanel(dualListingPanel.getLeftPanel());
            this.destinationHighlightProvider.setListingPanel(dualListingPanel.getRightPanel());
            new VTDualListingDragNDropHandler(this.controller, dualListingPanel);
        }
        this.splitPane = new JSplitPane(0, this.markupItemsTablePanel, (Component)this.functionComparisonPanel);
        this.splitPane.setResizeWeight(0.4);
        this.markupPanel.add((Component)this.splitPane, "Center");
        return this.markupPanel;
    }

    private void addSpecificCodeComparisonActions() {
        DockingAction[] actions;
        for (DockingAction dockingAction : actions = this.functionComparisonPanel.getCodeComparisonActions()) {
            this.addLocalAction((DockingActionIf)dockingAction);
        }
    }

    private void addGeneralCodeComparisonActions() {
        this.toggleListingVisibility = new ToggleDualListingVisibilityAction();
        this.addLocalAction((DockingActionIf)this.toggleListingVisibility);
    }

    private GhidraTable createMarkupItemTable() {
        this.tablePanel = new MarkupItemThreadedTablePanel((ThreadedTableModel<VTMarkupItem, ?>)this.createTableModel());
        final GhidraTable table = this.tablePanel.getTable();
        table.setActionsEnabled(true);
        table.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                VTMarkupItemsTableProvider.this.iconTimer.restart();
            }
        });
        this.markupItemSelectionListener = new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                try {
                    VTMarkupItemsTableProvider.this.processingMarkupItemSelected = true;
                    ListingCodeComparisonPanel dualListingPanel = VTMarkupItemsTableProvider.this.functionComparisonPanel.getDualListingPanel();
                    VTMarkupItem markupItem = null;
                    if (table.getSelectedRowCount() != 1) {
                        if (dualListingPanel != null) {
                            dualListingPanel.updateListings();
                        }
                        VTMarkupItemsTableProvider.this.controller.setSelectedMarkupItem(null);
                        return;
                    }
                    RowObjectTableModel model = (RowObjectTableModel)table.getModel();
                    int selectedRow = table.getSelectedRow();
                    markupItem = (VTMarkupItem)model.getRowObject(selectedRow);
                    VTMarkupItemsTableProvider.this.notifyContextChanged();
                    if (dualListingPanel != null) {
                        if (!VTMarkupItemsTableProvider.this.processingSourceLocationChange && !VTMarkupItemsTableProvider.this.processingDestinationLocationChange) {
                            dualListingPanel.setLeftLocation(dualListingPanel.getLeftProgram(), markupItem.getSourceLocation());
                            dualListingPanel.setRightLocation(dualListingPanel.getRightProgram(), markupItem.getDestinationLocation());
                        } else {
                            ProgramLocation sourceLocation = markupItem.getSourceLocation();
                            if (VTMarkupItemsTableProvider.this.processingDestinationLocationChange && sourceLocation != null) {
                                dualListingPanel.setLeftLocation(dualListingPanel.getLeftProgram(), sourceLocation);
                            }
                            ProgramLocation destinationLocation = markupItem.getDestinationLocation();
                            if (VTMarkupItemsTableProvider.this.processingSourceLocationChange && destinationLocation != null) {
                                dualListingPanel.setRightLocation(dualListingPanel.getRightProgram(), destinationLocation);
                            }
                        }
                        dualListingPanel.updateListings();
                    }
                    VTMarkupItemsTableProvider.this.controller.setSelectedMarkupItem(markupItem);
                }
                finally {
                    VTMarkupItemsTableProvider.this.processingMarkupItemSelected = false;
                }
            }
        };
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.addListSelectionListener(this.markupItemSelectionListener);
        TableColumnModel columnModel = table.getColumnModel();
        int columnIndex = this.markupItemsTableModel.getColumnIndex(VTMarkupItemsTableModel.AppliedDestinationAddressTableColumn.class);
        TableColumn column = columnModel.getColumn(columnIndex);
        column.setCellEditor(new AddressInputDialog(this.controller));
        Dimension size = table.getPreferredScrollableViewportSize();
        Dimension preferredSize = table.getPreferredSize();
        JScrollBar scrollBar = new JScrollBar(1);
        Dimension scrollBarSize = scrollBar.getMinimumSize();
        size.width = preferredSize.width + scrollBarSize.width;
        table.setPreferredScrollableViewportSize(size);
        return table;
    }

    private VTMarkupItemsTableModel createTableModel() {
        this.markupItemsTableModel = new VTMarkupItemsTableModel(this.controller);
        this.markupItemsTableModel.addTableModelListener(e -> {
            int filteredCount = this.markupItemsTableModel.getRowCount();
            int unfilteredCount = this.markupItemsTableModel.getUnfilteredRowCount();
            String sessionName = this.controller.getVersionTrackingSessionName();
            StringBuffer buffy = new StringBuffer();
            buffy.append("[Session: ").append(sessionName).append("] ");
            buffy.append('-').append(this.markupItemsTableModel.getRowCount()).append(" markup items");
            if (filteredCount != unfilteredCount) {
                buffy.append(" (of ").append(this.markupItemsTableModel.getUnfilteredRowCount()).append(')');
            }
            this.setSubTitle(buffy.toString());
            this.updateFilterDisplay();
        });
        return this.markupItemsTableModel;
    }

    private void showComparisonPanelWithinProvider(boolean show) {
        ListingCodeComparisonPanel dualListingPanel = this.functionComparisonPanel.getDualListingPanel();
        boolean contains = this.markupPanel.isAncestorOf(this.splitPane);
        if (show) {
            if (!contains) {
                this.markupPanel.remove(this.markupItemsTablePanel);
                this.splitPane.add(this.markupItemsTablePanel);
                this.splitPane.add((Component)this.functionComparisonPanel);
                this.markupPanel.add((Component)this.splitPane, "Center");
                if (dualListingPanel != null) {
                    dualListingPanel.setLeftProgramLocationListener((ProgramLocationListener)new SourceProgramLocationListener());
                    dualListingPanel.setRightProgramLocationListener((ProgramLocationListener)new DestinationProgramLocationListener());
                }
                this.markupPanel.validate();
                this.load(this.controller.getMatchInfo());
                this.markupItemsTable.requestFocus();
            }
        } else if (contains) {
            if (dualListingPanel != null) {
                dualListingPanel.setLeftProgramLocationListener(null);
                dualListingPanel.setRightProgramLocationListener(null);
            }
            this.markupPanel.remove(this.splitPane);
            this.splitPane.remove((Component)this.functionComparisonPanel);
            this.splitPane.remove(this.markupItemsTablePanel);
            this.markupPanel.add((Component)this.markupItemsTablePanel, "Center");
            this.markupPanel.validate();
            this.markupItemsTable.requestFocus();
        }
        this.toggleListingVisibility.setSelected(show);
        this.functionComparisonPanel.updateActionEnablement();
    }

    private JPanel createFilterArea() {
        JPanel parentPanel = new JPanel(new BorderLayout());
        JComponent nameFilterPanel = this.createTextFilterPanel();
        parentPanel.add((Component)nameFilterPanel, "Center");
        this.ancillaryFilterButton = new JButton(FILTER_ICON);
        this.ancillaryFilterButton.addActionListener(e -> this.tool.showDialog(this.ancillaryFilterDialog, (Component)this.component));
        this.ancillaryFilterButton.setToolTipText("Filters Dialog");
        parentPanel.add((Component)this.ancillaryFilterButton, "East");
        HelpLocation filterHelpLocation = new HelpLocation("VersionTrackingPlugin", "Markup_Filters");
        HelpService helpService = DockingWindowManager.getHelpService();
        helpService.registerHelp((Object)parentPanel, filterHelpLocation);
        helpService.registerHelp((Object)this.ancillaryFilterButton, filterHelpLocation);
        return parentPanel;
    }

    private JComponent createTextFilterPanel() {
        AllTextFilter<VTMarkupItem> allTextFilter = new AllTextFilter<VTMarkupItem>(this.controller, (GTable)this.markupItemsTable, (ThreadedTableModel<VTMarkupItem, ?>)this.markupItemsTableModel);
        this.addFilter((Filter<VTMarkupItem>)allTextFilter);
        return allTextFilter.getComponent();
    }

    private void refilter() {
        if (this.filteringFrozen) {
            return;
        }
        this.forceRefilter();
    }

    private void createActions() {
        this.addLocalAction((DockingActionIf)new ApplyUsingOptionsAndForcingMarkupItemAction(this.controller, true));
        this.addLocalAction((DockingActionIf)new ApplyAndAddMarkupItemAction(this.controller, false));
        this.addLocalAction((DockingActionIf)new ApplyAndAddAsPrimaryMarkupItemAction(this.controller, false));
        this.addLocalAction((DockingActionIf)new ApplyAndReplaceMarkupItemAction(this.controller, false));
        this.addLocalAction((DockingActionIf)new ReplaceDefaultMarkupItemAction(this.controller, false));
        this.addLocalAction((DockingActionIf)new ReplaceFirstMarkupItemAction(this.controller, false));
        this.addLocalAction((DockingActionIf)new DontKnowMarkupItemAction(this.controller, false));
        this.addLocalAction((DockingActionIf)new DontCareMarkupItemAction(this.controller, false));
        this.addLocalAction((DockingActionIf)new RejectMarkupItemAction(this.controller, true));
        this.addLocalAction((DockingActionIf)new ResetMarkupItemAction(this.controller, true));
        this.addLocalAction((DockingActionIf)new EditMarkupAddressAction(this.controller, false));
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        ListingCodeComparisonPanel dualListingPanel = this.functionComparisonPanel.getDualListingPanel();
        if (context.getComponentProvider() == this && dualListingPanel != null) {
            ListingPanel sourcePanel = dualListingPanel.getLeftPanel();
            return sourcePanel.getHeaderActions(this.getName());
        }
        return new ArrayList<DockingActionIf>();
    }

    public ActionContext getActionContext(MouseEvent event) {
        ListingPanel listingPanel;
        Component sourceComponent;
        Object source = event != null ? event.getSource() : null;
        Component component = sourceComponent = source instanceof Component ? (Component)source : null;
        if (event == null || this.tablePanel.isAncestorOf(sourceComponent)) {
            List<VTMarkupItem> selectedItems = this.getSelectedMarkupItems();
            VTMarkupItemContext vtMarkupItemContext = new VTMarkupItemContext(this, selectedItems);
            if (this.functionComparisonPanel.isVisible()) {
                CodeComparisonPanel displayedPanel = this.functionComparisonPanel.getDisplayedPanel();
                vtMarkupItemContext.setCodeComparisonPanel((CodeComparisonPanel<? extends FieldPanelCoordinator>)displayedPanel);
            }
            return vtMarkupItemContext;
        }
        ListingCodeComparisonPanel dualListingPanel = this.functionComparisonPanel.getDualListingPanel();
        if (dualListingPanel != null && dualListingPanel.isAncestorOf(sourceComponent) && sourceComponent instanceof FieldPanel && (listingPanel = dualListingPanel.getListingPanel((FieldPanel)sourceComponent)) != null) {
            VTListingNavigator vtListingNavigator = new VTListingNavigator(dualListingPanel, listingPanel);
            VTListingContext vtListingContext = new VTListingContext((ComponentProvider)this, vtListingNavigator);
            vtListingContext.setCodeComparisonPanel((CodeComparisonPanel<? extends FieldPanelCoordinator>)dualListingPanel);
            vtListingContext.setContextObject(dualListingPanel);
            vtListingContext.setSourceObject(source);
            return vtListingContext;
        }
        return this.functionComparisonPanel.getActionContext(event, (ComponentProvider)this);
    }

    List<VTMarkupItem> getSelectedMarkupItems() {
        int[] selectedRows;
        ArrayList<VTMarkupItem> list = new ArrayList<VTMarkupItem>();
        for (int row : selectedRows = this.markupItemsTable.getSelectedRows()) {
            VTMarkupItem markupItem = (VTMarkupItem)this.markupItemsTableModel.getRowObject(row);
            list.add(markupItem);
        }
        return list;
    }

    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void disposed() {
        if (this.markupItemsTable == null) {
            return;
        }
        ListSelectionModel selectionModel = this.markupItemsTable.getSelectionModel();
        selectionModel.removeListSelectionListener(this.markupItemSelectionListener);
        this.markupItemsTableModel.dispose();
        for (Filter<VTMarkupItem> filter : this.filters) {
            filter.dispose();
        }
        this.tool.removePopupActionProvider((PopupActionProvider)this);
    }

    VTController getController() {
        return this.controller;
    }

    private void refresh() {
        this.markupItemsTableModel.reload(false);
        this.markupItemsTable.repaint();
        ListingCodeComparisonPanel dualListingPanel = this.functionComparisonPanel.getDualListingPanel();
        if (dualListingPanel != null) {
            dualListingPanel.updateListings();
        }
        this.sourceHighlightProvider.updateMarkup();
        this.destinationHighlightProvider.updateMarkup();
    }

    public void componentHidden() {
        this.functionComparisonPanel.clear();
    }

    public void componentShown() {
        this.sessionChanged(this.controller.getSession());
    }

    public void reload() {
        if (!this.isVisible()) {
            return;
        }
        this.load(this.controller.getMatchInfo());
    }

    public void load(MatchInfo matchInfo) {
        if (!this.isVisible()) {
            return;
        }
        this.markupItemsTable.clearSelection();
        this.markupItemsTableModel.reload();
        if (this.splitPane.isAncestorOf((Component)this.functionComparisonPanel)) {
            this.loadComparisonPanel(matchInfo);
        }
    }

    private void loadComparisonPanel(MatchInfo matchInfo) {
        if (matchInfo != null) {
            VTAssociationType type = matchInfo.getMatch().getAssociation().getType();
            if (type == VTAssociationType.DATA) {
                Data sourceData = matchInfo.getSourceData();
                Data destinationData = matchInfo.getDestinationData();
                if (sourceData != null && destinationData != null) {
                    this.functionComparisonPanel.loadData(sourceData, destinationData);
                } else {
                    this.loadAddresses(matchInfo);
                }
            } else {
                Function sourceFunction = matchInfo.getSourceFunction();
                Function destinationFunction = matchInfo.getDestinationFunction();
                if (sourceFunction != null && destinationFunction != null) {
                    this.functionComparisonPanel.loadFunctions(sourceFunction, destinationFunction);
                } else {
                    this.loadAddresses(matchInfo);
                }
            }
        } else {
            this.functionComparisonPanel.loadFunctions(null, null);
        }
        if (this.sourceHighlightProvider != null) {
            this.sourceHighlightProvider.updateMarkup();
        }
        if (this.destinationHighlightProvider != null) {
            this.destinationHighlightProvider.updateMarkup();
        }
        this.functionComparisonPanel.validate();
    }

    private void loadAddresses(MatchInfo matchInfo) {
        VTMatch match = matchInfo.getMatch();
        VTAssociation association = match.getAssociation();
        Address sourceAddress = association.getSourceAddress();
        Address destinationAddress = association.getDestinationAddress();
        int sourceLength = match.getSourceLength();
        int destinationLength = match.getDestinationLength();
        VTSession session = association.getSession();
        Program sourceProgram = session.getSourceProgram();
        Program destinationProgram = session.getDestinationProgram();
        Listing sourceListing = sourceProgram.getListing();
        Listing destinationListing = destinationProgram.getListing();
        CodeUnit sourceCodeUnit = sourceListing.getCodeUnitContaining(sourceAddress);
        CodeUnit destinationCodeUnit = destinationListing.getCodeUnitContaining(destinationAddress);
        Address sourceStart = sourceCodeUnit != null ? sourceCodeUnit.getMinAddress() : sourceAddress;
        Address destinationStart = destinationCodeUnit != null ? destinationCodeUnit.getMinAddress() : destinationAddress;
        Address sourceEnd = sourceLength > 1 ? sourceAddress.add((long)(sourceLength - 1)) : sourceStart;
        Address destinationEnd = destinationLength > 1 ? destinationAddress.add((long)(destinationLength - 1)) : destinationStart;
        AddressSet sourceAddressSet = new AddressSet(sourceStart, sourceEnd);
        AddressSet destinationAddressSet = new AddressSet(destinationStart, destinationEnd);
        this.functionComparisonPanel.loadAddresses(sourceProgram, destinationProgram, (AddressSetView)sourceAddressSet, (AddressSetView)destinationAddressSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSourceLocationChange(ProgramLocation programLocation) {
        if (this.processingSourceLocationChange) {
            return;
        }
        MatchInfo matchInfo = this.controller.getMatchInfo();
        if (matchInfo == null) {
            return;
        }
        AddressSetView sourceAddressSet = matchInfo.getSourceAddressSet();
        Address address = programLocation.getAddress();
        if (sourceAddressSet != null && sourceAddressSet.contains(address)) {
            try {
                this.processingSourceLocationChange = true;
                Program sourceProgram = this.controller.getSourceProgram();
                VTMarkupType markupType = MatchInfo.getMarkupTypeForLocation(programLocation, sourceProgram);
                if (markupType == null) {
                    return;
                }
                Address markupAddress = MatchInfo.getMarkupAddressForLocation(programLocation, sourceProgram);
                this.selectMarkupItem(markupAddress, true, markupType);
            }
            finally {
                this.processingSourceLocationChange = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDestinationLocationChange(ProgramLocation programLocation) {
        if (this.processingDestinationLocationChange) {
            return;
        }
        MatchInfo matchInfo = this.controller.getMatchInfo();
        if (matchInfo == null) {
            return;
        }
        AddressSetView destinationAddressSet = matchInfo.getDestinationAddressSet();
        Address address = programLocation.getAddress();
        if (destinationAddressSet != null && destinationAddressSet.contains(address)) {
            try {
                this.processingDestinationLocationChange = true;
                Program destinationProgram = this.controller.getDestinationProgram();
                VTMarkupType markupType = MatchInfo.getMarkupTypeForLocation(programLocation, this.controller.getDestinationProgram());
                if (markupType == null) {
                    return;
                }
                Address markupAddress = MatchInfo.getMarkupAddressForLocation(programLocation, destinationProgram);
                this.selectMarkupItem(markupAddress, false, markupType);
            }
            finally {
                this.processingDestinationLocationChange = false;
            }
        }
    }

    void selectMarkupItem(Address address, boolean isSourceAddress, VTMarkupType markupType) {
        if (address == null) {
            return;
        }
        int rowCount = this.markupItemsTableModel.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            Address markupItemAddress;
            VTMarkupItem markupItem = (VTMarkupItem)this.markupItemsTableModel.getRowObject(row);
            Address address2 = markupItemAddress = isSourceAddress ? markupItem.getSourceAddress() : markupItem.getDestinationAddress();
            if (!address.equals((Object)markupItemAddress) || markupItem.getMarkupType() != markupType) continue;
            this.selectRowAndMakeVisible(row);
        }
    }

    private void selectRowAndMakeVisible(int row) {
        GhidraTable table = this.tablePanel.getTable();
        table.selectRow(row);
        Rectangle cellRect = table.getCellRect(row, 0, true);
        table.scrollRectToVisible(cellRect);
    }

    public boolean isDualListingShowing() {
        ListingCodeComparisonPanel dualListingPanel = this.functionComparisonPanel.getDualListingPanel();
        if (dualListingPanel == null) {
            return false;
        }
        return dualListingPanel.isShowing();
    }

    @Override
    public void matchSelected(MatchInfo matchInfo) {
        if (!this.isVisible()) {
            return;
        }
        this.load(matchInfo);
    }

    @Override
    public void sessionChanged(VTSession session) {
        if (!this.isVisible()) {
            return;
        }
        this.markupItemsTableModel.setProgram(this.controller.getSourceProgram());
        this.reload();
    }

    @Override
    public void sessionUpdated(DomainObjectChangedEvent ev) {
        if (!this.isVisible()) {
            return;
        }
        if (ev.containsEvent(4) || ev.containsEvent(1031) || ev.containsEvent(1030)) {
            MatchInfo matchInfo = this.controller.getMatchInfo();
            if (matchInfo != null) {
                matchInfo.clearCache();
            }
            this.refresh();
            this.tool.contextChanged((ComponentProvider)this);
        }
    }

    @Override
    public void markupItemSelected(VTMarkupItem markupItem) {
        if (this.sourceHighlightProvider != null) {
            this.sourceHighlightProvider.setMarkupItem(markupItem);
        }
        if (this.destinationHighlightProvider != null) {
            this.destinationHighlightProvider.setMarkupItem(markupItem);
        }
    }

    @Override
    public void optionsChanged(Options options) {
    }

    public void readConfigState(SaveState saveState) {
        this.functionComparisonPanel.readConfigState(this.getName(), saveState);
        this.showComparisonPanelWithinProvider(saveState.getBoolean(SHOW_COMPARISON_PANEL, true));
        for (Filter<VTMarkupItem> filter : this.filters) {
            filter.readConfigState(saveState);
        }
        this.updateFilterDisplay();
    }

    private void updateFilterDisplay() {
        if (this.ancillaryFilterDialog == null) {
            return;
        }
        boolean filtered = this.ancillaryFilterDialog.isFiltered();
        if (filtered) {
            this.ancillaryFilterButton.setIcon(VTPlugin.FILTERED_ICON);
        } else {
            this.ancillaryFilterButton.setIcon(VTPlugin.UNFILTERED_ICON);
        }
        VTSession session = this.controller.getSession();
        if (session == null) {
            return;
        }
        if (filtered) {
            int filteredCount = this.markupItemsTableModel.getRowCount();
            int unfilteredCount = this.markupItemsTableModel.getUnfilteredRowCount();
            int filteredOutCount = unfilteredCount - filteredCount;
            this.ancillaryFilterButton.setToolTipText("More Filters - " + filteredOutCount + " item(s) hidden");
        } else {
            this.ancillaryFilterButton.setToolTipText("More Filters - no active filters");
        }
    }

    public void writeConfigState(SaveState saveState) {
        this.functionComparisonPanel.writeConfigState(this.getName(), saveState);
        saveState.putBoolean(SHOW_COMPARISON_PANEL, this.functionComparisonPanel.isShowing());
        for (Filter<VTMarkupItem> filter : this.filters) {
            filter.writeConfigState(saveState);
        }
    }

    @Override
    public void addFilter(Filter<VTMarkupItem> filter) {
        filter.addFilterStatusListener(this.refilterListener);
        this.filters.add(filter);
        this.markupItemsTableModel.addFilter(filter);
    }

    @Override
    public void forceRefilter() {
        this.markupItemsTableModel.updateFilter();
        this.updateFilterDisplay();
    }

    @Override
    public void dialogVisibilityChanged(boolean isVisible) {
        this.filteringFrozen = isVisible;
        this.refilter();
    }

    public FunctionComparisonPanel getFunctionComparisonPanel() {
        return this.functionComparisonPanel;
    }

    private class RefilterListener
    implements FilterStatusListener {
        private RefilterListener() {
        }

        @Override
        public void filterStatusChanged(Filter.FilterEditingStatus status) {
            if (status != Filter.FilterEditingStatus.ERROR) {
                VTMarkupItemsTableProvider.this.refilter();
            }
        }
    }

    private class MarkupItemThreadedTablePanel
    extends GhidraThreadedTablePanel<VTMarkupItem> {
        MarkupItemThreadedTablePanel(ThreadedTableModel<VTMarkupItem, ?> model) {
            super(model);
        }

        protected GTable createTable(ThreadedTableModel<VTMarkupItem, ?> model) {
            return new MarkupTable((RowObjectTableModel<VTMarkupItem>)model);
        }

        private class MarkupTable
        extends GhidraTable {
            private TableCellRenderer renderer;

            MarkupTable(RowObjectTableModel<VTMarkupItem> model) {
                super(model);
                this.renderer = new MarkupItemRenderer();
            }

            public TableCellRenderer getCellRenderer(int row, int col) {
                return this.renderer;
            }
        }
    }

    private class SourceProgramLocationListener
    implements ProgramLocationListener {
        private SourceProgramLocationListener() {
        }

        public void programLocationChanged(ProgramLocation loc, EventTrigger trigger) {
            if (!VTMarkupItemsTableProvider.this.processingMarkupItemSelected) {
                VTMarkupItemsTableProvider.this.processSourceLocationChange(loc);
            }
        }
    }

    private class DestinationProgramLocationListener
    implements ProgramLocationListener {
        private DestinationProgramLocationListener() {
        }

        public void programLocationChanged(ProgramLocation loc, EventTrigger trigger) {
            if (!VTMarkupItemsTableProvider.this.processingMarkupItemSelected) {
                VTMarkupItemsTableProvider.this.processDestinationLocationChange(loc);
            }
        }
    }

    class ToggleDualListingVisibilityAction
    extends ToggleDockingAction {
        ToggleDualListingVisibilityAction() {
            super("Toggle Dual Listing Visibility", VTMarkupItemsTableProvider.this.getName());
            this.setDescription("Toggle Visibility of Dual Comparison Views");
            this.setSelected(true);
            this.setEnabled(true);
            this.setToolBarData(new ToolBarData(SHOW_LISTINGS_ICON, VTMarkupItemsTableProvider.SHOW_COMPARE_ACTION_GROUP));
            HelpLocation helpLocation = new HelpLocation("VersionTrackingPlugin", "Toggle Dual Listing Visibility");
            this.setHelpLocation(helpLocation);
        }

        public void actionPerformed(ActionContext context) {
            boolean show = !VTMarkupItemsTableProvider.this.functionComparisonPanel.isShowing();
            VTMarkupItemsTableProvider.this.showComparisonPanelWithinProvider(show);
        }
    }
}

