/*
 * Decompiled with CFR 0.152.
 */
package resources.icons;

import generic.util.image.ImageUtils;
import ghidra.util.Msg;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import javax.swing.ImageIcon;
import resources.icons.LazyImageIcon;

public class UrlImageIcon
extends LazyImageIcon {
    private URL imageUrl;

    public UrlImageIcon(String path, URL url) {
        super(path);
        this.imageUrl = Objects.requireNonNull(url);
    }

    public URL getUrl() {
        return this.imageUrl;
    }

    @Override
    protected ImageIcon createImageIcon() {
        String name = this.getFilename();
        Image image = this.createImage();
        if (image == null) {
            return null;
        }
        if (!ImageUtils.waitForImage(name, image)) {
            return null;
        }
        return new ImageIcon(image, name);
    }

    protected Image createImage() {
        byte[] imageBytes = this.loadBytesFromURL(this.imageUrl);
        if (imageBytes == null) {
            return null;
        }
        return Toolkit.getDefaultToolkit().createImage(imageBytes);
    }

    private byte[] loadBytesFromURL(URL url) {
        byte[] byArray;
        block9: {
            InputStream is = url.openStream();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int length = 0;
                byte[] buf = new byte[1024];
                while ((length = is.read(buf)) > 0) {
                    os.write(buf, 0, length);
                }
                byArray = os.toByteArray();
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Exception loading image bytes: " + url.toExternalForm()), (Throwable)e);
                    return null;
                }
            }
            is.close();
        }
        return byArray;
    }
}

