/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.cmd;

import agent.dbgeng.dbgeng.DebugControl;
import agent.dbgeng.dbgeng.DebugDataSpaces;
import agent.dbgeng.manager.DbgEvent;
import agent.dbgeng.manager.DbgModuleMemory;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.evt.AbstractDbgCompletedCommandEvent;
import agent.dbgeng.manager.evt.DbgConsoleOutputEvent;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgModuleMemoryImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DbgListMemoryRegionsCommandAlt
extends AbstractDbgCommand<List<DbgModuleMemory>> {
    private List<DbgModuleMemory> memoryRegions = new ArrayList<DbgModuleMemory>();

    public DbgListMemoryRegionsCommandAlt(DbgManagerImpl manager) {
        super(manager);
    }

    @Override
    public boolean handle(DbgEvent<?> evt, DbgPendingCommand<?> pending) {
        if (evt instanceof AbstractDbgCompletedCommandEvent && pending.getCommand().equals(this)) {
            return true;
        }
        if (evt instanceof DbgConsoleOutputEvent) {
            pending.steal(evt);
        }
        return false;
    }

    @Override
    public List<DbgModuleMemory> complete(DbgPendingCommand<?> pending) {
        StringBuilder builder = new StringBuilder();
        for (DbgConsoleOutputEvent dbgConsoleOutputEvent : pending.findAllOf(DbgConsoleOutputEvent.class)) {
            builder.append(dbgConsoleOutputEvent.getOutput());
        }
        this.parse(builder.toString());
        Map<Long, DbgModuleMemory> memory = this.manager.getKnownMemoryRegions();
        for (DbgModuleMemory region : this.memoryRegions) {
            if (memory.containsValue(region)) continue;
            if (!memory.isEmpty()) {
                Msg.warn((Object)this, (Object)("Resync: Was missing memory: " + Long.toHexString(region.getId())));
            }
            this.manager.addMemory(region);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (Map.Entry<Long, DbgModuleMemory> entry : memory.entrySet()) {
            if (this.memoryRegions.contains(entry.getValue())) continue;
            arrayList.add(entry.getKey());
        }
        for (Long key : arrayList) {
            this.manager.removeMemory(key);
        }
        return this.memoryRegions;
    }

    private void parse(String result) {
        String[] lines;
        for (String line : lines = result.split("\n")) {
            long endVal;
            long startVal;
            String[] fields;
            if (line.startsWith("Mapping") || (fields = line.trim().split("\\s+")).length < 4) continue;
            String start = fields[0].replaceAll("`", "");
            String end = fields[1].replaceAll("`", "");
            try {
                startVal = Long.parseUnsignedLong(start, 16);
                endVal = Long.parseUnsignedLong(end, 16);
            }
            catch (Exception e) {
                continue;
            }
            String name = fields[3];
            ArrayList<String> protect = new ArrayList<String>();
            DbgModuleMemoryImpl region = new DbgModuleMemoryImpl(start, startVal, endVal, startVal, protect, protect, DebugDataSpaces.PageState.COMMIT, name, true, true, true);
            this.memoryRegions.add(region);
        }
    }

    @Override
    public void invoke() {
        DebugControl control = this.manager.getControl();
        control.execute("!address");
    }
}

