/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.yaffs2;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.yaffs2.YAFFS2Utils;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class YAFFS2ExtendedTags
implements StructConverter {
    private long sequenceNumber;
    private long objectId;
    private long chunkId;
    private long numberBytes;
    private long eccColParity;
    private long eccLineParity;
    private long eccLineParityPrime;

    public YAFFS2ExtendedTags(byte[] buffer) {
        this.sequenceNumber = YAFFS2Utils.parseInteger(buffer, 0, 4);
        this.objectId = YAFFS2Utils.parseInteger(buffer, 4, 4);
        this.chunkId = YAFFS2Utils.parseInteger(buffer, 8, 4);
        this.numberBytes = YAFFS2Utils.parseInteger(buffer, 12, 4);
        this.eccColParity = YAFFS2Utils.parseInteger(buffer, 16, 4);
        this.eccLineParity = YAFFS2Utils.parseInteger(buffer, 20, 4);
        this.eccLineParityPrime = YAFFS2Utils.parseInteger(buffer, 24, 4);
    }

    public YAFFS2ExtendedTags() {
    }

    public long getObjectId() {
        return this.objectId;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getChunkId() {
        return this.chunkId;
    }

    public long getNumberBytes() {
        return this.numberBytes;
    }

    public long getEccColParity() {
        return this.eccColParity;
    }

    public long getEccLineParity() {
        return this.eccLineParity;
    }

    public long getEccLineParityPrime() {
        return this.eccLineParityPrime;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("yaffs2Tags", 0);
        structure.add(DWORD, "sequenceNumber", null);
        structure.add(DWORD, "objectId", null);
        structure.add(DWORD, "chunkId", null);
        structure.add(DWORD, "numberBytes", null);
        structure.add(DWORD, "eccColParity", null);
        structure.add(DWORD, "eccLineParity", null);
        structure.add(DWORD, "eccLineParityPrime", null);
        structure.add((DataType)new ArrayDataType(BYTE, 36, BYTE.getLength()), "unused", null);
        return structure;
    }
}

