/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.ext4.Ext4DirEntry2;
import ghidra.file.formats.ext4.Ext4Extent;
import ghidra.file.formats.ext4.Ext4ExtentHeader;
import ghidra.file.formats.ext4.Ext4ExtentIdx;
import ghidra.file.formats.ext4.Ext4GroupDescriptor;
import ghidra.file.formats.ext4.Ext4IBlock;
import ghidra.file.formats.ext4.Ext4Inode;
import ghidra.file.formats.ext4.Ext4SuperBlock;
import ghidra.file.formats.ext4.MultiProgramMemoryByteProvider;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class NewExt4Analyzer
extends FileFormatAnalyzer {
    private int blockSize;
    private Program program2;
    private Program program3;

    public String getName() {
        return "Ext4 Analyzer NEW";
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Annotates Ext4 file systems. For EXT4 files >2GB, split into 2 programs. Analysis will markup both. Simply name the programs ABC and ABC_0x70000000 and ABC_0xF0000000";
    }

    public boolean canAnalyze(Program program) {
        MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider((Program)program, (boolean)false);
        BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
        int start = this.getSuperBlockStart(reader);
        if (start == -1) {
            return false;
        }
        reader.setPointerIndex(start + 56);
        int magic = -1;
        try {
            magic = reader.readNextShort() & 0xFFFF;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return magic == 61267;
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        this.program2 = this.findOtherProgram(program, "0x70000000");
        int transactionId2 = -1;
        if (this.program2 != null) {
            transactionId2 = this.program2.startTransaction(this.getName());
        }
        this.program3 = this.findOtherProgram(program, "0xE0000000");
        int transactionId3 = -1;
        if (this.program3 != null) {
            transactionId3 = this.program3.startTransaction(this.getName());
        }
        try {
            MultiProgramMemoryByteProvider provider = new MultiProgramMemoryByteProvider(program, this.program2, this.program3);
            BinaryReader reader = new BinaryReader((ByteProvider)provider, true);
            int start = this.getSuperBlockStart(reader);
            int groupStart = 0;
            reader.setPointerIndex(start);
            Ext4SuperBlock superBlock = new Ext4SuperBlock(reader);
            Address superBlockAddress = this.toAddr(program, start);
            this.createData(program, superBlockAddress, superBlock.toDataType());
            boolean is64Bit = superBlock.getS_desc_size() > 32 && (superBlock.getS_feature_incompat() & 0x80) > 0;
            long numBytes = program.getMaxAddress().getOffset() - program.getMinAddress().getOffset() + 1L;
            if (this.program2 != null) {
                numBytes = this.program2.getMaxAddress().getOffset() - program.getMinAddress().getOffset() + 1L;
            }
            if (this.program3 != null) {
                numBytes = this.program3.getMaxAddress().getOffset() - program.getMinAddress().getOffset() + 1L;
            }
            int groupSize = this.calculateGroupSize(superBlock);
            int numGroups = (int)(numBytes / (long)groupSize);
            if (numBytes % (long)groupSize != 0L) {
                ++numGroups;
            }
            this.setPlateComment(program, superBlockAddress, "SuperBlock (main) \nGroup Size In Bytes: 0x" + Integer.toHexString(groupSize) + "\nNumber of Groups: 0x" + Integer.toHexString(numGroups));
            long groupDescOffset = groupStart + this.blockSize;
            Address groupDescAddress = this.toAddr(program, groupDescOffset);
            reader.setPointerIndex(groupDescOffset);
            Ext4GroupDescriptor[] groupDescriptors = new Ext4GroupDescriptor[numGroups];
            monitor.setMessage("Creating group descriptors...");
            monitor.setMaximum((long)numGroups);
            for (int i = 0; i < numGroups; ++i) {
                monitor.checkCanceled();
                groupDescriptors[i] = new Ext4GroupDescriptor(reader, is64Bit);
                DataType groupDescDataType = groupDescriptors[i].toDataType();
                this.createData(program, groupDescAddress, groupDescDataType);
                this.setPlateComment(program, groupDescAddress, "group descriptor: " + i);
                groupDescAddress = groupDescAddress.add((long)groupDescDataType.getLength());
                monitor.incrementProgress(1L);
            }
            boolean isSparseSuper = (superBlock.getS_feature_ro_compat() & 1) != 0;
            this.createSuperBlockCopies(program, reader, groupSize, numGroups, is64Bit, isSparseSuper, monitor);
            this.createInodeTables(program, reader, superBlock, groupDescriptors, is64Bit, monitor);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.program2 != null) {
                this.program2.endTransaction(transactionId2, true);
                this.program2 = null;
            }
            if (this.program3 != null) {
                this.program3.endTransaction(transactionId3, true);
                this.program3 = null;
            }
        }
        return true;
    }

    private Program findOtherProgram(Program program, String suffix) {
        Program[] openPrograms;
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        ProgramManager programManager = (ProgramManager)manager.getAnalysisTool().getService(ProgramManager.class);
        for (Program otherProgram : openPrograms = programManager.getAllOpenPrograms()) {
            if (program == otherProgram || !otherProgram.getName().startsWith(program.getName()) || !otherProgram.getName().endsWith(suffix)) continue;
            return otherProgram;
        }
        return null;
    }

    @Override
    protected Data createData(Program program, Address address, DataType datatype) throws CodeUnitInsertionException {
        if (program.getMemory().contains(address)) {
            return super.createData(program, address, datatype);
        }
        if (this.program2 != null && this.program2.getMemory().contains(address)) {
            return super.createData(this.program2, address, datatype);
        }
        throw new CodeUnitInsertionException("Cannot create data, neither program contains that address.");
    }

    @Override
    protected boolean setPlateComment(Program program, Address address, String comment) {
        SetCommentCmd cmd = new SetCommentCmd(address, 3, comment);
        if (program.getMemory().contains(address)) {
            return cmd.applyTo((DomainObject)program);
        }
        if (this.program2 != null && this.program2.getMemory().contains(address)) {
            return cmd.applyTo((DomainObject)this.program2);
        }
        throw new RuntimeException("Cannot set plate comment, neither program contains that address.");
    }

    private void createInodeTables(Program program, BinaryReader reader, Ext4SuperBlock superBlock, Ext4GroupDescriptor[] groupDescriptors, boolean is64Bit, TaskMonitor monitor) throws DuplicateNameException, Exception {
        int inodeCount = superBlock.getS_inodes_count();
        Ext4Inode[] inodes = new Ext4Inode[inodeCount];
        int inodeIndex = 0;
        for (int i = 0; i < groupDescriptors.length; ++i) {
            monitor.checkCanceled();
            long inodeTableBlockOffset = (long)groupDescriptors[i].getBg_inode_table_lo() & 0xFFFFFFFFL;
            if (is64Bit) {
                inodeTableBlockOffset = (long)(groupDescriptors[i].getBg_inode_table_hi() << 32) | inodeTableBlockOffset;
            }
            long offset = inodeTableBlockOffset * (long)this.blockSize;
            reader.setPointerIndex(offset);
            Address address = null;
            try {
                address = this.toAddr(program, offset);
            }
            catch (Exception e) {
                throw new IOException("offset " + offset + " not in program.");
            }
            int inodesPerGroup = superBlock.getS_inodes_per_group();
            monitor.setMessage("Creating inode table " + i + " of " + (groupDescriptors.length - 1) + "...");
            monitor.setMaximum((long)inodesPerGroup);
            monitor.setProgress(0L);
            for (int j = 0; j < inodesPerGroup; ++j) {
                monitor.checkCanceled();
                Ext4Inode inode = new Ext4Inode(reader);
                DataType dataType = inode.toDataType();
                this.createData(program, address, dataType);
                String comment = "Inode: 0x" + Integer.toHexString(inodeIndex + 1) + "\n";
                comment = comment + "Group Descriptor ID: 0x" + Integer.toHexString(i) + "\n";
                comment = comment + "Inode Offset Into Group: 0x" + Integer.toHexString(j) + "\n";
                this.setPlateComment(program, address, comment);
                this.createLabel(program, address, "INODE_0x" + Integer.toHexString(inodeIndex + 1));
                address = address.add((long)superBlock.getS_inode_size());
                reader.setPointerIndex(address.getOffset());
                monitor.incrementProgress(1L);
                inodes[inodeIndex++] = inode;
            }
        }
        this.processInodes(program, reader, superBlock, inodes, monitor);
    }

    private void createLabel(Program program, Address address, String labelName) throws Exception {
        if (program.getMemory().contains(address)) {
            program.getSymbolTable().createLabel(address, labelName, SourceType.ANALYSIS);
            return;
        }
        if (this.program2 != null && this.program2.getMemory().contains(address)) {
            this.program2.getSymbolTable().createLabel(address, labelName, SourceType.ANALYSIS);
            return;
        }
        throw new RuntimeException("Cannot create label, neither program contains that address.");
    }

    private void processInodes(Program program, BinaryReader reader, Ext4SuperBlock superBlock, Ext4Inode[] inodes, TaskMonitor monitor) throws Exception {
        for (int i = 1; i < inodes.length; ++i) {
            monitor.checkCanceled();
            Ext4Inode inode = inodes[i];
            short mode = inode.getI_mode();
            if ((mode & 0x4000) != 0) {
                this.processDirectory(program, reader, superBlock, inode, monitor);
                continue;
            }
            if ((mode & 0x8000) == 0) continue;
            this.processFile(program, reader, superBlock, inode, monitor);
        }
    }

    private void processFile(Program program, BinaryReader reader, Ext4SuperBlock superBlock, Ext4Inode inode, TaskMonitor monitor) {
    }

    private void processDirectory(Program program, BinaryReader reader, Ext4SuperBlock superBlock, Ext4Inode inode, TaskMonitor monitor) throws Exception {
        boolean isDirEntry2;
        if ((inode.getI_flags() & 0x1000) != 0) {
            this.processHashTreeDirectory(program, reader, superBlock, inode, monitor);
        }
        boolean bl = isDirEntry2 = (superBlock.getS_feature_incompat() & 2) != 0;
        if ((inode.getI_flags() & 0x80000) != 0) {
            // empty if block
        }
    }

    private void processIBlock(Program program, BinaryReader reader, boolean isDirEntry2, Ext4IBlock i_block, TaskMonitor monitor) throws Exception {
        Ext4ExtentHeader header = i_block.getHeader();
        if (header.getEh_depth() == 0) {
            int numEntries = header.getEh_entries();
            List<Ext4Extent> entries = i_block.getExtentEntries();
            for (int i = 0; i < numEntries; ++i) {
                Ext4Extent extent = entries.get(i);
                long offset = extent.getExtentStartBlockNumber() * (long)this.blockSize;
                reader.setPointerIndex(offset);
                Address address = this.toAddr(program, offset);
                if (isDirEntry2) {
                    while (reader.getPointerIndex() - offset < (long)(extent.getEe_len() * this.blockSize)) {
                        Ext4DirEntry2 dirEnt2 = Ext4DirEntry2.read(reader);
                        DataType dataType = dirEnt2.toDataType();
                        this.createData(program, address, dataType);
                        String comment = "Name: " + dirEnt2.getName() + "\n";
                        if (dirEnt2.getFile_type() == 1) {
                            comment = comment + "Type: REGULAR FILE\n";
                        } else if (dirEnt2.getFile_type() == 2) {
                            comment = comment + "Type: DIRECTORY\n";
                        }
                        comment = comment + "Type: INODE_0x" + Integer.toHexString(dirEnt2.getInode());
                        this.setPlateComment(program, address, comment);
                        address = address.add((long)dataType.getLength());
                    }
                    continue;
                }
                throw new RuntimeException("TODO: support old style dir entry");
            }
        } else {
            int numEntries = header.getEh_entries();
            List<Ext4ExtentIdx> entries = i_block.getIndexEntries();
            for (int i = 0; i < numEntries; ++i) {
                monitor.checkCanceled();
                Ext4ExtentIdx extentIndex = entries.get(i);
                long lo = extentIndex.getEi_leaf_lo();
                long hi = extentIndex.getEi_leaf_hi();
                long physicalBlockOfNextLevel = hi << 32 | lo;
                long offset = physicalBlockOfNextLevel * (long)this.blockSize;
                Address address = this.toAddr(program, offset);
                this.setPlateComment(program, address, "TODO Ext4ExtentIdx / ext4_fsblk_t  ???");
                reader.setPointerIndex(offset);
                Ext4IBlock iBlock = new Ext4IBlock(reader, true);
                DataType dataType = iBlock.toDataType();
                this.createData(program, address, dataType);
                this.processIBlock(program, reader, isDirEntry2, iBlock, monitor);
            }
        }
    }

    private void processHashTreeDirectory(Program program, BinaryReader reader, Ext4SuperBlock superBlock, Ext4Inode inode, TaskMonitor monitor) {
    }

    private void createSuperBlockCopies(Program program, BinaryReader reader, int groupSize, int numGroups, boolean is64Bit, boolean isSparseSuper, TaskMonitor monitor) throws Exception {
        monitor.setMessage("Creating super block and group descriptor copies...");
        monitor.setMaximum((long)numGroups);
        for (int i = 1; i < numGroups; ++i) {
            monitor.checkCanceled();
            if (isSparseSuper && !this.isXpowerOfY(i, 3) && !this.isXpowerOfY(i, 5) && !this.isXpowerOfY(i, 7)) continue;
            int offset = groupSize * i;
            Address address = this.toAddr(program, offset);
            reader.setPointerIndex(offset);
            Ext4SuperBlock superBlock = new Ext4SuperBlock(reader);
            this.createData(program, address, superBlock.toDataType());
            this.setPlateComment(program, address, "SuperBlock Copy 0x" + Integer.toHexString(i));
            long groupDescOffset = ((long)offset & 0xFFFFFFFFL) + (long)this.blockSize;
            Address groupDescAddress = this.toAddr(program, groupDescOffset);
            reader.setPointerIndex(groupDescOffset);
            for (int j = 0; j < numGroups; ++j) {
                Ext4GroupDescriptor groupDesc = new Ext4GroupDescriptor(reader, is64Bit);
                DataType groupDescDataType = groupDesc.toDataType();
                this.createData(program, groupDescAddress, groupDescDataType);
                this.setPlateComment(program, groupDescAddress, "SuperBlock Copy 0x" + Integer.toHexString(i) + " Group 0x" + Integer.toHexString(j));
                groupDescAddress = groupDescAddress.add((long)groupDescDataType.getLength());
            }
            monitor.incrementProgress(1L);
        }
    }

    private boolean isXpowerOfY(int x, int y) {
        if (x == 0) {
            return false;
        }
        while (x % y == 0) {
            x /= y;
        }
        return x == 1;
    }

    private int calculateGroupSize(Ext4SuperBlock superBlock) {
        int logBlockSize = superBlock.getS_log_block_size();
        this.blockSize = (int)Math.pow(2.0, 10 + logBlockSize);
        int groupSize = this.blockSize * superBlock.getS_blocks_per_group();
        return groupSize;
    }

    private int getSuperBlockStart(BinaryReader reader) {
        try {
            int padding = -1;
            int padStart = 0;
            boolean isPadding = false;
            while (padStart < 1024) {
                if (!isPadding) {
                    padStart = (int)reader.getPointerIndex();
                }
                if ((padding = reader.readNextInt()) == 0) {
                    if (isPadding) {
                        return padStart + 1024;
                    }
                    isPadding = true;
                    continue;
                }
                isPadding = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }
}

