/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class TriageDataBlock
implements StructConverter {
    public static final String NAME = "_TRIAGE_DATA_BLOCK";
    private long address;
    private int offset;
    private int size;
    private DumpFileReader reader;
    private long index;
    private int psz;

    TriageDataBlock(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setAddress(this.reader.readNextPointer());
        this.setOffset(this.reader.readNextInt());
        this.setSize(this.reader.readNextInt());
    }

    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(POINTER, this.psz, "Address", null);
        struct.add(DWORD, 4, "Offset", null);
        struct.add(DWORD, 4, "Size", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public long getAddress() {
        return this.address;
    }

    public void setAddress(long address) {
        this.address = address;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

