/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class KldrDataTableEntry
implements StructConverter {
    public static final String NAME = "_KLDR_DATA_TABLE_ENTRY";
    private long List_Flink;
    private long List_Blink;
    private long NonPagedDebugInfo;
    private long DllBase;
    private long EntryPoint;
    private int SizeOfImage;
    private long FullDllName;
    private long BaseDllName;
    private int Flags;
    private short LoadCount;
    private int CheckSum;
    private int TimeDateStamp;
    private DumpFileReader reader;
    private long index;
    private int psz;

    KldrDataTableEntry(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.getIndex());
        this.setList_Flink(this.reader.readNextPointer());
        this.setList_Blink(this.reader.readNextPointer());
        this.reader.readNextPointer();
        this.reader.readNextPointer();
        this.reader.readNextPointer();
        this.setNonPagedDebugInfo(this.reader.readNextPointer());
        this.setDllBase(this.reader.readNextPointer());
        this.setEntryPoint(this.reader.readNextPointer());
        this.setSizeOfImage(this.reader.readNextInt());
        this.reader.readNextInt();
        this.reader.readNextPointer();
        this.setFullDllName(this.reader.readNextPointer());
        this.reader.readNextPointer();
        this.setBaseDllName(this.reader.readNextPointer());
        this.setFlags(this.reader.readNextInt());
        this.setLoadCount(this.reader.readNextShort());
        this.reader.readNextShort();
        this.reader.readNextPointer();
        this.setCheckSum(this.reader.readNextInt());
        this.reader.readNextInt();
        this.setTimeDateStamp(this.reader.readNextInt());
        this.reader.readNextInt();
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(POINTER, this.psz, "List.Flink", null);
        struct.add(POINTER, this.psz, "List.Blink", null);
        struct.add(POINTER, this.psz, "__Undefined1", null);
        struct.add(POINTER, this.psz, "__Undefined2", null);
        struct.add(POINTER, this.psz, "__Undefined3", null);
        struct.add(POINTER, this.psz, "NonPagedDebugInfo", null);
        struct.add(POINTER, this.psz, "DllBase", null);
        struct.add(POINTER, this.psz, "EntryPoint", null);
        struct.add(DWORD, 4, "SizeOfImage", null);
        struct.add(DWORD, 4, "", null);
        struct.add(POINTER, this.psz, "FullDllNameLen", null);
        struct.add(POINTER, this.psz, "FullDllName", null);
        struct.add(POINTER, this.psz, "BaseDllNameLen", null);
        struct.add(POINTER, this.psz, "BaseDllName", null);
        struct.add(DWORD, 4, "Flags", null);
        struct.add(WORD, 2, "LoadCount", null);
        struct.add(WORD, 2, "__Undefined5", null);
        struct.add(POINTER, this.psz, "__Undefined6", null);
        struct.add(DWORD, 4, "CheckSum", null);
        struct.add(DWORD, 4, "__padding1", null);
        struct.add(DWORD, 4, "TimeDateStamp", null);
        struct.add(DWORD, 4, "__padding2", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public long getList_Flink() {
        return this.List_Flink;
    }

    public void setList_Flink(long list_Flink) {
        this.List_Flink = list_Flink;
    }

    public long getList_Blink() {
        return this.List_Blink;
    }

    public void setList_Blink(long list_Blink) {
        this.List_Blink = list_Blink;
    }

    public long getDllBase() {
        return this.DllBase;
    }

    public void setDllBase(long dllBase) {
        this.DllBase = dllBase;
    }

    public long getEntryPoint() {
        return this.EntryPoint;
    }

    public void setEntryPoint(long entryPoint) {
        this.EntryPoint = entryPoint;
    }

    public int getSizeOfImage() {
        return this.SizeOfImage;
    }

    public void setSizeOfImage(int sizeOfImage) {
        this.SizeOfImage = sizeOfImage;
    }

    public long getFullDllName() {
        return this.FullDllName;
    }

    public void setFullDllName(long fullDllName) {
        this.FullDllName = fullDllName;
    }

    public long getBaseDllName() {
        return this.BaseDllName;
    }

    public void setBaseDllName(long baseDllName) {
        this.BaseDllName = baseDllName;
    }

    public int getFlags() {
        return this.Flags;
    }

    public void setFlags(int flags) {
        this.Flags = flags;
    }

    public short getLoadCount() {
        return this.LoadCount;
    }

    public void setLoadCount(short loadCount) {
        this.LoadCount = loadCount;
    }

    public int getCheckSum() {
        return this.CheckSum;
    }

    public void setCheckSum(int checkSum) {
        this.CheckSum = checkSum;
    }

    public int getTimeDateStamp() {
        return this.TimeDateStamp;
    }

    public void setTimeDateStamp(int timeDateStamp) {
        this.TimeDateStamp = timeDateStamp;
    }

    public long getNonPagedDebugInfo() {
        return this.NonPagedDebugInfo;
    }

    public void setNonPagedDebugInfo(long nonPagedDebugInfo) {
        this.NonPagedDebugInfo = nonPagedDebugInfo;
    }

    public String getName() {
        return "bob";
    }

    public long getIndex() {
        return this.index;
    }
}

