/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer32DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class UnloadedModule
implements StructConverter {
    public static final String NAME = "MINIDUMP_UNLOADED_MODULE";
    private long baseOfImage;
    private int sizeOfImage;
    private int checkSum;
    private int timeDateStamp;
    private int moduleNameRVA;
    private DumpFileReader reader;
    private long index;

    UnloadedModule(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setBaseOfImage(this.reader.readNextLong());
        this.setSizeOfImage(this.reader.readNextInt());
        this.setCheckSum(this.reader.readNextInt());
        this.setTimeDateStamp(this.reader.readNextInt());
        this.setModuleNameRVA(this.reader.readNextInt());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "BaseOfImage", null);
        struct.add(DWORD, 4, "SizeOfImage", null);
        struct.add(DWORD, 4, "CheckSum", null);
        struct.add(DWORD, 4, "TimeDateStamp", null);
        struct.add((DataType)Pointer32DataType.dataType, 4, "ModuleNameRVA", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public long getBaseOfImage() {
        return this.baseOfImage;
    }

    public void setBaseOfImage(long baseOfImage) {
        this.baseOfImage = baseOfImage;
    }

    public int getSizeOfImage() {
        return this.sizeOfImage;
    }

    public void setSizeOfImage(int sizeOfImage) {
        this.sizeOfImage = sizeOfImage;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }

    public int getTimeDateStamp() {
        return this.timeDateStamp;
    }

    public void setTimeDateStamp(int timeDateStamp) {
        this.timeDateStamp = timeDateStamp;
    }

    public int getModuleNameRVA() {
        return this.moduleNameRVA;
    }

    public void setModuleNameRVA(int moduleNameRVA) {
        this.moduleNameRVA = moduleNameRVA;
    }
}

