/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.impl;

import java.util.Date;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IOutArchive;
import net.sf.sevenzipjbinding.IOutItem7z;
import net.sf.sevenzipjbinding.IOutItemBZip2;
import net.sf.sevenzipjbinding.IOutItemBase;
import net.sf.sevenzipjbinding.IOutItemGZip;
import net.sf.sevenzipjbinding.IOutItemTar;
import net.sf.sevenzipjbinding.IOutItemZip;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.OutItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutItemFactory<T extends IOutItemBase> {
    private static final Long ZERO = 0L;
    private int index;
    private IOutArchive<?> outArchive;

    OutItemFactory(IOutArchive<?> iOutArchive, int n) {
        this.outArchive = iOutArchive;
        this.index = n;
    }

    public T createOutItem() {
        return (T)this.createOutItemIntern();
    }

    private OutItem createOutItemIntern() {
        OutItem outItem = new OutItem(this.outArchive, this.index);
        this.fillDefaultValues(outItem);
        return outItem;
    }

    private void fillDefaultValues(OutItem outItem) {
        if (this.outArchive.getConnectedInArchive() != null) {
            outItem.setUpdateOldArchiveItemIndex(-1);
            outItem.setUpdateIsNewData(Boolean.TRUE);
            outItem.setUpdateIsNewProperties(Boolean.TRUE);
        }
        outItem.setDataSize(ZERO);
        outItem.setPropertyLastModificationTime(new Date());
        switch (outItem.getArchiveFormat()) {
            case SEVEN_ZIP: {
                this.fillDefaultValues7z(outItem);
                break;
            }
            case ZIP: {
                this.fillDefaultValuesZip(outItem);
                break;
            }
            case BZIP2: {
                this.fillDefaultValuesBZip2(outItem);
                break;
            }
            case GZIP: {
                this.fillDefaultValuesGZip(outItem);
                break;
            }
            case TAR: {
                this.fillDefaultValuesTar(outItem);
                break;
            }
            default: {
                throw new RuntimeException("No default values strategy for the archive format '" + (Object)((Object)outItem.getArchiveFormat()) + "'");
            }
        }
    }

    private void fillDefaultValues7z(IOutItem7z iOutItem7z) {
        iOutItem7z.setPropertyIsAnti(Boolean.FALSE);
        iOutItem7z.setPropertyIsDir(Boolean.FALSE);
        iOutItem7z.setPropertyAttributes(0);
    }

    private void fillDefaultValuesZip(IOutItemZip iOutItemZip) {
        iOutItemZip.setPropertyIsDir(Boolean.FALSE);
        iOutItemZip.setPropertyAttributes(0);
    }

    private void fillDefaultValuesBZip2(IOutItemBZip2 iOutItemBZip2) {
    }

    private void fillDefaultValuesGZip(IOutItemGZip iOutItemGZip) {
    }

    private void fillDefaultValuesTar(IOutItemTar iOutItemTar) {
        iOutItemTar.setPropertyIsDir(Boolean.FALSE);
    }

    public T createOutItem(int n) throws SevenZipException {
        IInArchive iInArchive = this.outArchive.getConnectedInArchive();
        if (iInArchive == null) {
            throw new RuntimeException("Not an update operation");
        }
        OutItem outItem = this.createOutItemIntern();
        outItem.setUpdateOldArchiveItemIndex(n);
        outItem.setUpdateIsNewData(Boolean.FALSE);
        outItem.setUpdateIsNewProperties(Boolean.FALSE);
        return (T)outItem;
    }

    public T createOutItemAndCloneProperties(int n) throws SevenZipException {
        IInArchive iInArchive = this.outArchive.getConnectedInArchive();
        if (iInArchive == null) {
            throw new RuntimeException("Not an update operation");
        }
        OutItem outItem = this.createOutItemIntern();
        outItem.setUpdateOldArchiveItemIndex(n);
        outItem.setUpdateIsNewData(Boolean.FALSE);
        outItem.setUpdateIsNewProperties(Boolean.TRUE);
        outItem.setPropertyPath((String)iInArchive.getProperty(n, PropID.PATH));
        outItem.setPropertyAttributes((Integer)iInArchive.getProperty(n, PropID.ATTRIBUTES));
        outItem.setPropertyPosixAttributes((Integer)iInArchive.getProperty(n, PropID.POSIX_ATTRIB));
        outItem.setPropertyUser((String)iInArchive.getProperty(n, PropID.USER));
        outItem.setPropertyGroup((String)iInArchive.getProperty(n, PropID.GROUP));
        outItem.setPropertyCreationTime((Date)iInArchive.getProperty(n, PropID.CREATION_TIME));
        outItem.setPropertyLastModificationTime((Date)iInArchive.getProperty(n, PropID.LAST_MODIFICATION_TIME));
        outItem.setPropertyLastAccessTime((Date)iInArchive.getProperty(n, PropID.LAST_ACCESS_TIME));
        outItem.setPropertyIsAnti((Boolean)iInArchive.getProperty(n, PropID.IS_ANTI));
        outItem.setPropertyIsDir((Boolean)iInArchive.getProperty(n, PropID.IS_FOLDER));
        return (T)outItem;
    }
}

