/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.SeparatedCodeFromCompilerSupportMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.BlockCommentsManager;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.EndSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.SymbolGroup;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;
import java.util.List;

public class SeparatedCodeSymbolApplier
extends MsSymbolApplier {
    private SeparatedCodeFromCompilerSupportMsSymbol symbol;
    private String craftedName;
    private Address specifiedAddress;
    private BlockCommentsManager comments;
    private int symbolBlockNestingLevel;
    private Address currentBlockAddress;
    private List<MsSymbolApplier> allAppliers = new ArrayList<MsSymbolApplier>();

    private static SymbolGroup.AbstractMsSymbolIterator validateSymbol(SymbolGroup.AbstractMsSymbolIterator iter) {
        if (!(iter.peek() instanceof SeparatedCodeFromCompilerSupportMsSymbol)) {
            throw new IllegalArgumentException("Not a SeparatedCodeFromCompilerSupportMsSymbol");
        }
        return iter;
    }

    public SeparatedCodeSymbolApplier(DefaultPdbApplicator applicator, SymbolGroup.AbstractMsSymbolIterator iter) throws CancelledException {
        super(applicator, SeparatedCodeSymbolApplier.validateSymbol(iter));
        this.symbol = (SeparatedCodeFromCompilerSupportMsSymbol)iter.next();
        this.specifiedAddress = applicator.getAddress(this.symbol);
        this.craftedName = String.format("CompilerSeparatedCode%s", this.specifiedAddress);
        this.symbolBlockNestingLevel = 0;
        this.comments = new BlockCommentsManager();
        this.currentBlockAddress = null;
        this.manageBlockNesting(this);
        while (this.notDone()) {
            applicator.checkCanceled();
            MsSymbolApplier applier = applicator.getSymbolApplier(iter);
            if (!(applier instanceof EndSymbolApplier)) {
                Msg.info((Object)this, (Object)("Unexpected applier in " + this.getClass().getSimpleName() + ": " + applier.getClass().getSimpleName()));
            }
            this.allAppliers.add(applier);
            applier.manageBlockNesting(this);
        }
    }

    @Override
    void manageBlockNesting(MsSymbolApplier applierParam) {
        this.beginBlock(this.specifiedAddress);
    }

    @Override
    void applyTo(MsSymbolApplier applyToApplier) {
    }

    @Override
    void apply() throws PdbException, CancelledException {
        if (this.applicator.isInvalidAddress(this.currentBlockAddress, this.craftedName)) {
            return;
        }
        this.setComments(false);
    }

    private void setComments(boolean enabled) {
        if (enabled) {
            String existingComment = this.applicator.getProgram().getListing().getComment(1, this.specifiedAddress);
            String p = "*************************************************************\n";
            String newComment = String.format(p + "* Separated code (from the compiler): %s - %s *\n" + p, this.specifiedAddress.toString(), this.specifiedAddress.add(this.symbol.getBlockLength() - 1L).toString());
            String comment = existingComment == null ? newComment : existingComment + "\n" + newComment;
            SetCommentCmd.createComment((Program)this.applicator.getProgram(), (Address)this.specifiedAddress, (String)comment, (int)1);
        }
    }

    private boolean notDone() {
        return this.symbolBlockNestingLevel > 0 && this.iter.hasNext();
    }

    void endBlock() {
        if (--this.symbolBlockNestingLevel < 0) {
            this.applicator.appendLogMsg("Block Nesting went negative at " + this.specifiedAddress);
        }
    }

    void beginBlock(Address startAddress) {
        this.currentBlockAddress = startAddress;
        ++this.symbolBlockNestingLevel;
    }
}

