/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractModifierMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsTypeApplier;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import java.math.BigInteger;

public class ModifierTypeApplier
extends MsTypeApplier {
    private MsTypeApplier modifiedTypeApplier = null;

    public ModifierTypeApplier(DefaultPdbApplicator applicator, AbstractModifierMsType msType) {
        super(applicator, msType);
    }

    @Override
    void deferredApply() throws PdbException, CancelledException {
    }

    @Override
    BigInteger getSize() {
        if (this.modifiedTypeApplier == null) {
            return BigInteger.ZERO;
        }
        return this.modifiedTypeApplier.getSize();
    }

    @Override
    void apply() throws PdbException, CancelledException {
        this.applyOrDeferForDependencies();
    }

    private void applyOrDeferForDependencies() {
        AbstractModifierMsType type = (AbstractModifierMsType)this.msType;
        this.applyModifierMsType(type);
        MsTypeApplier modifiedApplier = this.applicator.getTypeApplier(type.getModifiedRecordNumber());
        if (modifiedApplier.isDeferred()) {
            this.applicator.addApplierDependency(this, modifiedApplier);
            this.setDeferred();
        }
    }

    @Override
    DataType getDataType() {
        return this.modifiedTypeApplier.getDataType();
    }

    private DataType applyModifierMsType(AbstractModifierMsType type) {
        this.modifiedTypeApplier = this.applicator.getTypeApplier(type.getModifiedRecordNumber());
        return this.modifiedTypeApplier.getDataType();
    }

    @Override
    DataType getCycleBreakType() {
        if (this.modifiedTypeApplier == null) {
            return null;
        }
        return this.modifiedTypeApplier.getCycleBreakType();
    }

    MsTypeApplier getModifiedTypeApplier() {
        return this.modifiedTypeApplier;
    }
}

