/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public class MemberFunctionIdMsType
extends AbstractMsType {
    public static final int PDB_ID = 5634;
    private RecordNumber parentTypeRecordNumber;
    private RecordNumber functionTypeRecordNumber;
    private String name;

    public MemberFunctionIdMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.parentTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.functionTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.name = reader.parseString(pdb, StringParseType.StringNt);
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 5634;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.pdb.getTypeRecord(this.parentTypeRecordNumber));
        myBuilder.append("::");
        myBuilder.append(this.name);
        this.pdb.getTypeRecord(this.functionTypeRecordNumber).emit(myBuilder, AbstractMsType.Bind.NONE);
        builder.append("MemberFunctionId for: ");
        builder.append((CharSequence)myBuilder);
    }
}

