/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractParsableItem;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;

public class ProcedureFlags
extends AbstractParsableItem {
    private int flagByte;

    public ProcedureFlags(PdbByteReader reader) throws PdbException {
        this.flagByte = reader.parseUnsignedByteVal();
    }

    @Override
    public void emit(StringBuilder builder) {
        DelimiterState ds = new DelimiterState("", ", ");
        builder.append("Flags: ");
        builder.append(ds.out(this.hasFramePointerPresent(), "Frame Ptr Present"));
        builder.append(ds.out(this.hasInterruptReturn(), "Interrupt"));
        builder.append(ds.out(this.hasFarReturn(), "FAR"));
        builder.append(ds.out(this.doesNotReturn(), "Never Return"));
        builder.append(ds.out(this.labelNotReached(), "Not Reached"));
        builder.append(ds.out(this.hasCustomCallingConvention(), "Custom Calling Convention"));
        builder.append(ds.out(this.markedAsNoInline(), "Do Not Inline"));
        builder.append(ds.out(this.hasDebugInformationForOptimizedCode(), "Optimized Debug Info"));
    }

    public boolean hasFramePointerPresent() {
        return (this.flagByte & 1) == 1;
    }

    public boolean hasInterruptReturn() {
        return (this.flagByte & 2) == 2;
    }

    public boolean hasFarReturn() {
        return (this.flagByte & 4) == 4;
    }

    public boolean doesNotReturn() {
        return (this.flagByte & 8) == 8;
    }

    public boolean labelNotReached() {
        return (this.flagByte & 0x10) == 16;
    }

    public boolean hasCustomCallingConvention() {
        return (this.flagByte & 0x20) == 32;
    }

    public boolean markedAsNoInline() {
        return (this.flagByte & 0x40) == 64;
    }

    public boolean hasDebugInformationForOptimizedCode() {
        return (this.flagByte & 0x80) == 128;
    }
}

