/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.msf;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderOptions;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.AbstractMsf;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfDirectoryStream200;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfFreePageMap200;
import ghidra.app.util.bin.format.pdb2.pdbreader.msf.MsfStreamTable200;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class Msf200
extends AbstractMsf {
    private static final int PAGE_NUMBER_SIZE = 2;
    private static final byte[] IDENTIFICATION = "Microsoft C/C++ program database 2.00\r\n\u001aJG".getBytes();
    private static final int IDENTIFICATION_PADDING = 2;
    private static final int PAGE_SIZE_OFFSET = IDENTIFICATION.length + 2;
    static final int NUM_REQUIRED_DETECTION_BYTES_200 = PAGE_SIZE_OFFSET + 4;

    public Msf200(RandomAccessFile file, String filename, TaskMonitor monitor, PdbReaderOptions pdbOptions) throws IOException, PdbException {
        super(file, filename, monitor, pdbOptions);
    }

    static boolean detected(RandomAccessFile file) throws IOException {
        byte[] bytes = new byte[IDENTIFICATION.length];
        file.seek(0L);
        file.read(bytes, 0, IDENTIFICATION.length);
        return Arrays.equals(bytes, IDENTIFICATION);
    }

    @Override
    public void create() {
        this.streamTable = new MsfStreamTable200(this);
        this.freePageMap = new MsfFreePageMap200(this);
        this.directoryStream = new MsfDirectoryStream200(this);
    }

    @Override
    public void configureParameters() throws PdbException {
        switch (this.pageSize) {
            case 1024: {
                this.log2PageSize = 10;
                this.freePageMapNumSequentialPage = 8;
                break;
            }
            case 2048: {
                this.log2PageSize = 11;
                this.freePageMapNumSequentialPage = 4;
                break;
            }
            case 4096: {
                this.log2PageSize = 12;
                this.freePageMapNumSequentialPage = 1;
                break;
            }
            default: {
                throw new PdbException(String.format("Unknown page size: 0X%08X", this.pageSize));
            }
        }
        this.pageSizeModMask = this.pageSize - 1;
    }

    @Override
    public void parseFreePageMapPageNumber(PdbByteReader reader) throws PdbException {
        this.currentFreePageMapFirstPageNumber = reader.parseShort();
    }

    @Override
    public void parseCurrentNumPages(PdbByteReader reader) throws PdbException {
        this.numPages = reader.parseShort();
    }

    @Override
    public int getPageNumberSize() {
        return 2;
    }

    @Override
    public byte[] getIdentification() {
        return IDENTIFICATION;
    }

    @Override
    public int getPageSizeOffset() {
        return PAGE_SIZE_OFFSET;
    }
}

