/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.pty.windows;

import agent.gdb.pty.windows.Handle;
import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;

public class Pipe {
    private final Handle readHandle;
    private final Handle writeHandle;

    public static Pipe createPipe() {
        WinNT.HANDLEByReference pRead = new WinNT.HANDLEByReference();
        WinNT.HANDLEByReference pWrite = new WinNT.HANDLEByReference();
        if (!Kernel32.INSTANCE.CreatePipe(pRead, pWrite, new WinBase.SECURITY_ATTRIBUTES(), 0)) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        return new Pipe(new Handle(pRead.getValue()), new Handle(pWrite.getValue()));
    }

    private Pipe(Handle read, Handle write) {
        this.readHandle = read;
        this.writeHandle = write;
    }

    public Handle getReadHandle() {
        return this.readHandle;
    }

    public Handle getWriteHandle() {
        return this.writeHandle;
    }

    public void close() throws Exception {
        this.writeHandle.close();
        this.readHandle.close();
    }
}

