@ECHO OFF

Setlocal EnableDelayedExpansion

set EnableVR=
set CmdLine=%*
set PauseOnExit=True
pushd "%~dp0"
call :RunningAsAdmin || goto End
call :ParseArguments %CmdLine% || goto End
call :EnableOverlayUninstall || goto End
call :InstallManifests || goto End
echo SUCCESS: Installation completed.
:End
popd
if "%PauseOnExit%" == "True" (
    pause
)
exit /b

REM ********* RunningAsAdmin *********
:RunningAsAdmin
net session >nul 2>&1
if !ERRORLEVEL! NEQ 0 (
    echo FAILED: Please run this script as admin.
    exit /b 1
)
exit /b 0

REM ********* ParseArguments *********
:ParseArguments
:loop
if not "%1"=="" (
    if "%1"=="-vr" (
        set EnableVR=True
    )
    if "%1"=="-nopause" (
        set PauseOnExit=False
    )
    shift
    goto :loop
)
exit /b 0

REM ********* EnableOverlayUninstall *********
:EnableOverlayUninstall
for /f "delims=" %%a in ('dir /s /b EnableVROverlay*.exe') do set "EnableOverlayPath=%%a"

if defined EnableOverlayPath (
    "%EnableOverlayPath%" -uninstall
    if !ERRORLEVEL! NEQ 0 (
        echo FAILED: Could not remove previous binaries.
        exit /b 1
    )
) else (
    echo FAILED: Could not find EnableVROverlay executable.
    exit /b 1
)

exit /b 0

REM ********* InstallManifests *********
:InstallManifests

if "%EnableVR%" == "True" (
    REM echo "Installing Oculus VR events manifest"
    reg query "HKLM\SOFTWARE\Wow6432Node\Oculus VR, LLC\Oculus" >nul 2>nul
    if !ERRORLEVEL! EQU 0 (
        pushd etw_oculus 
           call oculus_install.bat >nul 2>nul
        popd
        
    ) else (
        echo WARNING: FCAT VR Capture should be installed after Oculus runtime installation if Oculus support is desired
    )	
) else (
    REM echo Installing NV display events manifest
    pushd etw_nv 
        call nvinstall.cmd > nul
    popd
)

pushd etw_fcat
    call htcvive_install.bat >nul 2>nul
popd

wevtutil ep|findstr NVFT-ETW-OPENVR >nul 2>nul
if !ERRORLEVEL! NEQ 0 (
    echo FAILED: FrameView ETW events not installed.
    exit /b 1
)

if "%EnableVR%" == "True" (
    wevtutil ep|findstr OVR-SDK-LibOVR >nul 2>nul
    if !ERRORLEVEL! NEQ 0 (
        echo FAILED: Oculus ETW events not installed.
        exit /b 1
    )
) else (
    wevtutil ep|findstr NVIDIA-DD-External >nul 2>nul
    if !ERRORLEVEL! NEQ 0 (
        echo FAILED: NVIDIA ETW events not installed.
        exit /b 1
    )
)

exit /b 0

