@echo off
@setlocal enableextensions

call :RunningAsAdmin || goto End
call :EnableOverlayUninstall || goto End
call :UninstallManifests || goto End
echo SUCCESS: Uninstalled.

:RunningAsAdmin
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo FAILED: Please run this script as admin.
    exit /b 1
)
exit /b 0

:EnableOverlayUninstall
for /f "delims=" %%a in ('dir /s /b EnableVROverlay*.exe') do set "EnableOverlayPath=%%a"
if defined EnableOverlayPath (
    %EnableOverlayPath% -uninstall
    if %errorlevel% neq 0 (
        echo FAILED: Could not remove previous binaries.
        exit /b 1
    )
) else (
    echo FAILED: Could not find EnableVROverlay executable.
    exit /b 1
)
exit /b 0

REM ********* UninstallManifests *********
:UninstallManifests

pushd etw_fcat
    call UninstallFrameViewKMD.cmd >nul 2>nul
popd

exit /b 0

:End
pause
