@ECHO OFF

:: ModMenu.bat
:: ver 2.20

IF %1!==! goto BadStart

SET WinDrive=%1
SET WindoDir=%2
FOR %%! in (%3) DO SET LOC8=%%!
Set debug=N
IF EXIST "%LOC8%\markers\go_debug.txt" Set debug=Y

:Initialise
If Exist "%LOC8%\markers\@_WaitBT.tra" goto WaitBoot

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:DoMenu ======== Modules Menu
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: modules need to be strictly numbered in order to work with the select modules function
:: don't use names

:Inst01 ================= System Stability Hotfixes
SET TRACK=Inst01
SET NEXT1=Inst02
SET FILES=HFStable
goto GoModule

:Inst02 ================= Recommended Tweaks
SET TRACK=Inst02
SET NEXT1=Inst03
SET FILES=Tweaks
goto GoModule

:Inst03 ================= Essential System Components
SET TRACK=Inst03
SET NEXT1=Inst04
SET FILES=EssComp
goto GoModule

:Inst04 ================= Microsoft Data Access & Jet Engine
SET TRACK=Inst04
SET NEXT1=Inst05
SET FILES=MdacJet
goto GoModule

:Inst05 ================= Internet Explorer
SET TRACK=Inst05
SET NEXT1=Inst06
SET FILES=IExplore
goto GoModule

:Inst06 ================= Windows Media Player
SET TRACK=Inst06
SET NEXT1=Inst07
SET FILES=WinMP9
goto GoModule

:Inst07 ================= DirectX 9.0c
SET TRACK=Inst07
SET NEXT1=Inst08
SET FILES=DirectX
goto GoModule

:Inst08 ================= Critical Security Hotfixes
SET TRACK=Inst08
SET NEXT1=Inst09
SET FILES=HFSecure
goto GoModule

:Inst09 ================= Recommended System Updates
SET TRACK=Inst09
SET NEXT1=Inst10
SET FILES=HFSystem
goto GoModule

:Inst10 ================= Other Recommended System Hotfixes
SET TRACK=Inst10
SET NEXT1=Inst11
SET FILES=HFOthRec
goto GoModule

:Inst11 ================= Rare and Obscure System Hotfixes
SET TRACK=Inst11
SET NEXT1=Inst13
SET FILES=HFObscur
goto GoModule

:: this is disabled for now
:Inst12 ================= Laptop Computer Hotfixes
SET TRACK=Inst12
SET NEXT1=Inst13
SET FILES=HFLaptop
goto GoModule

:Inst13 ================= Essential 3rd Party Apps
SET TRACK=Inst13
SET NEXT1=Inst14
SET FILES=3rdPart
goto GoModule

:Inst14 ================= Windows Optional Components
SET TRACK=Inst14
SET NEXT1=Inst15
SET FILES=Compnts
goto GoModule

:Inst15 ================= Visual Basic Runtimes
SET TRACK=Inst15
SET NEXT1=Inst16
SET FILES=VBRun
goto GoModule

:Inst16 ================= Unofficial Windows Explorer Update
SET TRACK=Inst16
SET NEXT1=HF_END
SET FILES=Win982ME
goto GoModule

:HF_END ============== THE END =============

:: Windows Update false alarms fix routines
:: there are 2 problematic installs
:: see if the update was installed, then apply the reg patch if it is.
FOR %%! in (q273017 q269388 UCrypt9x) DO IF EXIST "%LOC8%\markers\%%!.txt" IF EXIST "%LOC8%\files\RegInfo\%%!.reg" REGEDIT /s "%LOC8%\files\RegInfo\%%!.reg"

:: record how long it took to run either the installation and report time.
"%LOC8%\bin\ASET" NHour := HOUR
"%LOC8%\bin\ASET" NMin := MINUTE
"%LOC8%\bin\ASET" NSec := SECOND
FOR %%_ in (0 1 2 3 4 5 6 7 8 9) DO IF %NHour%==%%_ SET NHour=0%NHour%
FOR %%_ in (0 1 2 3 4 5 6 7 8 9) DO IF %NMin%==%%_ SET NMin=0%NMin%
FOR %%_ in (0 1 2 3 4 5 6 7 8 9) DO IF %NSec%==%%_ SET NSec=0%NSec%
SET TYME=%NHour%:%NMin%:%NSec%
"%LOC8%\bin\ASET" NSec := SECOND
"%LOC8%\bin\ASET" NMin := MINUTE
"%LOC8%\bin\ASET" NHour := HOUR
:: load the start times and do the math

IF NOT EXIST "%LOC8%\markers\StartTim.TRA" goto NOTIME
"%LOC8%\bin\NSET" NHourOld=$1 < "%LOC8%\markers\StartTim.TRA"
"%LOC8%\bin\NSET" NMinOld=$2 < "%LOC8%\markers\StartTim.TRA"
"%LOC8%\bin\NSET" NSecOld=$3 < "%LOC8%\markers\StartTim.TRA"
"%LOC8%\bin\ASET" TVarA := %NHour%-%NHourOld%
"%LOC8%\bin\ASET" TVarB := AIF(%TVarA%,'n','e','p')
IF %TVarB%!==n! "%LOC8%\bin\ASET" NHour := %NHour%+24
"%LOC8%\bin\ASET" TVarA := %NMin%-%NMinOld%
"%LOC8%\bin\ASET" TVarB := AIF(%TVarA%,'n','e','p')
IF %TVarB%!==n! "%LOC8%\bin\ASET" NMin := %NMin%+60
IF %TVarB%!==n! "%LOC8%\bin\ASET" NHour := %NHour%-1
"%LOC8%\bin\ASET" TVarA := %NSec%-%NSecOld%
"%LOC8%\bin\ASET" TVarB := AIF(%TVarA%,'n','e','p')
IF %TVarB%!==n! "%LOC8%\bin\ASET" NSec := %NSec%+60
IF %TVarB%!==n! "%LOC8%\bin\ASET" NMin := %NMin%-1
"%LOC8%\bin\ASET" NHour := %NHour%-%NHourOld%
"%LOC8%\bin\ASET" NMin := %NMin%-%NMinOld%
"%LOC8%\bin\ASET" NSec := %NSec%-%NSecOld%
SET TempVar=
IF NOT %NHour%!==0! IF %NHour%!==1! SET TempVar=%NHour% hour 
IF NOT %NHour%!==0! IF NOT %NHour%!==1! SET TempVar=%NHour% hours 
IF NOT %NHour%!==0! IF %NMin%!==0! SET TempVar=%TempVar%and 
IF NOT %NMin%!==0! IF %NMin%!==1! SET TempVar=%TempVar%%NMin% minute and 
IF NOT %NMin%!==0! IF NOT %NMin%!==1! SET TempVar=%TempVar%%NMin% minutes and 
IF %NSec%!==1! SET TempVar=%TempVar%%NSec% second
IF NOT %NSec%!==1! SET TempVar=%TempVar%%NSec% seconds

:CLEANUP
:: cleanup routines
IF NOT EXIST "%WinDrive%\Run-Mod.bat" goto GO_FILE3
IF NOT EXIST "%WINDIR%\WININIT.INI" goto GO_FILE1
TYPE "%WINDIR%\WININIT.INI" > "%TEMP%\@@tmp.txt"
"%LOC8%\bin\NSET" /L1 tvar=$0 < "%TEMP%\@@tmp.txt"
IF %tvar%!==[Rename]! goto GO_FILE2

:GO_FILE1
ECHO [Rename]>%WINDIR%\WININIT.INI
:GO_FILE2
IF EXIST "%TEMP%\@@tmp.txt" DEL "%TEMP%\@@tmp.txt" >nul
ECHO NUL=%WinDrive%\Run-Mod.bat>>%WINDIR%\WININIT.INI

:GO_FILE3
IF EXIST "%LOC8%\markers\@_Report.tra" goto MkRepEnd
goto PatchEND

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::  run modules
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:GoModule

IF EXIST "%LOC8%\markers\@_%TRACK%.tra" goto %NEXT1%
IF %debug%!==Y! goto Go_Debug

:GoModul2

:: check the bat file exists
IF NOT EXIST "%LOC8%\code\Modules\%FILES%.bat" goto NOBAT
:: Request types - install check report
:: Module choice - fullup

:: %COMSPEC% /E:1024 /C "%LOC8%\code\Run-Mod.bat" %FILES% %WINDRIVE% %WindoDir% %LOC8% %TRACK% fullup
:: %COMSPEC% /E:2048 /C "%LOC8%\code\modules\%FILES%.bat" %WINDRIVE% %WindoDir% "%LOC8%" %TRACK% fullup
CALL "%LOC8%\code\modules\%FILES%.bat" %WINDRIVE% %WindoDir% "%LOC8%" %TRACK%
goto END

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: End of routines
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:PatchEND
SET NEXT1=PatchEN2
IF %debug%!==Y! goto EndDebug

:PatchEN2
:: import the number of installations
IF NOT EXIST "%LOC8%\markers\@_NumIns.TRA" goto NONUMS
"%LOC8%\bin\NSET" NumIns=$0 < "%LOC8%\markers\@_NumIns.TRA"

:PatchENN
:: write a log file message
echo. %TYME% -- Auto-Patcher has finished running.>> "%LOC8%\logs\I_Result.Log"
echo. The number of installations in this patching session: %NumIns%>> "%LOC8%\logs\I_Result.Log"
echo. The entire patching process took %TempVar% to run.>> "%LOC8%\logs\I_Result.Log"
echo. Please visit the Manual Installs directory to install updates that can't be automatically installed.>> "%LOC8%\logs\I_Result.Log"
echo.  - there is an option available from the main menu that will open it for you.>> "%LOC8%\logs\I_Result.Log"
Echo +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++>> "%LOC8%\logs\I_Result.Log"
cls
echo.
echo.
echo.
echo.     All done!!
echo.
echo.   Auto-Patcher finished patching at %TYME%
echo.  The number of installations in this patching session: %NumIns%
echo. The entire patching process took %TempVar% to run.
echo.
echo.
echo.     Don't forget... if you have any comments, suggestions,
echo.    or bugs to report... please visit this project's homepage!
echo.   There is an automatic menu option available from the main menu
echo.    that will take you straight there. Thank you in advance!
echo.
echo.
echo.           Press any key to exit the program
echo.
echo.
echo.   [ CTRL-C will exit out without opening any log or debug files ]
SET NEXT1=PatchEN3
goto DELMARKS

:PatchEN3
PAUSE >nul
IF %debug%!==Y! "%LOC8%\bin\NOTEPAD" "%LOC8%\logs\debug.txt"
"%LOC8%\bin\NOTEPAD" "%LOC8%\logs\I_Result.Log"
goto END
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:MkRepEnd
SET NEXT1=MkRepEn2
IF %debug%!==Y! goto EndDebug

:MkRepEn2
"%LOC8%\bin\NSET" NumIns=$0 < "%LOC8%\markers\@_NumIns.REP"
IF EXIST "%LOC8%\markers\FoundUp_.txt" Echo. (no updates are missing)>> "%LOC8%\logs\Report.txt"
Echo. __   __   __   __   __   __   __>> "%LOC8%\logs\Report.txt"

:: add list of Found updates
TYPE "%LOC8%\markers\FoundUpd.txt" >> "%LOC8%\logs\Report.txt"
Echo. __   __   __   __   __   __   __>> "%LOC8%\logs\Report.txt"

:: write a log file message
echo. >> "%LOC8%\logs\Report.txt"
echo. The report took %TempVar% to run.>> "%LOC8%\logs\Report.txt"
echo. The number of missing updates found during this search session: %NumIns%>> "%LOC8%\logs\Report.txt"
echo. %TYME% -- Auto-Patcher has finished compiling the report.>> "%LOC8%\logs\Report.txt"
echo +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++>> "%LOC8%\logs\Report.txt"
echo +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++>> "%LOC8%\logs\Report.txt"

:THATSIT
cls
echo.
echo.
echo.
echo.     That's it!
echo.
echo.   Auto-Patcher finished compiling the report at %TYME%
echo.  The number of missing updates found during this search session: %NumIns%
echo. The report took %TempVar% to run.
echo.
echo.   Please note: this only reflects what can be installed right at this moment
echo.  and also what Auto-Patcher currently has selected to check. Other updates
echo.   may also appear in the list once you have updated other components.
echo.
echo.            Press any key to exit and restart the program
echo.
echo.
echo.   [ CTRL-C will exit out without restarting or opening the report file ]
SET NEXT1=MkRepEn3
goto DELMARKS

:MkRepEn3
PAUSE >nul
IF %debug%!==Y! "%LOC8%\bin\NOTEPAD" "%LOC8%\logs\debug.txt"
"%LOC8%\bin\NOTEPAD" "%LOC8%\logs\Report.txt"
"%LOC8%\Start_Me.bat"
goto END

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: wait for computer to finish booting
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:WaitBoot
SET MyMsg=.. the computer finished rebooting and started Auto-Patcher.
"%LOC8%\bin\ASET" NHour := HOUR
FOR %%_ in (0 1 2 3 4 5 6 7 8 9) DO IF %NHour%==%%_ SET NHour=0%NHour%
"%LOC8%\bin\ASET" NMin := MINUTE
FOR %%_ in (0 1 2 3 4 5 6 7 8 9) DO IF %NMin%==%%_ SET NMin=0%NMin%
"%LOC8%\bin\ASET" NSec := SECOND
FOR %%_ in (0 1 2 3 4 5 6 7 8 9) DO IF %NSec%==%%_ SET NSec=0%NSec%
SET TYME=%NHour%:%NMin%:%NSec%
echo. %TYME% %MyMsg%>> "%LOC8%\logs\I_Result.Log"
DEL "%LOC8%\markers\@_WaitBT.tra" >nul
echo.
echo.
echo.  ***  Waiting for your computer to finish loading  ***
echo.
echo.    Press F when finished or just wait 15 seconds ...
echo.
Choice>nul /c:QfF /n /s /t:f,16
IF ERRORLEVEL 3 GOTO DoMenu
IF ERRORLEVEL 2 GOTO DoMenu
IF ERRORLEVEL 1 GOTO END
goto ErrChoic

:EndDebug
echo. >> "%LOC8%\logs\debug.txt"
echo. ++ The modules have all finished ++>> "%LOC8%\logs\debug.txt"
echo. >> "%LOC8%\logs\debug.txt"
echo. now dumping the contents of the marker folder into this debug file>> "%LOC8%\logs\debug.txt"
DIR /B "%LOC8%\markers\*.*">> "%LOC8%\logs\debug.txt"
echo. >> "%LOC8%\logs\debug.txt"
echo. That's it! No more debug info for you, my friend... see ya later!>> "%LOC8%\logs\debug.txt"
echo. +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++>> "%LOC8%\logs\debug.txt"
goto %NEXT1%

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:Go_Debug
echo. >> "%LOC8%\logs\debug.txt"
echo. Now running code inside %0>> "%LOC8%\logs\debug.txt"
echo. -- variables -->> "%LOC8%\logs\debug.txt"
echo. TRACK=%TRACK%>> "%LOC8%\logs\debug.txt"
echo. NEXT1=%NEXT1%>> "%LOC8%\logs\debug.txt"
echo. FILES=%FILES%>> "%LOC8%\logs\debug.txt"
goto GoModul2

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Error Handling
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:BadStart
echo.
echo.  Sorry, but there should have been a switch
echo.   loaded with this file that is missing!
echo.
echo.  Please report this to the homepage!
goto QUIT

:NOTIME
SET TYME=Time Unavailable
goto CLEANUP

:NONUMS
SET TempVar=Number Unavailable
goto PatchENN

:NOBAT
echo.
echo. I couldn't find the %LOC8%\%FILES%.bat file.
echo. Setup can't continue...sorry!
goto QUIT

:NOFILES
echo.
echo. I couldn'find the required setup files. Try cleaning the CD and trying again.
goto QUIT

:ERROR
echo.
echo. There was a very unusual error. Oh my goodness ...
echo.
echo. Setup can't continue, now exiting...
goto QUIT

:MISSING
echo.
echo. A program file needed for normal operation is MISSING.
echo. This is unexpected and will most likely mean something
echo.  will go wrong! Please EXIT out of everything!
goto QUIT

:RERROR
echo.
echo. There was an error. The debug value is: %ErrMsg%
echo.
echo. The good news is setup can recover from it.
echo.
PAUSE
goto %RECOVER%

:SERROR
echo.
echo. The module wasn't launched properly. Please use Check or Install after the command line.
echo.
echo. Setup can't continue, now exiting...
goto QUIT

:NOTWIN98
echo.
echo. This will only work with Windows 98 second edition.
echo.
echo.  Sorry!   Setup will now exit.
goto QUIT

:ErrChoic
echo.
echo. A choice function was not set properly causing this error.
echo. This is simply slack programming! That's naughty that is ....
goto QUIT

:DELMARKS
CTTY NUL
DELTREE /Y "%LOC8%\markers"
MD "%LOC8%\markers"
CTTY CON
goto %NEXT1%

:RBOOT
ECHO Y > "%LOC8%\markers\@_WaitBT.tra"
echo.
echo. The computer will now reboot ...
rem|choice>nul /c:d /n /t:d,1
Rundll32.exe shell32.dll,SHExitWindowsEx 2
goto END

:QUIT
echo.
echo. Please press any key to exit...
echo.
PAUSE >nul

:END
for %%! IN (TRACK FILES DELAY DOWHAT BOOTSTR) DO SET %%!=
CLS
EXIT
